/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Random;
import processing.core.PApplet;

public class FishGame
extends PApplet {
    static SpeciesDB db;
    GameManager GameManager;
    Random rng;

    public void setup() {
        this.windowMove(200, 80);
        db = new SpeciesDB();
        this.GameManager = new GameManager();
        this.rng = new Random();
    }

    public void draw() {
        this.GameManager._process();
    }

    public int randInt(int min, int max) {
        return (int)((float)(max - min) * this.rng.nextFloat()) + min;
    }

    public void settings() {
        this.size(960, 540);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"FishGame"};
        if (passedArgs != null) {
            PApplet.main((String[])FishGame.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    public class Aquarium
    extends Scene {
        int scroll;

        public Aquarium() {
            this.addChild(new NavButton(FishGame.this.width - 120, FishGame.this.height - 75, 200, 50, 3, "Back", 24).setVal(0));
            this.addChild(new ScrollButton(FishGame.this.width - 120, 100, 150, 50, 3, "UP", 24).setVal(2));
            this.addChild(new ScrollButton(FishGame.this.width - 120, 200, 150, 50, 3, "DOWN", 24).setVal(-2));
        }

        @Override
        public void ready() {
            this.scroll = 30;
        }

        @Override
        public void process() {
            FishGame.this.textAlign(37);
            FishGame.this.textSize(32.0f);
            String[] txt = this.getText();
            FishGame.this.text(txt[0], 10.0f, this.scroll);
            FishGame.this.text(txt[1], 330.0f, this.scroll);
            FishGame.this.text(txt[2], 450.0f, this.scroll);
            FishGame.this.text(txt[3], 570.0f, this.scroll);
        }

        public String[] getText() {
            String[] text = new String[]{"", "", "", ""};
            for (FishData fish : FishGame.this.GameManager.fish_caught) {
                text[0] = String.valueOf(text[0]) + fish.name + "\n";
                text[1] = String.valueOf(text[1]) + fish.getLen() + " in\n";
                text[2] = String.valueOf(text[2]) + fish.getSize() + " lb\n";
                text[3] = String.valueOf(text[3]) + fish.getRating() + "\n";
            }
            return text;
        }
    }

    public class Button
    extends Scene {
        private String name;
        private boolean lastFramePressed;
        int x;
        int y;
        int w;
        int h;
        boolean can_press;
        int align;
        private float x_mod;
        String text;
        int text_size;
        int text_color;
        int outline_color;
        int fill_normal;
        int fill_hover;
        int fill_press;

        public Button(int x_pos, int y_pos, int wid, int hei, int a, String t, int ts) {
            this.name = "Button";
            this.lastFramePressed = false;
            this.x = 0;
            this.y = 0;
            this.w = 1;
            this.h = 1;
            this.can_press = true;
            this.align = 3;
            this.text = "";
            this.text_size = 16;
            this.text_color = FishGame.this.color(0);
            this.outline_color = FishGame.this.color(0);
            this.fill_normal = FishGame.this.color(255);
            this.fill_hover = FishGame.this.color(204);
            this.fill_press = FishGame.this.color(127);
            this.x = x_pos;
            this.y = y_pos;
            this.w = wid;
            this.h = hei;
            this.setAlign(a);
            this.text = t;
            this.text_size = ts;
        }

        public Button(int x_pos, int y_pos, int wid, int hei, int a) {
            this.name = "Button";
            this.lastFramePressed = false;
            this.x = 0;
            this.y = 0;
            this.w = 1;
            this.h = 1;
            this.can_press = true;
            this.align = 3;
            this.text = "";
            this.text_size = 16;
            this.text_color = FishGame.this.color(0);
            this.outline_color = FishGame.this.color(0);
            this.fill_normal = FishGame.this.color(255);
            this.fill_hover = FishGame.this.color(204);
            this.fill_press = FishGame.this.color(127);
            this.x = x_pos;
            this.y = y_pos;
            this.w = wid;
            this.h = hei;
            this.setAlign(a);
        }

        public Button() {
            this.name = "Button";
            this.lastFramePressed = false;
            this.x = 0;
            this.y = 0;
            this.w = 1;
            this.h = 1;
            this.can_press = true;
            this.align = 3;
            this.text = "";
            this.text_size = 16;
            this.text_color = FishGame.this.color(0);
            this.outline_color = FishGame.this.color(0);
            this.fill_normal = FishGame.this.color(255);
            this.fill_hover = FishGame.this.color(204);
            this.fill_press = FishGame.this.color(127);
        }

        public void onHover() {
        }

        public void onPress() {
        }

        public void onJustPress() {
        }

        public void onRelease() {
        }

        @Override
        public void process() {
            if (this.isPressed()) {
                FishGame.this.fill(this.fill_press);
            } else if (this.isHovered()) {
                FishGame.this.fill(this.fill_hover);
            } else {
                FishGame.this.fill(this.fill_normal);
            }
            FishGame.this.stroke(this.outline_color);
            FishGame.this.rect((float)this.x - (float)this.w * this.x_mod, this.y, this.w, this.h);
            FishGame.this.fill(this.text_color);
            FishGame.this.textSize(this.text_size);
            FishGame.this.textAlign(this.align);
            FishGame.this.text(this.text, this.x, (2 * this.y + this.h) / 2 + this.text_size / 2);
            if (this.isHovered()) {
                this.onHover();
            }
            if (this.isPressed()) {
                this.onPress();
            }
            if (this.isJustPressed()) {
                this.onJustPress();
            }
            if (this.isJustReleased()) {
                this.onRelease();
            }
            this.lastFramePressed = this.isPressed();
        }

        public boolean isHovered() {
            return this.can_press && (float)FishGame.this.mouseX > (float)this.x - (float)this.w * this.x_mod && (float)FishGame.this.mouseX < (float)(this.x + this.w) - (float)this.w * this.x_mod && FishGame.this.mouseY > this.y && FishGame.this.mouseY < this.y + this.h;
        }

        public boolean isPressed() {
            return this.isHovered() && FishGame.this.mousePressed;
        }

        public boolean isJustPressed() {
            return this.isPressed() && !this.lastFramePressed;
        }

        public boolean isJustReleased() {
            return !this.isPressed() && this.lastFramePressed;
        }

        public void setCanPress(boolean can) {
            this.can_press = can;
        }

        public boolean getCanPress() {
            return this.can_press;
        }

        public void setAlign(int a) {
            this.align = a;
            switch (this.align) {
                case 37: {
                    this.x_mod = 0.0f;
                    break;
                }
                case 39: {
                    this.x_mod = 1.0f;
                    break;
                }
                case 3: {
                    this.x_mod = 0.5f;
                    break;
                }
                default: {
                    FishGame.println((String)"oopsies, setAlign() was called with a value it can't take.");
                }
            }
        }
    }

    public class FishData {
        Species species;
        String name;
        float len;
        float size;

        public FishData(Species spec, float l, float s) {
            this.species = spec;
            this.name = spec.species_name;
            this.len = l;
            this.size = s;
        }

        public String getName() {
            return this.name;
        }

        public float getLen() {
            return this.roundToTenths(this.len);
        }

        public float getSize() {
            return this.roundToTenths(this.size);
        }

        public float roundToTenths(float num) {
            int i = Math.round(num *= 10.0f);
            num = (float)i / 10.0f;
            return num;
        }

        public String getRating() {
            String desc = this.len < this.species.len_mean - this.species.len_sd * 3.0f ? "Micro-Fish" : (this.len < this.species.len_mean - this.species.len_sd * 1.5f ? "Tiny" : (this.len < this.species.len_mean - this.species.len_sd * 0.75f ? "Small" : (this.len < this.species.len_mean + this.species.len_sd * 0.75f ? "Average" : (this.len < this.species.len_mean + this.species.len_sd * 1.5f ? "Large" : (this.len < this.species.len_mean + this.species.len_sd * 3.0f ? "Giant" : "Super-Fish")))));
            return desc;
        }
    }

    public class FishSpotButton
    extends Button {
        public FishSpotButton(int x_pos, int y_pos, int wid, int hei, int a) {
            super(x_pos, y_pos, wid, hei, a);
        }

        @Override
        public void onJustPress() {
            ((GoFishing)this.getParent()).swapState(1);
        }

        @Override
        public void onRelease() {
            ((GoFishing)this.getParent()).button_state = 0;
        }

        @Override
        public void onPress() {
            ((GoFishing)this.getParent()).button_state = 1;
        }
    }

    public class FishingDialogue
    extends Scene {
        int x;
        int y;
        int y_mod;
        String dialogue;
        int lines;
        final int START_SCROLLING = 4;
        final int TEXT_SIZE = 24;
        final int TEXT_LEADING = 28;

        public FishingDialogue(int set_x, int set_y) {
            this.dialogue = "";
            this.lines = 0;
            this.START_SCROLLING = 4;
            this.TEXT_SIZE = 24;
            this.TEXT_LEADING = 28;
            this.x = set_x;
            this.y = set_y;
            this.y_mod = 0;
        }

        @Override
        public void process() {
            FishGame.this.textAlign(37);
            FishGame.this.textSize(24.0f);
            FishGame.this.fill(FishGame.this.color(0));
            FishGame.this.textLeading(28.0f);
            FishGame.this.text(this.dialogue, this.x, this.y + this.y_mod);
        }

        public void addLine(String line) {
            this.dialogue = String.valueOf(this.dialogue) + line + "\n";
            ++this.lines;
            if (this.lines > 4) {
                this.y_mod -= 28;
            }
        }
    }

    public class GameManager
    extends Scene {
        Scene MainMenu;
        Scene GoFishing;
        Scene Aquarium;
        Scene Info;
        int cur_scene;
        int scene_last_frame;
        ArrayList<FishData> fish_caught;
        final int bg_color;

        public GameManager() {
            this.cur_scene = 0;
            this.scene_last_frame = 0;
            this.bg_color = FishGame.this.color(204);
            this.MainMenu = this.addChild(new MainMenu().setName("Main Menu"));
            this.GoFishing = this.addChild(new GoFishing().setName("Go Fishing"));
            this.Aquarium = this.addChild(new Aquarium().setName("Aquarium"));
            this.Info = this.addChild(new Info().setName("Info"));
            this.fish_caught = new ArrayList();
            this.setCurrentScene(0);
        }

        @Override
        public void process() {
            FishGame.this.background(this.bg_color);
            if (this.scene_last_frame != this.cur_scene) {
                this.setCurrentScene(this.cur_scene);
            }
            this.scene_last_frame = this.cur_scene;
        }

        public void setCurrentScene(int scene) {
            if (scene == -1) {
                FishGame.this.exit();
            } else {
                for (Scene s : this.getChildren()) {
                    s.setVis(false);
                }
                this.getChild(scene).setVis(true);
            }
        }
    }

    public class GoFishing
    extends Scene {
        public FishingDialogue dialogue;
        public FishSpotButton button;
        int state;
        int last_state;
        int state_timer;
        int button_state;
        float mouseDist;
        float lastMouseX;
        float lastMouseY;
        float fish_stamina;
        int fish_time;
        final int TIMER_MIN = 180;
        final int TIMER_MAX = 600;

        public GoFishing() {
            this.state = 0;
            this.last_state = 0;
            this.state_timer = 0;
            this.button_state = 0;
            this.mouseDist = 0.0f;
            this.lastMouseX = -500.0f;
            this.lastMouseY = -500.0f;
            this.TIMER_MIN = 180;
            this.TIMER_MAX = 600;
            this.dialogue = (FishingDialogue)this.addChild(new FishingDialogue(10, 30));
            this.button = (FishSpotButton)this.addChild(new FishSpotButton(FishGame.this.width / 2, 150, 300, 300, 3));
            this.dialogue.addLine("Welcome to the Fishing Spot! Click and hold the tile to cast your line...");
            this.addChild(new NavButton(FishGame.this.width - 120, FishGame.this.height - 75, 200, 50, 3, "Back", 24).setVal(0));
        }

        @Override
        public void process() {
            switch (this.state) {
                case 1: {
                    if (this.button_state == 0) {
                        this.dialogue.addLine("Reeled in too early, no fish were biting.");
                        this.swapState(5);
                    }
                    if (this.state_timer < this.fish_time) break;
                    this.swapState(2);
                    break;
                }
                case 2: {
                    this.mouseDist += this.trackMouse();
                    if (this.mouseDist > this.fish_stamina) {
                        this.swapState(3);
                        break;
                    }
                    if (this.button_state != 0) break;
                    this.dialogue.addLine("Reeled in too early, the fish got away.");
                    this.swapState(5);
                    break;
                }
                case 3: {
                    if (this.button_state != 0) break;
                    this.swapState(4);
                    break;
                }
                case 4: {
                    if (this.state_timer <= 180) break;
                    this.swapState(0);
                    break;
                }
                case 5: {
                    if (this.state_timer <= 60) break;
                    this.swapState(0);
                    break;
                }
            }
            ++this.state_timer;
            this.last_state = this.state;
        }

        public void swapState(int s) {
            if (s != this.last_state) {
                this.state = s;
                this.state_timer = 0;
                switch (s) {
                    case 0: {
                        this.dialogue.addLine("Click and hold the tile to cast your line...");
                        this.mouseDist = 0.0f;
                        this.lastMouseX = -500.0f;
                        this.lastMouseY = -500.0f;
                        this.button.setCanPress(true);
                        break;
                    }
                    case 1: {
                        this.fish_time = FishGame.this.randInt(180, 600);
                        break;
                    }
                    case 2: {
                        this.dialogue.addLine("Something's on the line! Shake the mouse to reel it in!");
                        this.fish_stamina = FishGame.this.randInt(5000, 10000);
                        break;
                    }
                    case 3: {
                        this.dialogue.addLine("Caught it! Release the mouse to grab the fish off your hook.");
                        break;
                    }
                    case 4: {
                        Species newspec = db.getRandSpecies();
                        FishData newfish = newspec.makeFish();
                        FishGame.this.GameManager.fish_caught.add(newfish);
                        this.button.setCanPress(false);
                        String desc = newfish.len < newspec.len_mean - newspec.len_sd * 3.0f ? "It's super tiny for its species!" : (newfish.len < newspec.len_mean - newspec.len_sd * 1.5f ? "I've seen bigger." : (newfish.len < newspec.len_mean - newspec.len_sd * 0.75f ? "It's a tad on the small-side." : (newfish.len < newspec.len_mean + newspec.len_sd * 0.75f ? "" : (newfish.len < newspec.len_mean + newspec.len_sd * 1.5f ? "That's a bit larger than most!" : (newfish.len < newspec.len_mean + newspec.len_sd * 3.0f ? "That's a large fish!" : "That's incredible! It must be some sort of record!")))));
                        this.dialogue.addLine("You caught a " + newfish.getName() + "! It's " + newfish.getLen() + " inches long and weighs " + newfish.getSize() + " pounds. ");
                        if (desc == "") break;
                        this.dialogue.addLine(desc);
                        break;
                    }
                    case 5: {
                        this.button.setCanPress(false);
                    }
                }
            }
        }

        public float trackMouse() {
            float dist = 0.0f;
            if (this.lastMouseX > -300.0f && this.lastMouseY > -300.0f) {
                float x_diff = (float)FishGame.this.mouseX - this.lastMouseX;
                float y_diff = (float)FishGame.this.mouseY - this.lastMouseY;
                dist = FishGame.sqrt((float)(x_diff * x_diff + y_diff * y_diff));
            }
            this.lastMouseX = FishGame.this.mouseX;
            this.lastMouseY = FishGame.this.mouseY;
            return dist;
        }
    }

    public class Info
    extends Scene {
        public Info() {
            this.addChild(new NavButton(FishGame.this.width - 120, FishGame.this.height - 75, 200, 50, 3, "Back", 24).setVal(0));
        }

        @Override
        public void process() {
            FishGame.this.textSize(36.0f);
            FishGame.this.textAlign(37);
            FishGame.this.text("Info", 10.0f, 40.0f);
            FishGame.this.textSize(24.0f);
            FishGame.this.text("Designed and programmed by Jsaur.", 10.0f, 80.0f);
            FishGame.this.text("Visit jsaur.net for more games!", 10.0f, 120.0f);
            FishGame.this.text("Fish data collected from the South Carolina Department of Natural Resources.", 10.0f, 200.0f);
            FishGame.this.text("https://www.dnr.sc.gov/freshwater.html", 10.0f, 240.0f);
            FishGame.this.text("This game does not condone fishing for recreational or otherwise non-sustenence purposes.", 10.0f, 320.0f);
            FishGame.this.text("Please fish responsibly, ethically, and legally.", 10.0f, 360.0f);
            FishGame.this.textSize(12.0f);
            FishGame.this.text("If you're looking for instructions, they're built into the game. So just go play already!", 10.0f, 440.0f);
        }
    }

    public class MainMenu
    extends Scene {
        public MainMenu() {
            this.addChild(new NavButton(FishGame.this.width / 2, FishGame.this.height / 2, 200, 50, 3, "Go Fishing", 24).setVal(1));
            this.addChild(new NavButton(FishGame.this.width / 2, FishGame.this.height / 2 + 60, 200, 50, 3, "Aquarium", 24).setVal(2));
            this.addChild(new NavButton(FishGame.this.width / 2, FishGame.this.height / 2 + 120, 200, 50, 3, "Info", 24).setVal(3));
            this.addChild(new NavButton(FishGame.this.width / 2, FishGame.this.height / 2 + 180, 200, 50, 3, "Exit", 24).setVal(-1));
        }

        @Override
        public void process() {
            FishGame.this.text("Text-to-Fish", FishGame.this.width / 2, FishGame.this.height / 2 - 50);
        }
    }

    public class NavButton
    extends Button {
        private int scene_val;

        public NavButton(int x_pos, int y_pos, int wid, int hei, int a) {
            super(x_pos, y_pos, wid, hei, a);
        }

        public NavButton(int x_pos, int y_pos, int wid, int hei, int a, String t, int ts) {
            super(x_pos, y_pos, wid, hei, a, t, ts);
        }

        @Override
        public void onRelease() {
            FishGame.this.GameManager.cur_scene = this.scene_val;
        }

        public Button setVal(int v) {
            this.scene_val = v;
            return this;
        }
    }

    public abstract class Scene {
        private String name = "Scene";
        private ArrayList<Scene> children = new ArrayList();
        private Scene parent;
        private boolean visible = true;

        public Scene() {
        }

        public Scene(boolean vis) {
            this.visible = vis;
        }

        public Scene(String n) {
            this.name = n;
        }

        public void ready() {
        }

        public void process() {
        }

        public final void _process() {
            if (this.visible) {
                this.process();
                for (Scene s : this.getChildren()) {
                    s._process();
                }
            }
        }

        public ArrayList<Scene> getChildren() {
            return this.children;
        }

        public Scene getChild(int index) {
            return this.children.get(index);
        }

        public Scene addChild(Scene child) {
            child.setParent(this);
            this.children.add(child);
            return child;
        }

        public Scene findChild(String nam) {
            Scene s = null;
            int i = 0;
            while (i < this.getChildren().size() && s == null) {
                if (this.getChild(i).getName() == nam) {
                    s = this.getChild(i);
                }
                ++i;
            }
            return s;
        }

        public Scene removeChild(int index) {
            this.getChild(index).setParent(null);
            return this.children.remove(index);
        }

        public Scene getParent() {
            return this.parent;
        }

        public void setParent(Scene p) {
            this.parent = p;
        }

        public boolean getVis() {
            return this.visible;
        }

        public void setVis(boolean v) {
            this.visible = v;
            if (v) {
                this.ready();
            }
        }

        public String getName() {
            return this.name;
        }

        public Scene setName(String n) {
            this.name = n;
            return this;
        }
    }

    class ScrollButton
    extends Button {
        int val;

        public ScrollButton(int x_pos, int y_pos, int wid, int hei, int a, String t, int ts) {
            super(x_pos, y_pos, wid, hei, a, t, ts);
        }

        public Scene setVal(int v) {
            this.val = v;
            return this;
        }

        @Override
        public void onPress() {
            ((Aquarium)this.getParent()).scroll += this.val;
        }
    }

    public class Species {
        String species_name;
        String science_name;
        String description;
        float len_mean;
        float len_sd;
        float size_mean;
        float size_sd;

        public Species(String nam, String scinam, float len_min, float len_max, float siz_min, float siz_max, String desc) {
            float[] len_mean_sd = this.minMaxToMeanSD(len_min, len_max);
            float[] siz_mean_sd = this.minMaxToMeanSD(siz_min, siz_max);
            this.species_name = nam;
            this.science_name = scinam;
            this.len_mean = len_mean_sd[0];
            this.len_sd = len_mean_sd[1];
            this.size_mean = siz_mean_sd[0];
            this.size_sd = siz_mean_sd[1];
            this.description = desc;
        }

        public float[] minMaxToMeanSD(float min, float max) {
            float mean = (min + max) / 2.0f;
            float sd = min == max ? max - min : (mean > 5.0f ? 1.0f : mean / 5.0f);
            return new float[]{mean, sd};
        }

        public FishData makeFish() {
            float z = (float)FishGame.this.rng.nextGaussian();
            float l = z * this.len_sd + this.len_mean;
            float s = z * this.size_sd + this.size_mean;
            FishData fish = new FishData(this, l, s);
            return fish;
        }
    }

    public class SpeciesDB {
        final String DATA_PATH = "fish_freshwater.txt";
        public ArrayList<Species> species = this.importFishData("fish_freshwater.txt");

        public ArrayList<Species> importFishData(String filepath) {
            ArrayList<Species> thisData = new ArrayList();
            String[] orig = FishGame.this.loadStrings(filepath);
            ArrayList<String> lines = this.getDataLines(orig);
            thisData = this.getDataData(lines);
            return thisData;
        }

        public ArrayList<String> getDataLines(String[] orig) {
            ArrayList<String> lines = new ArrayList<String>();
            String[] stringArray = orig;
            int n = orig.length;
            int n2 = 0;
            while (n2 < n) {
                String check_line = stringArray[n2];
                if (check_line.length() > 0) {
                    switch (check_line.charAt(0)) {
                        case '#': {
                            break;
                        }
                        case '/': {
                            break;
                        }
                        default: {
                            lines.add(check_line);
                        }
                    }
                }
                ++n2;
            }
            return lines;
        }

        public ArrayList<Species> getDataData(ArrayList<String> lines) {
            ArrayList<Species> spec = new ArrayList<Species>();
            for (String line : lines) {
                String[] split = line.split(",");
                int i = 0;
                while (i < split.length) {
                    if (split[i].charAt(0) == ' ') {
                        split[i] = split[i].substring(1);
                    }
                    ++i;
                }
                spec.add(new Species(split[0], split[1], Float.valueOf(split[2]).floatValue(), Float.valueOf(split[3]).floatValue(), Float.valueOf(split[4]).floatValue(), Float.valueOf(split[5]).floatValue(), split[6]));
            }
            return spec;
        }

        public Species getRandSpecies() {
            return this.species.get(FishGame.this.randInt(0, this.species.size()));
        }
    }
}

