//Class for the aquarium scene, which allows the player to see the fish they have caught.
public class Aquarium extends Scene {
  
  int scroll;
  
  public Aquarium() {
    addChild( new NavButton(width - 120, height - 75, 200, 50, CENTER, "Back", 24).setVal(0) );
    addChild( new ScrollButton(width - 120, 100, 150, 50, CENTER, "UP", 24).setVal(2) );
    addChild( new ScrollButton(width - 120, 200, 150, 50, CENTER, "DOWN", 24).setVal(-2) );
  }
  
  void ready() {
    scroll = 30;
  }
  
  void process() {
    textAlign(LEFT);
    textSize(32);
    String[] txt = getText();
    text(txt[0], 10, scroll);
    text(txt[1], 330, scroll);
    text(txt[2], 450, scroll);
    text(txt[3], 570, scroll);
  }
  
  String[] getText() {
    String[] text = new String[]{"", "", "", ""};
    for (FishData fish : GameManager.fish_caught) {
      text[0] += fish.name + "\n";
      text[1] += fish.getLen() + " in\n";
      text[2] += fish.getSize() + " lb\n";
      text[3] += fish.getRating() + "\n";
    }
    return text;
  }
  
}

//Buttons that allow the player to scroll through the list of caught fish.
class ScrollButton extends Button {
  
  int val;
  
  public ScrollButton(int x_pos, int y_pos, int wid, int hei, int a, String t, int ts) {
    super(x_pos, y_pos, wid, hei, a, t, ts);
  }
  
  Scene setVal(int v) {
    val = v;
    return this;
  }
  
  void onPress() {
    ((Aquarium) getParent()).scroll += val;
  }
  
}
