//Class that contains all the data for a single instance of a fish.
public class FishData {
  
  //Species data for this fish.
  Species species;
  //Fish's given name by the player.
  String name;
  //Length, in inches, of this individual fish.
  float len;
  //Weight, in pounds, of this individual fish.
  float size;
  
  public FishData(Species spec, float l, float s) {
    species = spec;
    name = spec.species_name;
    len = l;
    size = s;
  }
  
  public String getName() {
    return name;
  }
  
  public float getLen() {
    return roundToTenths(len);
  }
  
  public float getSize() {
    return roundToTenths(size);
  }
  
  public float roundToTenths(float num) {
    num *= 10;
    int i = Math.round(num);
    num = ((float) i) / 10.;
    return num;
  }
  
  //Provides a desctiption for the fish's size based on its size variable in
  //comparison to the mean and standard deviation size of its species.
  public String getRating() {
    String desc;
    if (len < species.len_mean - species.len_sd *3) {
      desc = "Micro-Fish";
    }
    else if (len < species.len_mean - species.len_sd *1.5) {
      desc = "Tiny";
    }
    else if (len < species.len_mean - species.len_sd *0.75) {
      desc = "Small";
    }
    else if (len < species.len_mean + species.len_sd *0.75) {
      desc = "Average";
    }
    else if (len < species.len_mean + species.len_sd *1.5) {
      desc = "Large";
    }
    else if (len < species.len_mean + species.len_sd *3) {
      desc = "Giant";
    }
    else {
      desc = "Super-Fish";
    }
    return desc;
  }
  
}
