/* autogenerated by Processing revision 1293 on 2025-01-16 */
import processing.core.*;
import processing.data.*;
import processing.event.*;
import processing.opengl.*;

import java.util.Random;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import java.util.Random;

import java.util.HashMap;
import java.util.ArrayList;
import java.io.File;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;

public class FishGame extends PApplet {

//Fish game by Jsaur
//Version 1.0
//Feb 8 2024

/*
  In this project, in-depth comments are used solely for superclasses
  to describe the use of the functions of that class. For subclasses,
  comments are used at the header to describe the class as a whole,
  but in-depth comments are not frequently used for those since between
  the superclass comments and the description of the class in the header,
  the purpose of each class can be known.
  
  The most important documentation is in the Scene, Species, and SpeciesDB classes.
*/



static SpeciesDB db;
GameManager GameManager;
Random rng;

public void setup() {
  
  /* size commented out by preprocessor */;
  windowMove(200, 80);
  
  db = new SpeciesDB();
  GameManager = new GameManager();
  rng = new Random();
  
}

public void draw() {
  GameManager._process();
}

public int randInt(int min, int max) {
  return (int) ( (float) (max - min) * rng.nextFloat() ) + min;
}
//Class for the aquarium scene, which allows the player to see the fish they have caught.
public class Aquarium extends Scene {
  
  int scroll;
  
  public Aquarium() {
    addChild( new NavButton(width - 120, height - 75, 200, 50, CENTER, "Back", 24).setVal(0) );
    addChild( new ScrollButton(width - 120, 100, 150, 50, CENTER, "UP", 24).setVal(2) );
    addChild( new ScrollButton(width - 120, 200, 150, 50, CENTER, "DOWN", 24).setVal(-2) );
  }
  
  public void ready() {
    scroll = 30;
  }
  
  public void process() {
    textAlign(LEFT);
    textSize(32);
    String[] txt = getText();
    text(txt[0], 10, scroll);
    text(txt[1], 330, scroll);
    text(txt[2], 450, scroll);
    text(txt[3], 570, scroll);
  }
  
  public String[] getText() {
    String[] text = new String[]{"", "", "", ""};
    for (FishData fish : GameManager.fish_caught) {
      text[0] += fish.name + "\n";
      text[1] += fish.getLen() + " in\n";
      text[2] += fish.getSize() + " lb\n";
      text[3] += fish.getRating() + "\n";
    }
    return text;
  }
  
}

//Buttons that allow the player to scroll through the list of caught fish.
class ScrollButton extends Button {
  
  int val;
  
  public ScrollButton(int x_pos, int y_pos, int wid, int hei, int a, String t, int ts) {
    super(x_pos, y_pos, wid, hei, a, t, ts);
  }
  
  public Scene setVal(int v) {
    val = v;
    return this;
  }
  
  public void onPress() {
    ((Aquarium) getParent()).scroll += val;
  }
  
}
//Generic button class for all buttons to extend from.
public class Button extends Scene {
  private String name = "Button";
  private boolean lastFramePressed = false;
  
  int x = 0; //x-position
  int y = 0; //y-position
  int w = 1; //width
  int h = 1; //height
  
  boolean can_press = true;
  
  int align = CENTER;
  private float x_mod; //how much the shape needs to be shifted based on its align.
  
  String text = "";
  int text_size = 16;
  int text_color = color(0);
  
  int outline_color = color(0);
  int fill_normal = color(255);
  int fill_hover = color(204);
  int fill_press = color(127);
  
  public Button(int x_pos, int y_pos, int wid, int hei, int a, String t, int ts) {
    x = x_pos;
    y = y_pos;
    w = wid;
    h = hei;
    setAlign(a);
    text = t;
    text_size = ts;
  }
  
  public Button(int x_pos, int y_pos, int wid, int hei, int a) {
    x = x_pos;
    y = y_pos;
    w = wid;
    h = hei;
    setAlign(a);
  }
  
  public Button() {
  }
  
  //Methods that need to be filled out in a child class.
  public void onHover() {}
  public void onPress() {}
  public void onJustPress() {}
  public void onRelease() {}
  
  //When making a child, if you update the process, make sure to call super.process() at the top.
  //This process draws the button based on its current state.
  public void process() {
    
    if (isPressed())       fill(fill_press);
    else if (isHovered())  fill(fill_hover);
    else                   fill(fill_normal);
    stroke(outline_color);
    rect(x - w*x_mod, y, w, h);
    
    fill(text_color);
    textSize(text_size);
    textAlign(align);
    text(text, x, (2*y+h)/2 + text_size/2);
    
    if (isHovered()) onHover();
    if (isPressed()) onPress();
    if (isJustPressed()) onJustPress();
    if (isJustReleased()) onRelease();
    
    lastFramePressed = isPressed();
  }
  
  
  public boolean isHovered() {
    return can_press && mouseX > x - w*x_mod && mouseX < x + w - w*x_mod && mouseY > y && mouseY < y + h;
  }
  
  public boolean isPressed() {
    return (isHovered() && mousePressed);
  }
  
  public boolean isJustPressed() {
    return isPressed() && !lastFramePressed;
  }
  
  public boolean isJustReleased() {
    return !isPressed() && lastFramePressed;
  }
  
  public void setCanPress(boolean can) {
    can_press = can;
  }
  
  public boolean getCanPress() {
    return can_press;
  }
  
  //sets the align of both the button's rectangle relative to its position
  //coordinates as well as the alignment of the text.
  public void setAlign(int a) {
    align = a;
    switch (align) {
      case LEFT:
        x_mod = 0;
        break;
      case RIGHT:
        x_mod = 1;
        break;
      case CENTER:
        x_mod = 0.5f;
        break;
      default:
        println("oopsies, setAlign() was called with a value it can't take.");
    }
  }
  
}
//Class that contains all the data for a single instance of a fish.
public class FishData {
  
  //Species data for this fish.
  Species species;
  //Fish's given name by the player.
  String name;
  //Length, in inches, of this individual fish.
  float len;
  //Weight, in pounds, of this individual fish.
  float size;
  
  public FishData(Species spec, float l, float s) {
    species = spec;
    name = spec.species_name;
    len = l;
    size = s;
  }
  
  public String getName() {
    return name;
  }
  
  public float getLen() {
    return roundToTenths(len);
  }
  
  public float getSize() {
    return roundToTenths(size);
  }
  
  public float roundToTenths(float num) {
    num *= 10;
    int i = Math.round(num);
    num = ((float) i) / 10.f;
    return num;
  }
  
  //Provides a desctiption for the fish's size based on its size variable in
  //comparison to the mean and standard deviation size of its species.
  public String getRating() {
    String desc;
    if (len < species.len_mean - species.len_sd *3) {
      desc = "Micro-Fish";
    }
    else if (len < species.len_mean - species.len_sd *1.5f) {
      desc = "Tiny";
    }
    else if (len < species.len_mean - species.len_sd *0.75f) {
      desc = "Small";
    }
    else if (len < species.len_mean + species.len_sd *0.75f) {
      desc = "Average";
    }
    else if (len < species.len_mean + species.len_sd *1.5f) {
      desc = "Large";
    }
    else if (len < species.len_mean + species.len_sd *3) {
      desc = "Giant";
    }
    else {
      desc = "Super-Fish";
    }
    return desc;
  }
  
}
//Button that allows the player to interact with the fishing game.
public class FishSpotButton extends Button {
  
  
  public FishSpotButton(int x_pos, int y_pos, int wid, int hei, int a) {
    super(x_pos, y_pos, wid, hei, a);
  }
  
  public void onJustPress() {
    ((GoFishing) getParent()).swapState(1);
  }
  
  public void onRelease() {
    ((GoFishing) getParent()).button_state = 0;
  }
  
  public void onPress() {
    ((GoFishing) getParent()).button_state = 1;
  }
  
}
//Describes what is happening in the game to the player and provides
//instructions so the player can know what to do.
public class FishingDialogue extends Scene {
  
  int x;
  int y;
  int y_mod;
  
  String dialogue = "";
  int lines = 0;
  
  final int START_SCROLLING = 4;
  final int TEXT_SIZE = 24;
  final int TEXT_LEADING = 28;
  
  public FishingDialogue(int set_x, int set_y) {
    x = set_x;
    y = set_y;
    y_mod = 0;
  }
  
  public void process() {
    textAlign(LEFT);
    textSize(TEXT_SIZE);
    fill(color(0));
    textLeading(TEXT_LEADING);
    text(dialogue, x, y + y_mod);
  }
  
  public void addLine(String line) {
    dialogue += line + "\n";
    lines += 1;
    if (lines > START_SCROLLING)
      y_mod -= TEXT_LEADING;
  }
  
}
//Contains each screen for the game and swaps between them based on
//what cur_scene says it should be.
public class GameManager extends Scene {
  
  //Scene -1: exit
  Scene MainMenu; //Scene 0
  Scene GoFishing; //Scene 1
  Scene Aquarium; //Scene 2
  Scene Info; //Scene 3
  
  int cur_scene = 0; //The currently active scene.
  int scene_last_frame = 0; //Last frame's active scene.
  
  //contains all the fishies caught.
  ArrayList<FishData> fish_caught;
  
  final int bg_color = color(204);
  
  public GameManager() {
    MainMenu = addChild( new MainMenu().setName("Main Menu") );
    GoFishing = addChild( new GoFishing().setName("Go Fishing") );
    Aquarium = addChild( new Aquarium().setName("Aquarium") );
    Info = addChild( new Info().setName("Info") );
    
    fish_caught = new ArrayList<FishData>();
    
    setCurrentScene(0);
  }
  
  public void process() {
    
    background(bg_color);
    
    if (scene_last_frame != cur_scene)
      setCurrentScene(cur_scene);
    
    scene_last_frame = cur_scene;
    
  }
  
  public void setCurrentScene(int scene) {
    
    if (scene == -1) exit();
    
    else {
      for (Scene s : getChildren()) {
        s.setVis(false);
      }
      getChild(scene).setVis(true);
    }
    
  }
  
}
//Class that contains the game logic.
public class GoFishing extends Scene {
  
  public FishingDialogue dialogue;
  public FishSpotButton button;
  
  int state = 0;
  int last_state = 0;
  int state_timer = 0;
  //0: start
  //1: line is cast
  //2: fish has bit
  //3: time to release fish
  //4: fish has been caught
  //5: fish got away :(
  
  int button_state = 0;
  //0: released
  //1: pressed
  
  float mouseDist = 0;
  float lastMouseX = -500;
  float lastMouseY = -500;
  
  float fish_stamina;
  int fish_time;
  
  //minimum and maximum time until a fish is on the line, in frames.
  final int TIMER_MIN = 180;
  final int TIMER_MAX = 600;
  
  public GoFishing() {
    dialogue = (FishingDialogue) addChild( new FishingDialogue(10, 30) );
    button = (FishSpotButton) addChild( new FishSpotButton(width/2, 150, 300, 300, CENTER) );
    
    dialogue.addLine("Welcome to the Fishing Spot! Click and hold the tile to cast your line...");
    
    addChild( new NavButton(width - 120, height - 75, 200, 50, CENTER, "Back", 24).setVal(0) );
  }
  
  //what each state does every frame.
  public void process() {
    switch(state) {
      case 1:
        if (button_state == 0) {
          dialogue.addLine("Reeled in too early, no fish were biting.");
          swapState(5);
        }
        if (state_timer >= fish_time) {
          swapState(2);
        }
        break;
      case 2:
        mouseDist += trackMouse();
        if (mouseDist > fish_stamina) {
          swapState(3);
        }
        else if (button_state == 0) {
          dialogue.addLine("Reeled in too early, the fish got away.");
          swapState(5);
        }
        break;
      case 3:
        if (button_state == 0) {
          swapState(4);
        }
        break;
      case 4:
        if (state_timer > 180) {
          swapState(0);
        }
        break;
      case 5:
        if (state_timer > 60) {
          swapState(0);
        }
        break;
      default:
        break;
    }
    state_timer++;
    last_state = state;
  }
  
  //contains the logic for when the state first changes.
  public void swapState(int s) {
    if (s != last_state) {
      state = s;
      state_timer = 0;
      switch (s) {
        case 0:
          dialogue.addLine("Click and hold the tile to cast your line...");
          mouseDist = 0;
          lastMouseX = -500;
          lastMouseY = -500;
          button.setCanPress(true);
          break;
        case 1:
          fish_time = randInt(TIMER_MIN, TIMER_MAX);
          break;
        case 2:
          dialogue.addLine("Something's on the line! Shake the mouse to reel it in!");
          fish_stamina = randInt(5000, 10000);
          break;
        case 3:
          dialogue.addLine("Caught it! Release the mouse to grab the fish off your hook.");
          break;
        case 4:
          Species newspec = db.getRandSpecies();
          FishData newfish = newspec.makeFish();
          GameManager.fish_caught.add(newfish);
          button.setCanPress(false);
          
          String desc;
          
          if (newfish.len < newspec.len_mean - newspec.len_sd *3) {
            desc = "It's super tiny for its species!";
          }
          else if (newfish.len < newspec.len_mean - newspec.len_sd *1.5f) {
            desc = "I've seen bigger.";
          }
          else if (newfish.len < newspec.len_mean - newspec.len_sd *0.75f) {
            desc = "It's a tad on the small-side.";
          }
          else if (newfish.len < newspec.len_mean + newspec.len_sd *0.75f) {
            desc = "";
          }
          else if (newfish.len < newspec.len_mean + newspec.len_sd *1.5f) {
            desc = "That's a bit larger than most!";
          }
          else if (newfish.len < newspec.len_mean + newspec.len_sd *3) {
            desc = "That's a large fish!";
          }
          else {
            desc = "That's incredible! It must be some sort of record!";
          }
          
          dialogue.addLine("You caught a " + newfish.getName() + "! It's " + newfish.getLen() + " inches long and weighs " + newfish.getSize() + " pounds. ");
          if (desc != "") dialogue.addLine(desc);
          break;
        
        case 5:
          button.setCanPress(false);
          break;
      }
    }
  }
  
  //Returns the absolute value of the difference between where
  //the mouse is and where it was last frame.
  public float trackMouse() {
    float dist = 0;
    
    if (lastMouseX > -300 && lastMouseY > -300) {
      
      float x_diff = mouseX-lastMouseX;
      float y_diff = mouseY-lastMouseY;
      dist = sqrt((x_diff*x_diff)+(y_diff*y_diff));
      
    }
    
    lastMouseX = mouseX;
    lastMouseY = mouseY;
    return dist;
  }
  
}
//Screen for showing the credits and additional information.
public class Info extends Scene {
  
  
  public Info() {
    addChild( new NavButton(width - 120, height - 75, 200, 50, CENTER, "Back", 24).setVal(0) );
  }
  
  public void process() {
    textSize(36);
    textAlign(LEFT);
    text("Info", 10, 40);
    
    textSize(24);
    text("Designed and programmed by Jsaur.", 10, 80);
    text("Visit jsaur.net for more games!", 10, 120);
    
    text("Fish data collected from the South Carolina Department of Natural Resources.", 10, 200);
    text("https://www.dnr.sc.gov/freshwater.html", 10, 240);
    
    text("This game does not condone fishing for recreational or otherwise non-sustenence purposes.", 10, 320);
    text("Please fish responsibly, ethically, and legally.", 10, 360);
    
    textSize(12);
    text("If you're looking for instructions, they're built into the game. So just go play already!", 10, 440);
    
  }
  
}
//Scene that contains buttons to travel to the other screens.
public class MainMenu extends Scene {
  
  public MainMenu() {
    
    addChild( new NavButton(width/2, height/2, 200, 50, CENTER, "Go Fishing", 24).setVal(1) );
    addChild( new NavButton(width/2, height/2 + 60, 200, 50, CENTER, "Aquarium", 24).setVal(2) );
    addChild( new NavButton(width/2, height/2 + 120, 200, 50, CENTER, "Info", 24).setVal(3) );
    addChild( new NavButton(width/2, height/2 + 180, 200, 50, CENTER, "Exit", 24).setVal(-1) );
    
  }
  
  public void process() {
    text("Text-to-Fish", width/2, height/2 - 50);
  }
  
}
//Button for navigating between scenes.
public class NavButton extends Button {
  
  private int scene_val;
  
  public NavButton(int x_pos, int y_pos, int wid, int hei, int a) {
    super(x_pos, y_pos, wid, hei, a);
  }
  
  public NavButton(int x_pos, int y_pos, int wid, int hei, int a, String t, int ts) {
    super(x_pos, y_pos, wid, hei, a, t, ts);
  }
  
  public void onRelease() {
    GameManager.cur_scene = scene_val;
  }
  
  public Button setVal(int v) {
    scene_val = v;
    return this;
  }
  
}
//Generic class that mimics the scene system in the Godot engine.
//Every object used in this project will inherit this class, which allows them
//to interact with each other in a fluid way based on Godot's node tree system.
abstract public class Scene {
  
  private String name = "Scene";
  private ArrayList<Scene> children = new ArrayList<Scene>();
  private Scene parent;
  private boolean visible = true;
  
  public Scene() {
  }
  
  public Scene(boolean vis) {
    visible = vis;
  }
  
  public Scene(String n) {
    name = n;
  }
  
  //Called each time a scene becomes visible.
  //Meant to be overwritten by the child class.
  public void ready() {
  }
  
  //Called every frame as long as the scene is visible.
  //Meant to be overwritten by the child class.
  public void process() {
  }
  
  //Function that allows the process function to work.
  final public void _process() {
    if (visible) {
      process();
      for (Scene s : getChildren()) {
        s._process();
      }
    }
  }
  
  //Returns the array of scenes that are children of this scene.
  public ArrayList<Scene> getChildren() {
    return children;
  }
  
  //Returns a single child scene based on its index.
  public Scene getChild(int index) {
    return children.get(index);
  }
  
  //Adds an additional child scene and returns said scene.
  public Scene addChild(Scene child) {
    child.setParent(this);
    children.add(child);
    return child;
  }
  
  //Traverses the scene tree starting with this scene
  //and returns the first instance of a scene with the 
  //desired name, or null if it doesn't exist.
  public Scene findChild(String nam) {
    Scene s = null;
    int i = 0;
    while (i < getChildren().size() && s == null) {
      if (getChild(i).getName() == nam) {
        s = getChild(i);
      }
      i++;
    }
    return s;
  }
  
  //Removes and returns a child scene based on its index.
  public Scene removeChild(int index) {
    getChild(index).setParent(null);
    return children.remove(index);
  }
  
  //Returns the parent scene of this scene.
  //To access the parent scene's functions, you must
  //convert it to its specific subclass first.
  public Scene getParent() {
    return parent;
  }
  
  //Sets this scene's parent to a new parent scene.
  public void setParent(Scene p) {
    parent = p;
  }
  
  public boolean getVis() {
    return visible;
  }
  
  public void setVis(boolean v) {
    visible = v;
    if (v) ready();
  }
  
  public String getName() {
    return name;
  }
  
  //Returns the scene so that you can declare the name of a scene when created without a constructor and set it to a child all in one line.
  public Scene setName(String n) {
    name = n;
    return this;
  }
  
}
//Class containing data for a species of fish.
public class Species {
  
  //Name of the species of fish.
  String species_name;
  
  //Scientific name of the species of fish.
  String science_name;
  
  //Description of da-fish-ion (get it?)
  String description;
  
  //Mean length of this species of fish in inches.
  float len_mean;
  
  //Standard deviation of the length of this species of fish in inches.
  float len_sd;
  
  //Mean weight of this species of fish in pounds.
  float size_mean;
  
  //Standard deviation of the size of this species of fish in pounds.
  float size_sd;
  
  public Species(String nam, String scinam, float len_min, float len_max, float siz_min, float siz_max, String desc) {
    
    float[] len_mean_sd = minMaxToMeanSD(len_min, len_max);
    float[] siz_mean_sd = minMaxToMeanSD(siz_min, siz_max);
    
    species_name = nam;
    science_name = scinam;
    len_mean = len_mean_sd[0];
    len_sd =   len_mean_sd[1];
    size_mean = siz_mean_sd[0];
    size_sd =   siz_mean_sd[1];
    description = desc;
  }
  
  //takes a minimum and maximum value and returns a mean and standard deviation.
  //The mean will be the center of the minimum and maximum.
  //The standard deviation will be (2/3) the distance from the center to the maximum.
  public float[] minMaxToMeanSD(float min, float max) {
    float mean =  (min + max) / 2;
    float sd;
    //If there was only a single number given for the average and not a range,
    //we need to make up a standard deviation.
    //This will be 1 when mean>5 and mean/5 otherwise.
    if (min == max) sd = max - min;
    else {
      if (mean > 5) sd = 1.f;
      else sd = mean/5.f;
    }
    
    return new float[]{mean, sd};
  }
  
  //Returns the data for an individual fish based on this species.
  public FishData makeFish() {
    
    float z = (float) rng.nextGaussian();
    float l = ((float) z * len_sd) + len_mean;
    float s = ((float) z * size_sd) + size_mean;
    
    FishData fish = new FishData(this, l, s);
    return fish;
  }
  
}
/*
- Species database. Contains all the info for fish species.
- Data taken from the South Carolina Department of Natural Resources https://www.dnr.sc.gov/freshwater.html
- Note: I assume that when given a range for Average length, the mean is in
        the center and the minimum and maximum values are 1.5 standard
        deviations away from the mean. If the average given is a single number
        and not a range, then the standard deviation will be 1.
*/





public class SpeciesDB {
  
  //leads to text file with correctly-formatted fish data.
  final String DATA_PATH = "fish_freshwater.txt";
  
  public ArrayList<Species> species;
  
  public SpeciesDB() {
    species = importFishData(DATA_PATH);
  }
  
  //Called immediately upon starting. Reads the input text file for the fish data and puts it into data for the game.
  public ArrayList<Species> importFishData(String filepath) {
    ArrayList<Species> thisData = new ArrayList<Species>();
    
    String[] orig = loadStrings(filepath);
    ArrayList<String> lines = getDataLines(orig);
    thisData = getDataData(lines);
    
    return thisData;
  }
  
  //Takes a list of the lines of the input file for fish data and returns a list of its non-comment lines.
  public ArrayList<String> getDataLines(String[] orig) {
    
    ArrayList<String> lines = new ArrayList<String>();
    
    for (String check_line : orig) {
      
      if (check_line.length() > 0) {
      
        switch (check_line.charAt(0)) {
          // '#' is a comment: ignore this line.
          case '#':
            break;
          // '/' denotes a section, this may be used later for something but not yet.
          case '/':
            break;
          // Otherwise, it's a piece of fishy data! Yay! Add it to the list.
          default:
            lines.add(check_line);
            break;
        }
      }
    }
      
    return lines;
  }
  
  
  public ArrayList<Species> getDataData(ArrayList<String> lines) {
    ArrayList<Species> spec = new ArrayList<Species>();
    for (String line : lines) {
      String[] split = line.split(",");
      
      for (int i = 0; i < split.length; i++) {
        if (split[i].charAt(0) == ' ') split[i] = split[i].substring(1);
      }
      
      spec.add( new Species( split[0], split[1], Float.valueOf(split[2]), Float.valueOf(split[3]), Float.valueOf(split[4]), Float.valueOf(split[5]), split[6] ) );
    }
    
    return spec;
  }
  
  //pulls a random fish species.
  public Species getRandSpecies() {
    return species.get( randInt(0, species.size()) );
  }
  
}


  public void settings() { size(960, 540); }

  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "FishGame" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
