//Fish game by Jsaur
//Version 1.0
//Feb 8 2024

/*
  In this project, in-depth comments are used solely for superclasses
  to describe the use of the functions of that class. For subclasses,
  comments are used at the header to describe the class as a whole,
  but in-depth comments are not frequently used for those since between
  the superclass comments and the description of the class in the header,
  the purpose of each class can be known.
  
  The most important documentation is in the Scene, Species, and SpeciesDB classes.
*/

import java.util.Random;

static SpeciesDB db;
GameManager GameManager;
Random rng;

void setup() {
  
  size(960, 540);
  windowMove(200, 80);
  
  db = new SpeciesDB();
  GameManager = new GameManager();
  rng = new Random();
  
}

void draw() {
  GameManager._process();
}

int randInt(int min, int max) {
  return (int) ( (float) (max - min) * rng.nextFloat() ) + min;
}
