//Describes what is happening in the game to the player and provides
//instructions so the player can know what to do.
public class FishingDialogue extends Scene {
  
  int x;
  int y;
  int y_mod;
  
  String dialogue = "";
  int lines = 0;
  
  final int START_SCROLLING = 4;
  final int TEXT_SIZE = 24;
  final int TEXT_LEADING = 28;
  
  public FishingDialogue(int set_x, int set_y) {
    x = set_x;
    y = set_y;
    y_mod = 0;
  }
  
  void process() {
    textAlign(LEFT);
    textSize(TEXT_SIZE);
    fill(color(0));
    textLeading(TEXT_LEADING);
    text(dialogue, x, y + y_mod);
  }
  
  public void addLine(String line) {
    dialogue += line + "\n";
    lines += 1;
    if (lines > START_SCROLLING)
      y_mod -= TEXT_LEADING;
  }
  
}
