//Contains each screen for the game and swaps between them based on
//what cur_scene says it should be.
public class GameManager extends Scene {
  
  //Scene -1: exit
  Scene MainMenu; //Scene 0
  Scene GoFishing; //Scene 1
  Scene Aquarium; //Scene 2
  Scene Info; //Scene 3
  
  int cur_scene = 0; //The currently active scene.
  int scene_last_frame = 0; //Last frame's active scene.
  
  //contains all the fishies caught.
  ArrayList<FishData> fish_caught;
  
  final color bg_color = color(204);
  
  public GameManager() {
    MainMenu = addChild( new MainMenu().setName("Main Menu") );
    GoFishing = addChild( new GoFishing().setName("Go Fishing") );
    Aquarium = addChild( new Aquarium().setName("Aquarium") );
    Info = addChild( new Info().setName("Info") );
    
    fish_caught = new ArrayList<FishData>();
    
    setCurrentScene(0);
  }
  
  public void process() {
    
    background(bg_color);
    
    if (scene_last_frame != cur_scene)
      setCurrentScene(cur_scene);
    
    scene_last_frame = cur_scene;
    
  }
  
  void setCurrentScene(int scene) {
    
    if (scene == -1) exit();
    
    else {
      for (Scene s : getChildren()) {
        s.setVis(false);
      }
      getChild(scene).setVis(true);
    }
    
  }
  
}
