//Class that contains the game logic.
public class GoFishing extends Scene {
  
  public FishingDialogue dialogue;
  public FishSpotButton button;
  
  int state = 0;
  int last_state = 0;
  int state_timer = 0;
  //0: start
  //1: line is cast
  //2: fish has bit
  //3: time to release fish
  //4: fish has been caught
  //5: fish got away :(
  
  int button_state = 0;
  //0: released
  //1: pressed
  
  float mouseDist = 0;
  float lastMouseX = -500;
  float lastMouseY = -500;
  
  float fish_stamina;
  int fish_time;
  
  //minimum and maximum time until a fish is on the line, in frames.
  final int TIMER_MIN = 180;
  final int TIMER_MAX = 600;
  
  public GoFishing() {
    dialogue = (FishingDialogue) addChild( new FishingDialogue(10, 30) );
    button = (FishSpotButton) addChild( new FishSpotButton(width/2, 150, 300, 300, CENTER) );
    
    dialogue.addLine("Welcome to the Fishing Spot! Click and hold the tile to cast your line...");
    
    addChild( new NavButton(width - 120, height - 75, 200, 50, CENTER, "Back", 24).setVal(0) );
  }
  
  //what each state does every frame.
  void process() {
    switch(state) {
      case 1:
        if (button_state == 0) {
          dialogue.addLine("Reeled in too early, no fish were biting.");
          swapState(5);
        }
        if (state_timer >= fish_time) {
          swapState(2);
        }
        break;
      case 2:
        mouseDist += trackMouse();
        if (mouseDist > fish_stamina) {
          swapState(3);
        }
        else if (button_state == 0) {
          dialogue.addLine("Reeled in too early, the fish got away.");
          swapState(5);
        }
        break;
      case 3:
        if (button_state == 0) {
          swapState(4);
        }
        break;
      case 4:
        if (state_timer > 180) {
          swapState(0);
        }
        break;
      case 5:
        if (state_timer > 60) {
          swapState(0);
        }
        break;
      default:
        break;
    }
    state_timer++;
    last_state = state;
  }
  
  //contains the logic for when the state first changes.
  void swapState(int s) {
    if (s != last_state) {
      state = s;
      state_timer = 0;
      switch (s) {
        case 0:
          dialogue.addLine("Click and hold the tile to cast your line...");
          mouseDist = 0;
          lastMouseX = -500;
          lastMouseY = -500;
          button.setCanPress(true);
          break;
        case 1:
          fish_time = randInt(TIMER_MIN, TIMER_MAX);
          break;
        case 2:
          dialogue.addLine("Something's on the line! Shake the mouse to reel it in!");
          fish_stamina = randInt(5000, 10000);
          break;
        case 3:
          dialogue.addLine("Caught it! Release the mouse to grab the fish off your hook.");
          break;
        case 4:
          Species newspec = db.getRandSpecies();
          FishData newfish = newspec.makeFish();
          GameManager.fish_caught.add(newfish);
          button.setCanPress(false);
          
          String desc;
          
          if (newfish.len < newspec.len_mean - newspec.len_sd *3) {
            desc = "It's super tiny for its species!";
          }
          else if (newfish.len < newspec.len_mean - newspec.len_sd *1.5) {
            desc = "I've seen bigger.";
          }
          else if (newfish.len < newspec.len_mean - newspec.len_sd *0.75) {
            desc = "It's a tad on the small-side.";
          }
          else if (newfish.len < newspec.len_mean + newspec.len_sd *0.75) {
            desc = "";
          }
          else if (newfish.len < newspec.len_mean + newspec.len_sd *1.5) {
            desc = "That's a bit larger than most!";
          }
          else if (newfish.len < newspec.len_mean + newspec.len_sd *3) {
            desc = "That's a large fish!";
          }
          else {
            desc = "That's incredible! It must be some sort of record!";
          }
          
          dialogue.addLine("You caught a " + newfish.getName() + "! It's " + newfish.getLen() + " inches long and weighs " + newfish.getSize() + " pounds. ");
          if (desc != "") dialogue.addLine(desc);
          break;
        
        case 5:
          button.setCanPress(false);
          break;
      }
    }
  }
  
  //Returns the absolute value of the difference between where
  //the mouse is and where it was last frame.
  float trackMouse() {
    float dist = 0;
    
    if (lastMouseX > -300 && lastMouseY > -300) {
      
      float x_diff = mouseX-lastMouseX;
      float y_diff = mouseY-lastMouseY;
      dist = sqrt((x_diff*x_diff)+(y_diff*y_diff));
      
    }
    
    lastMouseX = mouseX;
    lastMouseY = mouseY;
    return dist;
  }
  
}
