//Class containing data for a species of fish.
public class Species {
  
  //Name of the species of fish.
  String species_name;
  
  //Scientific name of the species of fish.
  String science_name;
  
  //Description of da-fish-ion (get it?)
  String description;
  
  //Mean length of this species of fish in inches.
  float len_mean;
  
  //Standard deviation of the length of this species of fish in inches.
  float len_sd;
  
  //Mean weight of this species of fish in pounds.
  float size_mean;
  
  //Standard deviation of the size of this species of fish in pounds.
  float size_sd;
  
  public Species(String nam, String scinam, float len_min, float len_max, float siz_min, float siz_max, String desc) {
    
    float[] len_mean_sd = minMaxToMeanSD(len_min, len_max);
    float[] siz_mean_sd = minMaxToMeanSD(siz_min, siz_max);
    
    species_name = nam;
    science_name = scinam;
    len_mean = len_mean_sd[0];
    len_sd =   len_mean_sd[1];
    size_mean = siz_mean_sd[0];
    size_sd =   siz_mean_sd[1];
    description = desc;
  }
  
  //takes a minimum and maximum value and returns a mean and standard deviation.
  //The mean will be the center of the minimum and maximum.
  //The standard deviation will be (2/3) the distance from the center to the maximum.
  public float[] minMaxToMeanSD(float min, float max) {
    float mean =  (min + max) / 2;
    float sd;
    //If there was only a single number given for the average and not a range,
    //we need to make up a standard deviation.
    //This will be 1 when mean>5 and mean/5 otherwise.
    if (min == max) sd = max - min;
    else {
      if (mean > 5) sd = 1.;
      else sd = mean/5.;
    }
    
    return new float[]{mean, sd};
  }
  
  //Returns the data for an individual fish based on this species.
  public FishData makeFish() {
    
    float z = (float) rng.nextGaussian();
    float l = ((float) z * len_sd) + len_mean;
    float s = ((float) z * size_sd) + size_mean;
    
    FishData fish = new FishData(this, l, s);
    return fish;
  }
  
}
