/*
- Species database. Contains all the info for fish species.
- Data taken from the South Carolina Department of Natural Resources https://www.dnr.sc.gov/freshwater.html
- Note: I assume that when given a range for Average length, the mean is in
        the center and the minimum and maximum values are 1.5 standard
        deviations away from the mean. If the average given is a single number
        and not a range, then the standard deviation will be 1.
*/
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import java.util.Random;

public class SpeciesDB {
  
  //leads to text file with correctly-formatted fish data.
  final String DATA_PATH = "fish_freshwater.txt";
  
  public ArrayList<Species> species;
  
  public SpeciesDB() {
    species = importFishData(DATA_PATH);
  }
  
  //Called immediately upon starting. Reads the input text file for the fish data and puts it into data for the game.
  ArrayList<Species> importFishData(String filepath) {
    ArrayList<Species> thisData = new ArrayList<Species>();
    
    String[] orig = loadStrings(filepath);
    ArrayList<String> lines = getDataLines(orig);
    thisData = getDataData(lines);
    
    return thisData;
  }
  
  //Takes a list of the lines of the input file for fish data and returns a list of its non-comment lines.
  ArrayList<String> getDataLines(String[] orig) {
    
    ArrayList<String> lines = new ArrayList<String>();
    
    for (String check_line : orig) {
      
      if (check_line.length() > 0) {
      
        switch (check_line.charAt(0)) {
          // '#' is a comment: ignore this line.
          case '#':
            break;
          // '/' denotes a section, this may be used later for something but not yet.
          case '/':
            break;
          // Otherwise, it's a piece of fishy data! Yay! Add it to the list.
          default:
            lines.add(check_line);
            break;
        }
      }
    }
      
    return lines;
  }
  
  
  ArrayList<Species> getDataData(ArrayList<String> lines) {
    ArrayList<Species> spec = new ArrayList<Species>();
    for (String line : lines) {
      String[] split = line.split(",");
      
      for (int i = 0; i < split.length; i++) {
        if (split[i].charAt(0) == ' ') split[i] = split[i].substring(1);
      }
      
      spec.add( new Species( split[0], split[1], Float.valueOf(split[2]), Float.valueOf(split[3]), Float.valueOf(split[4]), Float.valueOf(split[5]), split[6] ) );
    }
    
    return spec;
  }
  
  //pulls a random fish species.
  public Species getRandSpecies() {
    return species.get( randInt(0, species.size()) );
  }
  
}
