/* autogenerated by Processing revision 1293 on 2025-01-16 */
import processing.core.*;
import processing.data.*;
import processing.event.*;
import processing.opengl.*;

import java.util.Random;

import java.util.HashMap;
import java.util.ArrayList;
import java.io.File;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;

public class JavaGame extends PApplet {

//Java game by Jsaur
//Version 1.0
//Feb 15 2024

/*
  In this project, in-depth comments are used solely for superclasses
  to describe the use of the functions of that class. For subclasses,
  comments are used at the header to describe the class as a whole,
  but in-depth comments are not frequently used for those since between
  the superclass comments and the description of the class in the header,
  the purpose of each class can be known.
  
  The most important documentation is in the Scene and Play classes.
*/



GameManager gameManager;
Random rng;

//keyboard input. resets when the room changes to Play.
String kb_text;

//Number of happy customers.
int wins = 0;

public void setup() {
  /* size commented out by preprocessor */;
  windowMove(200, 80);
  
  rng = new Random();
  gameManager = new GameManager();
}

public void draw() {
  gameManager._process();
}

public void keyPressed() {
  if (gameManager.getCurrentScene() == 1) {
    if (key == BACKSPACE) kb_text = kb_text.substring(0, max(0, kb_text.length()-1));
    else if (key == ENTER || key == RETURN) ((Play)(gameManager.play)).CheckAnswer(kb_text);
    else if (key != CODED) kb_text += key;
  }
}
//Generic button class for all buttons to extend from.
//Imported from my FishGame project.
class Button extends Scene {
  private String name = "Button";
  private boolean lastFramePressed = false;
  
  int x = 0; //x-position
  int y = 0; //y-position
  int w = 1; //width
  int h = 1; //height
  
  boolean can_press = true;
  
  int align = CENTER;
  private float x_mod; //how much the shape needs to be shifted based on its align.
  
  String text = "";
  int text_size = 16;
  int text_color = color(0);
  
  int outline_color = color(0);
  int fill_normal = color(255);
  int fill_hover = color(204);
  int fill_press = color(127);
  
  public Button(int x_pos, int y_pos, int wid, int hei, int a, String t, int ts) {
    x = x_pos;
    y = y_pos;
    w = wid;
    h = hei;
    setAlign(a);
    text = t;
    text_size = ts;
  }
  
  public Button(int x_pos, int y_pos, int wid, int hei, int a) {
    x = x_pos;
    y = y_pos;
    w = wid;
    h = hei;
    setAlign(a);
  }
  
  public Button() {
  }
  
  //Methods that need to be overridden in a child class.
  public void onHover() {}
  public void onPress() {}
  public void onJustPress() {}
  public void onRelease() {}
  
  //When making a child, if you update the process, make sure to call super.process() at the top.
  //This process draws the button based on its current state.
  public void process() {
    
    if (isPressed())       fill(fill_press);
    else if (isHovered())  fill(fill_hover);
    else                   fill(fill_normal);
    stroke(outline_color);
    rect(x - w*x_mod, y, w, h);
    
    fill(text_color);
    textSize(text_size);
    textAlign(align);
    text(text, x, (2*y+h)/2 + text_size/2);
    
    if (isHovered()) onHover();
    if (isPressed()) onPress();
    if (isJustPressed()) onJustPress();
    if (isJustReleased()) onRelease();
    
    lastFramePressed = isPressed();
  }
  
  
  public boolean isHovered() {
    return can_press && mouseX > x - w*x_mod && mouseX < x + w - w*x_mod && mouseY > y && mouseY < y + h;
  }
  
  public boolean isPressed() {
    return (isHovered() && mousePressed);
  }
  
  public boolean isJustPressed() {
    return isPressed() && !lastFramePressed;
  }
  
  public boolean isJustReleased() {
    return !isPressed() && lastFramePressed;
  }
  
  public void setCanPress(boolean can) {
    can_press = can;
  }
  
  public boolean getCanPress() {
    return can_press;
  }
  
  //sets the align of both the button's rectangle relative to its position
  //coordinates as well as the alignment of the text.
  public void setAlign(int a) {
    align = a;
    switch (align) {
      case LEFT:
        x_mod = 0;
        break;
      case RIGHT:
        x_mod = 1;
        break;
      case CENTER:
        x_mod = 0.5f;
        break;
      default:
        println("oopsies, setAlign() was called with a value it can't take.");
    }
  }
  
}
//Contains each screen for the game and swaps between them based on
//what cur_scene says it should be.
public class GameManager extends Scene {
  
  private int currentScene = 0;
  private Scene mainMenu;      //0
  private Scene play;          //1
  private Scene instructions;  //2
  private Scene winScreen;     //3
  
  final int bg_color = color(204);
  
  public GameManager() {
    mainMenu = addChild( new MainMenu() );
    play = addChild( new Play() );
    instructions = addChild( new Instructions() );
    winScreen = addChild( new WinScreen() );
    setCurrentScene(0);
  }
  
  public void process() {
    background(bg_color);
  }
  
  public void setCurrentScene(int scen) {
    
    if (scen >= 0) {
      currentScene = scen;
      for (Scene s : getChildren()) {
        s.setVis(false);
      }
      getChild(scen).setVis(true);
      
    }
    
    else exit();
    
  }
  
  private int getCurrentScene() {
    return currentScene;
  }
  
}
//The slides for the instructions for the game.
public class Instructions extends Scene {
  
  private int page = 0;
  
  public Instructions() {
    addChild( new NavButton(width - 125, height - 65, 200, 50, CENTER, "Menu", 24).setVal(0) );
    addChild( new PageButton(width - 150, height - 125, 50, 50, CENTER, "1", 24).setVal(0) );
    addChild( new PageButton(width - 100, height - 125, 50, 50, CENTER, "2", 24).setVal(1) );
  }
  
  public void process() {
    textAlign(LEFT);
    textSize(24);
    text("Welcome to Java Java!", 10, 30);
    
    text("As an employee of the newest coffee-themed variable store, your job is to take", 10, 90);
    text("customers' orders and give them a variable that fits their needs.", 10, 120);
    text("There are four parts to declaring a variable in Java, and you need to pay attention", 10, 150);
    text("to what your customer is asking so you can correctly declare the variable.", 10, 180);
    
    
    if (page == 0) {
      textSize(24);
      text("1: private or public", 10, 240);
      textSize(18);
      text("Because our company's data-safety policy strictly enforces encapsulation, all of our variables must be declared as private.", 10, 270);
      
      textSize(24);
      text("2: data type of variable", 10, 300);
      textSize(18);
      text("There are five data types of variables our customers will order, each fitting a different need.", 10, 330);
      text("          int             |  An integer number. Used for keeping track of how many of something.", 10, 360);
      text("          float         |  A floating-point number, AKA decimal. Used for keeping track of how much of something.", 10, 390);
      text("          boolean |  A binary value that can only be true or false.", 10, 420);
      text("          char         |  A single letter.", 10, 450);
      text("          String      |  A whole word. (Notice: this one is capitalized!)", 10, 480);
    }
    
    else if (page == 1) {
      textSize(24);
      text("3: naming the variable", 10, 240);
      textSize(18);
      text("There are several rules you have to follow about naming the variable:", 10, 270);
      text("          a) The only characters you may use are lowercase letters a-z, uppercase letters A-Z, numbers 0-9, \'_\', and \'$\'.", 10, 300);
      text("          b) You may not use a number for the first character of the variable's name.", 10, 330);
      text("          c) You may not use any java keywords for the variable name. This includes things like \'int\' or \'private\'.", 10, 360);
      
      textSize(24);
      text("4: the semicolon", 10, 405);
      textSize(18);
      text("You can't serve a variable without its lid! All variable declarations must end with \';\'.", 10, 435);
      
      textSize(24);
      text("example:", 10, 480);
      textSize(18);
      text("private  int  my_number;", 10, 510);
      
    }
    
  }
  
  public int getPage() {
    return page;
  }
  
  public void setPage(int val) {
    page = val;
  }
  
}

//Button that swaps between pages of the instructions tab.
public class PageButton extends Button {
  
  int page_val = 0;
  
  public PageButton(int x_pos, int y_pos, int wid, int hei, int a, String t, int ts) {
    super(x_pos, y_pos, wid, hei, a, t, ts);
  }
  
  public void onRelease() {
    ((Instructions)getParent()).setPage(page_val);
  }
  
  public Button setVal(int val) {
    page_val = val;
    return this;
  }
  
}
//Contains the title screen and buttons to navigate the game.
public class MainMenu extends Scene {
  
  public MainMenu() {
    addChild( new NavButton(width/2, height/2, 200, 50, CENTER, "Play", 24).setVal(1) );
    addChild( new NavButton(width/2, height/2 + 60, 200, 50, CENTER, "Instructions", 24).setVal(2) );
    addChild( new NavButton(width/2, height/2 + 120, 200, 50, CENTER, "Exit", 24).setVal(-1) );
  }
  
  public void process() {
    textAlign(CENTER);
    textSize(36);
    text("Java Java", width/2, height/2 - 60);
  }
  
}
//Button for navigating between scenes.
//Modified from my FishGame project.
public class NavButton extends Button {
  
  private int scene_val;
  
  public NavButton(int x_pos, int y_pos, int wid, int hei, int a) {
    super(x_pos, y_pos, wid, hei, a);
  }
  
  public NavButton(int x_pos, int y_pos, int wid, int hei, int a, String t, int ts) {
    super(x_pos, y_pos, wid, hei, a, t, ts);
  }
  
  public void onRelease() {
    gameManager.setCurrentScene(scene_val);
  }
  
  public Button setVal(int v) {
    scene_val = v;
    return this;
  }
  
}
//The game scene. Contains all the input, output, and logic for the actual game.
public class Play extends Scene {
  
  //the access type for the answer should always be private.
  final String access = "private";
  
  //list of the return types for the questions in this game.
  final String[] types = new String[]{"int", "float", "boolean", "char", "String"};
  
  //list of java keywords from https://en.wikipedia.org/wiki/List_of_Java_keywords
  final String[] keywords = { "abstract", "assert", "boolean",
                "break", "byte", "case", "catch", "char", "class", "const",
                "continue", "default", "do", "double", "else", "extends", "false",
                "final", "finally", "float", "for", "goto", "if", "implements",
                "import", "instanceof", "int", "interface", "long", "native",
                "new", "null", "package", "private", "protected", "public",
                "return", "short", "static", "strictfp", "super", "switch",
                "synchronized", "this", "throw", "throws", "transient", "true",
                "try", "void", "volatile", "while" };
  
  //list of nouns for order examples.
  final String[] objects = { "cat", "house", "tree", "shoe", "coffee",
                "bee", "finger", "snack"};
  
  //list of attibutes of objects (for float)
  final String[] attributes = { "length", "width", "height", "weight",
                "mass", "volume", "splorpability"};
  
  //list of actions (for boolean)
  final String[] actions = { "walk", "run", "jump", "fly", "talk", "think",
                "go fishing", "take a nap" };
  
  //file path of the background image.
  final String bg_path = "crema.jpg";
  
  //file path of the image for the customer.
  final String customer_path = "fish.png";
  
  //background image
  PImage bg_img;
  
  //customer image
  PImage customer_img;
  
  //full prompt that the customer will ask.
  String prompt;
  
  //return type of the prompt.
  String prompt_type;
  
  //hint for the player if they got the order wrong.
  String hint_text = "";
  
  
  public Play() {
    addChild( new NavButton(width - 125, height - 65, 200, 50, CENTER, "Menu", 24).setVal(0) );
    GenerateOrder();
  }
  
  public void ready() {
    kb_text = "";
    hint_text = "";
    bg_img = loadImage(bg_path);
    customer_img = loadImage(customer_path);
  }
  
  //draw every frame. draws the basic shapes and text.
  public void process() {
    fill(color(204));
    image(bg_img, 0, 0, width, height);
    image(customer_img, 600, 100, 300, 200);
    rect(50, 50, width - 100, 50);
    rect(50, 350, width - 100, 50);
    triangle(620, 100, 700, 100, 650, 170);
    if (!hint_text.equals("")) rect(50, 400, width - 100, 50);
    
    fill(color(0));
    textAlign(CENTER);
    textSize(24);
    text(prompt, width/2, 85);
    text(kb_text, width/2, 385);
    textSize(16);
    if (!hint_text.equals("")) text(hint_text, width/2, 435);
  }
  
  //sets a random prompt_type and generates a new prompt statement.
  private void GenerateOrder() {
    prompt_type = types[(int)(rng.nextFloat() * types.length)];
    prompt = "I need a variable that stores ";
    
    switch (prompt_type) {
      case "int":
        prompt += "how many " + objects[(int)(rng.nextFloat() * objects.length)] + "s I have.";
        break;
      case "float":
        prompt += "the exact " + attributes[(int)(rng.nextFloat() * attributes.length)] + " of my "
          + objects[(int)(rng.nextFloat() * objects.length)] + ".";
        break;
      case "boolean":
        prompt += "whether or not my " + objects[(int)(rng.nextFloat() * objects.length)] + " can "
          + actions[(int)(rng.nextFloat() * actions.length)] + ".";
        break;
      case "char":
        prompt += "a letter in the word " + objects[(int)(rng.nextFloat() * objects.length)] + ".";
        break;
      case "String":
        prompt += "the name of my " + objects[(int)(rng.nextFloat() * objects.length)] + ".";
        break;
    }
    
  }
  
  
  public void CheckAnswer(String answer) {
    String hint = "";
    println(answer);
    String[] splits = split(answer, " ");
    
    if (!splits[0].equals(access)) {
      hint = "Remember our company's policy on encapsulation! (What comes before the data type?)";
    }
    
    else if (splits.length < 3) {
      hint = "Not enough terms! Are you missing the access, data type, or name?";
    }
    
    else if (!splits[1].equals(prompt_type)) {
      hint = "Something about that data type is wrong!";
    }
    
    else if (splits[2].equals(";")) {
      hint = "Looks like you didn't name the variable...";
    }
    
    else {
      String check = CheckName(splits[2].substring(0, splits[2].length() - 1));
      if (check != "correct") {
        hint = CheckName(splits[2]);
      }
      
      else if (!splits[2].substring(splits[2].length()-1).equals(";")) {
        hint = "I don't think that variable has its lid! (What does any statement end with in Java?)";
      }
      
      else if (splits.length > 3) {
        hint = "That's too many words for a simple variable declaration!";
      }
    }
    
    //win
    if (hint.equals("")) {
      gameManager.setCurrentScene(3);
      GenerateOrder();
    }
    //lose(ish)
    else {
      hint_text = hint;
    }
    
  }
  
  
  //Checks to see if the name of the variable follows Java naming conventions.
  //Returns "correct" if the name follows the rules, otherwise it
  //returns whatever the problem is.
  private String CheckName(String nam) {
    
    if (!canBeFirstChar(nam.charAt(0))) {
      return "The character " + nam.charAt(0) + " cannot be the first character in your variable's name!";
    }
    
    for (char c : nam.toCharArray()) {
      if (!isValidChar(c))
        return "The character " + c + " cannot be in the variable name!";
    }
    
    for (String s : keywords) {
      if (nam == s) {
        return "The word " + s + " is a Java keyword and cannot be used for your variable's name.";
      }
    }
    
    return "correct";
  }
  
  //returns true if the given character can be in the name of a variable.
  public boolean hasValidChars(String s) {
    boolean valid = true;
    for (char c : s.toCharArray()) {
      boolean v = false;
      if (c == '$') v = true;
      else if (c == '_') v = true;
      else if (c == ';') v = true;
      else if (c >= 48 && c <= 57) v = true;
      else if (c >= 65 && c <= 90) v = true;
      else if (c >= 97 && c <= 122) v = true;
      if (v) valid = false;
    }
    return valid;
  }
  
  //returns true if the given character can be in the name of a variable.
  public boolean isValidChar(char c) {
    boolean valid = false;
    if (c == '$') valid = true;
    else if (c == '_') valid = true;
    else if (c >= 48 && c <= 57) valid = true;
    else if (c >= 65 && c <= 90) valid = true;
    else if (c >= 97 && c <= 122) valid = true;
    return valid;
  }
  
  //returns true if the given character can be the first character of a variable.
  public boolean canBeFirstChar(char c) {
    boolean valid = false;
    if (c == '$') valid = true;
    else if (c == '_') valid = true;
    else if (c >= 65 && c <= 90) valid = true;
    else if (c >= 97 && c <= 122) valid = true;
    return valid;
  }
  
}
//Generic class that mimics the scene system in the Godot engine.
//Every object used in this project will inherit this class, which allows them
//to interact with each other in a fluid way based on Godot's node tree system.
//Imported from my FishGame project.
abstract public class Scene {
  
  private String name = "Scene";
  private ArrayList<Scene> children = new ArrayList<Scene>();
  private Scene parent;
  private boolean visible = true;
  
  public Scene() {
  }
  
  public Scene(boolean vis) {
    visible = vis;
  }
  
  public Scene(String n) {
    name = n;
  }
  
  //Called each time a scene becomes visible.
  //Meant to be overwritten by the child class.
  public void ready() {
  }
  
  //Called every frame as long as the scene is visible.
  //Meant to be overwritten by the child class.
  public void process() {
  }
  
  //Function that allows the process function to work.
  final public void _process() {
    if (visible) {
      process();
      for (Scene s : getChildren()) {
        s._process();
      }
    }
  }
  
  //Returns the array of scenes that are children of this scene.
  public ArrayList<Scene> getChildren() {
    return children;
  }
  
  //Returns a single child scene based on its index.
  public Scene getChild(int index) {
    return children.get(index);
  }
  
  //Adds an additional child scene and returns said scene.
  public Scene addChild(Scene child) {
    child.setParent(this);
    children.add(child);
    return child;
  }
  
  //Traverses the scene tree starting with this scene
  //and returns the first instance of a scene with the 
  //desired name, or null if it doesn't exist.
  public Scene findChild(String nam) {
    Scene s = null;
    int i = 0;
    while (i < getChildren().size() && s == null) {
      if (getChild(i).getName() == nam) {
        s = getChild(i);
      }
      i++;
    }
    return s;
  }
  
  //Removes and returns a child scene based on its index.
  public Scene removeChild(int index) {
    getChild(index).setParent(null);
    return children.remove(index);
  }
  
  //Returns the parent scene of this scene.
  //To access the parent scene's functions, you must
  //convert it to its specific subclass first.
  public Scene getParent() {
    return parent;
  }
  
  //Sets this scene's parent to a new parent scene.
  public void setParent(Scene p) {
    parent = p;
  }
  
  public boolean getVis() {
    return visible;
  }
  
  public void setVis(boolean v) {
    visible = v;
    if (v) ready();
  }
  
  public String getName() {
    return name;
  }
  
  //Returns the scene so that you can declare the name of a scene when created without a constructor and set it to a child all in one line.
  public Scene setName(String n) {
    name = n;
    return this;
  }
  
}
//Screen for when you complete a successful order.
public class WinScreen extends Scene {
  
  public WinScreen() {
    addChild( new NavButton(width/2 - 150, height/2 + 200, 200, 50, CENTER, "Back to Menu", 24).setVal(0) );
    addChild( new NavButton(width/2 + 150, height/2 + 200, 200, 50, CENTER, "Play Again", 24).setVal(1) );
  }
  
  public void ready() {
    wins++;
  }
  
  public void process() {
    textAlign(CENTER);
    textSize(36);
    text("Another happy customer!", width/2, 200);
    textSize(24);
    text("Total happy customers: " + wins, width/2, 300);
  }
  
}


  public void settings() { size(960, 540); }

  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "JavaGame" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
