/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Random;
import processing.core.PApplet;
import processing.core.PImage;

public class JavaGame
extends PApplet {
    GameManager gameManager;
    Random rng;
    String kb_text;
    int wins = 0;

    public void setup() {
        this.windowMove(200, 80);
        this.rng = new Random();
        this.gameManager = new GameManager();
    }

    public void draw() {
        this.gameManager._process();
    }

    public void keyPressed() {
        if (this.gameManager.getCurrentScene() == 1) {
            if (this.key == '\b') {
                this.kb_text = this.kb_text.substring(0, JavaGame.max((int)0, (int)(this.kb_text.length() - 1)));
            } else if (this.key == '\n' || this.key == '\r') {
                ((Play)this.gameManager.play).CheckAnswer(this.kb_text);
            } else if (this.key != '\uffff') {
                this.kb_text = String.valueOf(this.kb_text) + this.key;
            }
        }
    }

    public void settings() {
        this.size(960, 540);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"JavaGame"};
        if (passedArgs != null) {
            PApplet.main((String[])JavaGame.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Button
    extends Scene {
        private String name;
        private boolean lastFramePressed;
        int x;
        int y;
        int w;
        int h;
        boolean can_press;
        int align;
        private float x_mod;
        String text;
        int text_size;
        int text_color;
        int outline_color;
        int fill_normal;
        int fill_hover;
        int fill_press;

        public Button(int x_pos, int y_pos, int wid, int hei, int a, String t, int ts) {
            this.name = "Button";
            this.lastFramePressed = false;
            this.x = 0;
            this.y = 0;
            this.w = 1;
            this.h = 1;
            this.can_press = true;
            this.align = 3;
            this.text = "";
            this.text_size = 16;
            this.text_color = JavaGame.this.color(0);
            this.outline_color = JavaGame.this.color(0);
            this.fill_normal = JavaGame.this.color(255);
            this.fill_hover = JavaGame.this.color(204);
            this.fill_press = JavaGame.this.color(127);
            this.x = x_pos;
            this.y = y_pos;
            this.w = wid;
            this.h = hei;
            this.setAlign(a);
            this.text = t;
            this.text_size = ts;
        }

        public Button(int x_pos, int y_pos, int wid, int hei, int a) {
            this.name = "Button";
            this.lastFramePressed = false;
            this.x = 0;
            this.y = 0;
            this.w = 1;
            this.h = 1;
            this.can_press = true;
            this.align = 3;
            this.text = "";
            this.text_size = 16;
            this.text_color = JavaGame.this.color(0);
            this.outline_color = JavaGame.this.color(0);
            this.fill_normal = JavaGame.this.color(255);
            this.fill_hover = JavaGame.this.color(204);
            this.fill_press = JavaGame.this.color(127);
            this.x = x_pos;
            this.y = y_pos;
            this.w = wid;
            this.h = hei;
            this.setAlign(a);
        }

        public Button() {
            this.name = "Button";
            this.lastFramePressed = false;
            this.x = 0;
            this.y = 0;
            this.w = 1;
            this.h = 1;
            this.can_press = true;
            this.align = 3;
            this.text = "";
            this.text_size = 16;
            this.text_color = JavaGame.this.color(0);
            this.outline_color = JavaGame.this.color(0);
            this.fill_normal = JavaGame.this.color(255);
            this.fill_hover = JavaGame.this.color(204);
            this.fill_press = JavaGame.this.color(127);
        }

        public void onHover() {
        }

        public void onPress() {
        }

        public void onJustPress() {
        }

        public void onRelease() {
        }

        @Override
        public void process() {
            if (this.isPressed()) {
                JavaGame.this.fill(this.fill_press);
            } else if (this.isHovered()) {
                JavaGame.this.fill(this.fill_hover);
            } else {
                JavaGame.this.fill(this.fill_normal);
            }
            JavaGame.this.stroke(this.outline_color);
            JavaGame.this.rect((float)this.x - (float)this.w * this.x_mod, this.y, this.w, this.h);
            JavaGame.this.fill(this.text_color);
            JavaGame.this.textSize(this.text_size);
            JavaGame.this.textAlign(this.align);
            JavaGame.this.text(this.text, this.x, (2 * this.y + this.h) / 2 + this.text_size / 2);
            if (this.isHovered()) {
                this.onHover();
            }
            if (this.isPressed()) {
                this.onPress();
            }
            if (this.isJustPressed()) {
                this.onJustPress();
            }
            if (this.isJustReleased()) {
                this.onRelease();
            }
            this.lastFramePressed = this.isPressed();
        }

        public boolean isHovered() {
            return this.can_press && (float)JavaGame.this.mouseX > (float)this.x - (float)this.w * this.x_mod && (float)JavaGame.this.mouseX < (float)(this.x + this.w) - (float)this.w * this.x_mod && JavaGame.this.mouseY > this.y && JavaGame.this.mouseY < this.y + this.h;
        }

        public boolean isPressed() {
            return this.isHovered() && JavaGame.this.mousePressed;
        }

        public boolean isJustPressed() {
            return this.isPressed() && !this.lastFramePressed;
        }

        public boolean isJustReleased() {
            return !this.isPressed() && this.lastFramePressed;
        }

        public void setCanPress(boolean can) {
            this.can_press = can;
        }

        public boolean getCanPress() {
            return this.can_press;
        }

        public void setAlign(int a) {
            this.align = a;
            switch (this.align) {
                case 37: {
                    this.x_mod = 0.0f;
                    break;
                }
                case 39: {
                    this.x_mod = 1.0f;
                    break;
                }
                case 3: {
                    this.x_mod = 0.5f;
                    break;
                }
                default: {
                    JavaGame.println((String)"oopsies, setAlign() was called with a value it can't take.");
                }
            }
        }
    }

    public class GameManager
    extends Scene {
        private int currentScene;
        private Scene mainMenu;
        private Scene play;
        private Scene instructions;
        private Scene winScreen;
        final int bg_color;

        public GameManager() {
            this.currentScene = 0;
            this.bg_color = JavaGame.this.color(204);
            this.mainMenu = this.addChild(new MainMenu());
            this.play = this.addChild(new Play());
            this.instructions = this.addChild(new Instructions());
            this.winScreen = this.addChild(new WinScreen());
            this.setCurrentScene(0);
        }

        @Override
        public void process() {
            JavaGame.this.background(this.bg_color);
        }

        public void setCurrentScene(int scen) {
            if (scen >= 0) {
                this.currentScene = scen;
                for (Scene s : this.getChildren()) {
                    s.setVis(false);
                }
                this.getChild(scen).setVis(true);
            } else {
                JavaGame.this.exit();
            }
        }

        private int getCurrentScene() {
            return this.currentScene;
        }
    }

    public class Instructions
    extends Scene {
        private int page;

        public Instructions() {
            this.page = 0;
            this.addChild(new NavButton(JavaGame.this.width - 125, JavaGame.this.height - 65, 200, 50, 3, "Menu", 24).setVal(0));
            this.addChild(new PageButton(JavaGame.this.width - 150, JavaGame.this.height - 125, 50, 50, 3, "1", 24).setVal(0));
            this.addChild(new PageButton(JavaGame.this.width - 100, JavaGame.this.height - 125, 50, 50, 3, "2", 24).setVal(1));
        }

        @Override
        public void process() {
            JavaGame.this.textAlign(37);
            JavaGame.this.textSize(24.0f);
            JavaGame.this.text("Welcome to Java Java!", 10.0f, 30.0f);
            JavaGame.this.text("As an employee of the newest coffee-themed variable store, your job is to take", 10.0f, 90.0f);
            JavaGame.this.text("customers' orders and give them a variable that fits their needs.", 10.0f, 120.0f);
            JavaGame.this.text("There are four parts to declaring a variable in Java, and you need to pay attention", 10.0f, 150.0f);
            JavaGame.this.text("to what your customer is asking so you can correctly declare the variable.", 10.0f, 180.0f);
            if (this.page == 0) {
                JavaGame.this.textSize(24.0f);
                JavaGame.this.text("1: private or public", 10.0f, 240.0f);
                JavaGame.this.textSize(18.0f);
                JavaGame.this.text("Because our company's data-safety policy strictly enforces encapsulation, all of our variables must be declared as private.", 10.0f, 270.0f);
                JavaGame.this.textSize(24.0f);
                JavaGame.this.text("2: data type of variable", 10.0f, 300.0f);
                JavaGame.this.textSize(18.0f);
                JavaGame.this.text("There are five data types of variables our customers will order, each fitting a different need.", 10.0f, 330.0f);
                JavaGame.this.text("          int             |  An integer number. Used for keeping track of how many of something.", 10.0f, 360.0f);
                JavaGame.this.text("          float         |  A floating-point number, AKA decimal. Used for keeping track of how much of something.", 10.0f, 390.0f);
                JavaGame.this.text("          boolean |  A binary value that can only be true or false.", 10.0f, 420.0f);
                JavaGame.this.text("          char         |  A single letter.", 10.0f, 450.0f);
                JavaGame.this.text("          String      |  A whole word. (Notice: this one is capitalized!)", 10.0f, 480.0f);
            } else if (this.page == 1) {
                JavaGame.this.textSize(24.0f);
                JavaGame.this.text("3: naming the variable", 10.0f, 240.0f);
                JavaGame.this.textSize(18.0f);
                JavaGame.this.text("There are several rules you have to follow about naming the variable:", 10.0f, 270.0f);
                JavaGame.this.text("          a) The only characters you may use are lowercase letters a-z, uppercase letters A-Z, numbers 0-9, '_', and '$'.", 10.0f, 300.0f);
                JavaGame.this.text("          b) You may not use a number for the first character of the variable's name.", 10.0f, 330.0f);
                JavaGame.this.text("          c) You may not use any java keywords for the variable name. This includes things like 'int' or 'private'.", 10.0f, 360.0f);
                JavaGame.this.textSize(24.0f);
                JavaGame.this.text("4: the semicolon", 10.0f, 405.0f);
                JavaGame.this.textSize(18.0f);
                JavaGame.this.text("You can't serve a variable without its lid! All variable declarations must end with ';'.", 10.0f, 435.0f);
                JavaGame.this.textSize(24.0f);
                JavaGame.this.text("example:", 10.0f, 480.0f);
                JavaGame.this.textSize(18.0f);
                JavaGame.this.text("private  int  my_number;", 10.0f, 510.0f);
            }
        }

        public int getPage() {
            return this.page;
        }

        public void setPage(int val) {
            this.page = val;
        }
    }

    public class MainMenu
    extends Scene {
        public MainMenu() {
            this.addChild(new NavButton(JavaGame.this.width / 2, JavaGame.this.height / 2, 200, 50, 3, "Play", 24).setVal(1));
            this.addChild(new NavButton(JavaGame.this.width / 2, JavaGame.this.height / 2 + 60, 200, 50, 3, "Instructions", 24).setVal(2));
            this.addChild(new NavButton(JavaGame.this.width / 2, JavaGame.this.height / 2 + 120, 200, 50, 3, "Exit", 24).setVal(-1));
        }

        @Override
        public void process() {
            JavaGame.this.textAlign(3);
            JavaGame.this.textSize(36.0f);
            JavaGame.this.text("Java Java", JavaGame.this.width / 2, JavaGame.this.height / 2 - 60);
        }
    }

    public class NavButton
    extends Button {
        private int scene_val;

        public NavButton(int x_pos, int y_pos, int wid, int hei, int a) {
            super(x_pos, y_pos, wid, hei, a);
        }

        public NavButton(int x_pos, int y_pos, int wid, int hei, int a, String t, int ts) {
            super(x_pos, y_pos, wid, hei, a, t, ts);
        }

        @Override
        public void onRelease() {
            JavaGame.this.gameManager.setCurrentScene(this.scene_val);
        }

        public Button setVal(int v) {
            this.scene_val = v;
            return this;
        }
    }

    public class PageButton
    extends Button {
        int page_val;

        public PageButton(int x_pos, int y_pos, int wid, int hei, int a, String t, int ts) {
            super(x_pos, y_pos, wid, hei, a, t, ts);
            this.page_val = 0;
        }

        @Override
        public void onRelease() {
            ((Instructions)this.getParent()).setPage(this.page_val);
        }

        public Button setVal(int val) {
            this.page_val = val;
            return this;
        }
    }

    public class Play
    extends Scene {
        final String access = "private";
        final String[] types;
        final String[] keywords;
        final String[] objects;
        final String[] attributes;
        final String[] actions;
        final String bg_path = "crema.jpg";
        final String customer_path = "fish.png";
        PImage bg_img;
        PImage customer_img;
        String prompt;
        String prompt_type;
        String hint_text;

        public Play() {
            this.access = "private";
            this.types = new String[]{"int", "float", "boolean", "char", "String"};
            this.keywords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
            this.objects = new String[]{"cat", "house", "tree", "shoe", "coffee", "bee", "finger", "snack"};
            this.attributes = new String[]{"length", "width", "height", "weight", "mass", "volume", "splorpability"};
            this.actions = new String[]{"walk", "run", "jump", "fly", "talk", "think", "go fishing", "take a nap"};
            this.bg_path = "crema.jpg";
            this.customer_path = "fish.png";
            this.hint_text = "";
            this.addChild(new NavButton(JavaGame.this.width - 125, JavaGame.this.height - 65, 200, 50, 3, "Menu", 24).setVal(0));
            this.GenerateOrder();
        }

        @Override
        public void ready() {
            JavaGame.this.kb_text = "";
            this.hint_text = "";
            this.bg_img = JavaGame.this.loadImage("crema.jpg");
            this.customer_img = JavaGame.this.loadImage("fish.png");
        }

        @Override
        public void process() {
            JavaGame.this.fill(JavaGame.this.color(204));
            JavaGame.this.image(this.bg_img, 0.0f, 0.0f, JavaGame.this.width, JavaGame.this.height);
            JavaGame.this.image(this.customer_img, 600.0f, 100.0f, 300.0f, 200.0f);
            JavaGame.this.rect(50.0f, 50.0f, JavaGame.this.width - 100, 50.0f);
            JavaGame.this.rect(50.0f, 350.0f, JavaGame.this.width - 100, 50.0f);
            JavaGame.this.triangle(620.0f, 100.0f, 700.0f, 100.0f, 650.0f, 170.0f);
            if (!this.hint_text.equals("")) {
                JavaGame.this.rect(50.0f, 400.0f, JavaGame.this.width - 100, 50.0f);
            }
            JavaGame.this.fill(JavaGame.this.color(0));
            JavaGame.this.textAlign(3);
            JavaGame.this.textSize(24.0f);
            JavaGame.this.text(this.prompt, JavaGame.this.width / 2, 85.0f);
            JavaGame.this.text(JavaGame.this.kb_text, JavaGame.this.width / 2, 385.0f);
            JavaGame.this.textSize(16.0f);
            if (!this.hint_text.equals("")) {
                JavaGame.this.text(this.hint_text, JavaGame.this.width / 2, 435.0f);
            }
        }

        private void GenerateOrder() {
            this.prompt_type = this.types[(int)(JavaGame.this.rng.nextFloat() * (float)this.types.length)];
            this.prompt = "I need a variable that stores ";
            switch (this.prompt_type) {
                case "int": {
                    this.prompt = String.valueOf(this.prompt) + "how many " + this.objects[(int)(JavaGame.this.rng.nextFloat() * (float)this.objects.length)] + "s I have.";
                    break;
                }
                case "float": {
                    this.prompt = String.valueOf(this.prompt) + "the exact " + this.attributes[(int)(JavaGame.this.rng.nextFloat() * (float)this.attributes.length)] + " of my " + this.objects[(int)(JavaGame.this.rng.nextFloat() * (float)this.objects.length)] + ".";
                    break;
                }
                case "boolean": {
                    this.prompt = String.valueOf(this.prompt) + "whether or not my " + this.objects[(int)(JavaGame.this.rng.nextFloat() * (float)this.objects.length)] + " can " + this.actions[(int)(JavaGame.this.rng.nextFloat() * (float)this.actions.length)] + ".";
                    break;
                }
                case "char": {
                    this.prompt = String.valueOf(this.prompt) + "a letter in the word " + this.objects[(int)(JavaGame.this.rng.nextFloat() * (float)this.objects.length)] + ".";
                    break;
                }
                case "String": {
                    this.prompt = String.valueOf(this.prompt) + "the name of my " + this.objects[(int)(JavaGame.this.rng.nextFloat() * (float)this.objects.length)] + ".";
                }
            }
        }

        public void CheckAnswer(String answer) {
            String hint = "";
            JavaGame.println((String)answer);
            String[] splits = JavaGame.split((String)answer, (String)" ");
            if (!splits[0].equals("private")) {
                hint = "Remember our company's policy on encapsulation! (What comes before the data type?)";
            } else if (splits.length < 3) {
                hint = "Not enough terms! Are you missing the access, data type, or name?";
            } else if (!splits[1].equals(this.prompt_type)) {
                hint = "Something about that data type is wrong!";
            } else if (splits[2].equals(";")) {
                hint = "Looks like you didn't name the variable...";
            } else {
                String check = this.CheckName(splits[2].substring(0, splits[2].length() - 1));
                if (check != "correct") {
                    hint = this.CheckName(splits[2]);
                } else if (!splits[2].substring(splits[2].length() - 1).equals(";")) {
                    hint = "I don't think that variable has its lid! (What does any statement end with in Java?)";
                } else if (splits.length > 3) {
                    hint = "That's too many words for a simple variable declaration!";
                }
            }
            if (hint.equals("")) {
                JavaGame.this.gameManager.setCurrentScene(3);
                this.GenerateOrder();
            } else {
                this.hint_text = hint;
            }
        }

        private String CheckName(String nam) {
            if (!this.canBeFirstChar(nam.charAt(0))) {
                return "The character " + nam.charAt(0) + " cannot be the first character in your variable's name!";
            }
            Object[] objectArray = nam.toCharArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = objectArray[n2];
                if (!this.isValidChar(c)) {
                    return "The character " + c + " cannot be in the variable name!";
                }
                ++n2;
            }
            objectArray = this.keywords;
            n = this.keywords.length;
            n2 = 0;
            while (n2 < n) {
                char s = objectArray[n2];
                if (nam == s) {
                    return "The word " + (String)s + " is a Java keyword and cannot be used for your variable's name.";
                }
                ++n2;
            }
            return "correct";
        }

        public boolean hasValidChars(String s) {
            boolean valid = true;
            char[] cArray = s.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                boolean v = false;
                if (c == '$') {
                    v = true;
                } else if (c == '_') {
                    v = true;
                } else if (c == ';') {
                    v = true;
                } else if (c >= '0' && c <= '9') {
                    v = true;
                } else if (c >= 'A' && c <= 'Z') {
                    v = true;
                } else if (c >= 'a' && c <= 'z') {
                    v = true;
                }
                if (v) {
                    valid = false;
                }
                ++n2;
            }
            return valid;
        }

        public boolean isValidChar(char c) {
            boolean valid = false;
            if (c == '$') {
                valid = true;
            } else if (c == '_') {
                valid = true;
            } else if (c >= '0' && c <= '9') {
                valid = true;
            } else if (c >= 'A' && c <= 'Z') {
                valid = true;
            } else if (c >= 'a' && c <= 'z') {
                valid = true;
            }
            return valid;
        }

        public boolean canBeFirstChar(char c) {
            boolean valid = false;
            if (c == '$') {
                valid = true;
            } else if (c == '_') {
                valid = true;
            } else if (c >= 'A' && c <= 'Z') {
                valid = true;
            } else if (c >= 'a' && c <= 'z') {
                valid = true;
            }
            return valid;
        }
    }

    public abstract class Scene {
        private String name = "Scene";
        private ArrayList<Scene> children = new ArrayList();
        private Scene parent;
        private boolean visible = true;

        public Scene() {
        }

        public Scene(boolean vis) {
            this.visible = vis;
        }

        public Scene(String n) {
            this.name = n;
        }

        public void ready() {
        }

        public void process() {
        }

        public final void _process() {
            if (this.visible) {
                this.process();
                for (Scene s : this.getChildren()) {
                    s._process();
                }
            }
        }

        public ArrayList<Scene> getChildren() {
            return this.children;
        }

        public Scene getChild(int index) {
            return this.children.get(index);
        }

        public Scene addChild(Scene child) {
            child.setParent(this);
            this.children.add(child);
            return child;
        }

        public Scene findChild(String nam) {
            Scene s = null;
            int i = 0;
            while (i < this.getChildren().size() && s == null) {
                if (this.getChild(i).getName() == nam) {
                    s = this.getChild(i);
                }
                ++i;
            }
            return s;
        }

        public Scene removeChild(int index) {
            this.getChild(index).setParent(null);
            return this.children.remove(index);
        }

        public Scene getParent() {
            return this.parent;
        }

        public void setParent(Scene p) {
            this.parent = p;
        }

        public boolean getVis() {
            return this.visible;
        }

        public void setVis(boolean v) {
            this.visible = v;
            if (v) {
                this.ready();
            }
        }

        public String getName() {
            return this.name;
        }

        public Scene setName(String n) {
            this.name = n;
            return this;
        }
    }

    public class WinScreen
    extends Scene {
        public WinScreen() {
            this.addChild(new NavButton(JavaGame.this.width / 2 - 150, JavaGame.this.height / 2 + 200, 200, 50, 3, "Back to Menu", 24).setVal(0));
            this.addChild(new NavButton(JavaGame.this.width / 2 + 150, JavaGame.this.height / 2 + 200, 200, 50, 3, "Play Again", 24).setVal(1));
        }

        @Override
        public void ready() {
            ++JavaGame.this.wins;
        }

        @Override
        public void process() {
            JavaGame.this.textAlign(3);
            JavaGame.this.textSize(36.0f);
            JavaGame.this.text("Another happy customer!", JavaGame.this.width / 2, 200.0f);
            JavaGame.this.textSize(24.0f);
            JavaGame.this.text("Total happy customers: " + JavaGame.this.wins, JavaGame.this.width / 2, 300.0f);
        }
    }
}

