//Contains each screen for the game and swaps between them based on
//what cur_scene says it should be.
public class GameManager extends Scene {
  
  private int currentScene = 0;
  private Scene mainMenu;      //0
  private Scene play;          //1
  private Scene instructions;  //2
  private Scene winScreen;     //3
  
  final color bg_color = color(204);
  
  public GameManager() {
    mainMenu = addChild( new MainMenu() );
    play = addChild( new Play() );
    instructions = addChild( new Instructions() );
    winScreen = addChild( new WinScreen() );
    setCurrentScene(0);
  }
  
  public void process() {
    background(bg_color);
  }
  
  public void setCurrentScene(int scen) {
    
    if (scen >= 0) {
      currentScene = scen;
      for (Scene s : getChildren()) {
        s.setVis(false);
      }
      getChild(scen).setVis(true);
      
    }
    
    else exit();
    
  }
  
  private int getCurrentScene() {
    return currentScene;
  }
  
}
