//The slides for the instructions for the game.
public class Instructions extends Scene {
  
  private int page = 0;
  
  public Instructions() {
    addChild( new NavButton(width - 125, height - 65, 200, 50, CENTER, "Menu", 24).setVal(0) );
    addChild( new PageButton(width - 150, height - 125, 50, 50, CENTER, "1", 24).setVal(0) );
    addChild( new PageButton(width - 100, height - 125, 50, 50, CENTER, "2", 24).setVal(1) );
  }
  
  public void process() {
    textAlign(LEFT);
    textSize(24);
    text("Welcome to Java Java!", 10, 30);
    
    text("As an employee of the newest coffee-themed variable store, your job is to take", 10, 90);
    text("customers' orders and give them a variable that fits their needs.", 10, 120);
    text("There are four parts to declaring a variable in Java, and you need to pay attention", 10, 150);
    text("to what your customer is asking so you can correctly declare the variable.", 10, 180);
    
    
    if (page == 0) {
      textSize(24);
      text("1: private or public", 10, 240);
      textSize(18);
      text("Because our company's data-safety policy strictly enforces encapsulation, all of our variables must be declared as private.", 10, 270);
      
      textSize(24);
      text("2: data type of variable", 10, 300);
      textSize(18);
      text("There are five data types of variables our customers will order, each fitting a different need.", 10, 330);
      text("          int             |  An integer number. Used for keeping track of how many of something.", 10, 360);
      text("          float         |  A floating-point number, AKA decimal. Used for keeping track of how much of something.", 10, 390);
      text("          boolean |  A binary value that can only be true or false.", 10, 420);
      text("          char         |  A single letter.", 10, 450);
      text("          String      |  A whole word. (Notice: this one is capitalized!)", 10, 480);
    }
    
    else if (page == 1) {
      textSize(24);
      text("3: naming the variable", 10, 240);
      textSize(18);
      text("There are several rules you have to follow about naming the variable:", 10, 270);
      text("          a) The only characters you may use are lowercase letters a-z, uppercase letters A-Z, numbers 0-9, \'_\', and \'$\'.", 10, 300);
      text("          b) You may not use a number for the first character of the variable's name.", 10, 330);
      text("          c) You may not use any java keywords for the variable name. This includes things like \'int\' or \'private\'.", 10, 360);
      
      textSize(24);
      text("4: the semicolon", 10, 405);
      textSize(18);
      text("You can't serve a variable without its lid! All variable declarations must end with \';\'.", 10, 435);
      
      textSize(24);
      text("example:", 10, 480);
      textSize(18);
      text("private  int  my_number;", 10, 510);
      
    }
    
  }
  
  public int getPage() {
    return page;
  }
  
  public void setPage(int val) {
    page = val;
  }
  
}

//Button that swaps between pages of the instructions tab.
public class PageButton extends Button {
  
  int page_val = 0;
  
  public PageButton(int x_pos, int y_pos, int wid, int hei, int a, String t, int ts) {
    super(x_pos, y_pos, wid, hei, a, t, ts);
  }
  
  public void onRelease() {
    ((Instructions)getParent()).setPage(page_val);
  }
  
  public Button setVal(int val) {
    page_val = val;
    return this;
  }
  
}
