//Java game by Jsaur
//Version 1.0
//Feb 15 2024

/*
  In this project, in-depth comments are used solely for superclasses
  to describe the use of the functions of that class. For subclasses,
  comments are used at the header to describe the class as a whole,
  but in-depth comments are not frequently used for those since between
  the superclass comments and the description of the class in the header,
  the purpose of each class can be known.
  
  The most important documentation is in the Scene and Play classes.
*/

import java.util.Random;

GameManager gameManager;
Random rng;

//keyboard input. resets when the room changes to Play.
String kb_text;

//Number of happy customers.
int wins = 0;

void setup() {
  size(960, 540);
  windowMove(200, 80);
  
  rng = new Random();
  gameManager = new GameManager();
}

void draw() {
  gameManager._process();
}

void keyPressed() {
  if (gameManager.getCurrentScene() == 1) {
    if (key == BACKSPACE) kb_text = kb_text.substring(0, max(0, kb_text.length()-1));
    else if (key == ENTER || key == RETURN) ((Play)(gameManager.play)).CheckAnswer(kb_text);
    else if (key != CODED) kb_text += key;
  }
}
