//Class that contains all the data required for a game of footsteps. Needs a child class that completes interactivity to become playable.
public class GameData {
  
  final int START_POINTS = 50;
  
  Player p1;
  Player p2;
  Star star;
  
  int star_pos = 4;
  int star_dir = 0;
  int turn = 1;
  int turn_timer = 0;
  
  public GameData() {
    p1 = new Player(START_POINTS);
    p2 = new Player(START_POINTS);
  }
  
  public void p1Turn() {
  }
  
  public void p2Turn() {
  }
  
}

class Player {
  int points;
  int spending;
  
  public Player(int p) {
    points = p;
  }
  
  public int getPoints() {
    return points;
  }
  
  public int getSpending() {
    return spending;
  }
  
  public boolean planSpending(int plan) {
    boolean canSpend = false;
    if (plan <= points) {
      spending = plan;
      canSpend = true;
    }
    return canSpend;
  }
  
  public void spendPoints() {
    points -= spending;
  }
  
  public boolean hasPoints() {
    return (points > 0);
  }
  
}

class Star {
  
  final String imgPath = "game\\star.png";
  PImage img;
  
  int x;
  int y;
  int w;
  int h;
  int init_h;
  
  public Star(int x_pos, int y_pos, int wid, int hei) {
    x = x_pos;
    y = y_pos;
    w = wid;
    h = hei;
    init_h = hei;
    img = loadImage(imgPath);
  }
  
  void run() {
    image(img, x-w/2, y-h/2, w, h);
  }
  
  public void setSize(int wid, int hei) {
    w = wid;
    h = hei;
  }
  
}
