/* autogenerated by Processing revision 1293 on 2025-01-16 */
import processing.core.*;
import processing.data.*;
import processing.event.*;
import processing.opengl.*;

import processing.sound.*;

import java.util.HashMap;
import java.util.ArrayList;
import java.io.File;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;

public class KaijiGame extends PApplet {


//Kaiji Game by Jsaur
//Version 1.0
//1 February 2024
//Credit to Nobuyuki Fukumoto and everyone involved with Kaiji ^_^



Slide cur_slide;
SlideData slideData;
MainMenu mainMenu;
TwoPlayerGame twoPlayerGame;

SoundFile music_menu;
final String music_menu_path = "music\\opening.mp3";

final int TEXT_MARGIN = 50;
final int TEXT_SIZE = 36;

String cur_scene = "intro";

public void setup() {
  /* size commented out by preprocessor */;
  frameRate(60);
  surface.setLocation(200, 50);
  
  slideData = new SlideData();
  cur_slide = slideData.introSlide;
  
  music_menu = new SoundFile(this, music_menu_path);
}

public void draw() {
  
  switch (cur_scene) {
    case "intro":
      drawSlide();
      break;
    case "menu":
      drawMenu();
      break;
    case "2pgame":
      draw2PGame();
      break;
    case "2pintro":
      drawSlide();
      break;
    case "gameend":
      drawSlide();
      break;
  }
  
}

public void setScene(String scn) {
  cur_scene = scn;
}

public void setSlide(Slide sl) {
  cur_slide = sl;
}

public void drawSlide() {
  image(cur_slide.getImg(), 0, 0, width, height);
  textSize(TEXT_SIZE);
  textAlign(CENTER);
  fill(255);
  text(cur_slide.getText(), width/2, height - TEXT_MARGIN); 
}

public void startMenu() {
  cur_scene = "menu";
  mainMenu = new MainMenu();
}

public void drawMenu() {
  mainMenu.run();
}

public void start2PGame() {
  cur_scene = "2pgame";
  twoPlayerGame = new TwoPlayerGame();
}

public void draw2PGame() {
  twoPlayerGame.run();
}

public void keyPressed() {
  
  if (cur_scene == "2pgame") {
    twoPlayerGame.keyPress(key);
  }
  
  if (key == ' ') {
    if ( cur_slide.hasNext() ) {
      cur_slide = cur_slide.getNext();
    }
    else {
      if (cur_scene == "intro" || cur_scene == "gameend")
        startMenu();
      else if (cur_scene == "2pintro") {
        start2PGame();
      }
    }
  }
  
}
//Class that contains all the data required for a game of footsteps. Needs a child class that completes interactivity to become playable.
public class GameData {
  
  final int START_POINTS = 50;
  
  Player p1;
  Player p2;
  Star star;
  
  int star_pos = 4;
  int star_dir = 0;
  int turn = 1;
  int turn_timer = 0;
  
  public GameData() {
    p1 = new Player(START_POINTS);
    p2 = new Player(START_POINTS);
  }
  
  public void p1Turn() {
  }
  
  public void p2Turn() {
  }
  
}

class Player {
  int points;
  int spending;
  
  public Player(int p) {
    points = p;
  }
  
  public int getPoints() {
    return points;
  }
  
  public int getSpending() {
    return spending;
  }
  
  public boolean planSpending(int plan) {
    boolean canSpend = false;
    if (plan <= points) {
      spending = plan;
      canSpend = true;
    }
    return canSpend;
  }
  
  public void spendPoints() {
    points -= spending;
  }
  
  public boolean hasPoints() {
    return (points > 0);
  }
  
}

class Star {
  
  final String imgPath = "game\\star.png";
  PImage img;
  
  int x;
  int y;
  int w;
  int h;
  int init_h;
  
  public Star(int x_pos, int y_pos, int wid, int hei) {
    x = x_pos;
    y = y_pos;
    w = wid;
    h = hei;
    init_h = hei;
    img = loadImage(imgPath);
  }
  
  public void run() {
    image(img, x-w/2, y-h/2, w, h);
  }
  
  public void setSize(int wid, int hei) {
    w = wid;
    h = hei;
  }
  
}
//Master class for the main menu, containing each element of the menu.
public class MainMenu {
  final String bg_path = "mainmenu\\bg.png";
  PImage bg;
  MenuButton[] buttons = new MenuButton[2];
  
  SoundFile music;
  
  public MainMenu() {
    bg = loadImage(bg_path);
    buttons[0] = new MenuButton("2P Game", width/2 - 100, 200, 200, 60);
    buttons[0].setAction("2pstart");
    buttons[1] = new MenuButton("Exit", width/2 - 100, 400, 200, 60);
    buttons[1].setAction("exit");
    
    music_menu.rate(1.08f);
    music_menu.loop();
  }
  
  public void run() {
    image(bg, 0, 0, width, height);
    textSize(72);
    text("Kaiji for Windows Computer", width/2, height/4);
    for (MenuButton b : buttons) {
      b.run();
    }
    
    if (cur_scene != "menu") {
      music_menu.stop();
    }
    
  }
  
}
//Simple button that can be coded to do many things.
public class MenuButton {
  String text; //text displayed on button
  int x; //x position of top-left corner
  int y; //y position of top-left corner
  int w; //width of button
  int h; //height of button
  
  String action; //correlates to what the button does.
  
  int col_normal = color(120, 0, 0);
  int col_hover = color(90, 0, 0);
  int col_press = color(60, 0, 0);
  
  boolean clicked_last_frame = false;
  
  public MenuButton(String txt, int x_pos, int y_pos, int wid, int hei) {
    text = txt;
    x = x_pos;
    y = y_pos;
    h = hei;
    w = wid;
  }
  
  public void setAction(String act) {
    action = act;
  }
  
  //draw function for the menu button.
  public void run() {
    if (isHover()) {
      fill(col_hover);
      if (mousePressed) {
        fill(col_press);
        clicked_last_frame = true;
      }
      else if (clicked_last_frame) {
        clickButton();
      }
    }
    else {
      fill(col_normal);
    }
    rect(x, y, w, h);
    fill(255);
    textAlign(CENTER);
    textSize(24);
    text(text, (x+w/2), (y+2*h/3));
  }
  
  public void clickButton() {
    
    switch (action) {
      case "2pstart":
        setSlide(slideData.TwoPlayerIntro);
        
        setScene("2pintro");
        break;
      case "exit":
        exit();
        break;
    }
    
    //just for the now button. change later.
    
  }
  
  public boolean isHover() {
    if (mouseX >= x && mouseX <= x+w && 
      mouseY >= y && mouseY <= y+h) {
      return true;
    } else {
      return false;
    }
  }
  
}
/*
Class that contains data for a single slide, including an image and a caption.
This is how the game will convey story and instructions.
*/
public class Slide {
  PImage img;
  String text;
  Slide nextSlide;
  
  public Slide(String img_path, String txt) {
    setImg(img_path);
    setText(txt);
    nextSlide = null;
  }
  
  //Setter method for the slide's image (backdrop).
  public void setImg(String img_path) {
    img = loadImage(img_path);
  }
  
  //Setter method for the slide's text (caption).
  public void setText(String txt) {
    text = txt;
  }
  
  //Setter method for the next slide.
  public void setNext(Slide next) {
    nextSlide = next;
  }
  
  //Getter method for the slide's image (backdrop).
  public PImage getImg() {
    return img;
  }
  
  //Getter method for the slide's text (caption).
  public String getText() {
    return text;
  }
  
  //Getter method for the next slide.
  public Slide getNext() {
    return nextSlide;
  }
  
  //Returns true if there is another slide in this slideshow, false otherwise.
  public boolean hasNext() {
    boolean has = true;
    if (nextSlide == null) has = false;
    return has;
  }
  
  //Sets the next n slides for this slide, where n is the size of the array of
  //slides you give it.
  public void setSlides(ArrayList<Slide> slides) {
    Slide cur_slide = this;
    for (int i = 0; i < slides.size(); i++) {
      cur_slide.setNext(slides.get(i));
      cur_slide = cur_slide.getNext();
    }
  }
  
}
//Contains all the slideshows needed for the game.
public class SlideData {
  
  public Slide introSlide;
  public Slide TwoPlayerIntro;
  public Slide kaijiWin;
  public Slide stantWin;
  public Slide tie;
  
  public SlideData() {
    
    introSlide = new Slide("intro\\0.jpg", "Press the spacebar to continue.");
    ArrayList<Slide> nexts = new ArrayList<Slide>();
    nexts.add( new Slide("intro\\1.jpg", "") );
    nexts.add( new Slide("intro\\2.jpg", "") );
    nexts.add( new Slide("intro\\3.jpg", "Kaiji Ito is in a massive amount of debt.") );
    nexts.add( new Slide("intro\\4.jpg", "He toils at his convinience store job,") );
    nexts.add( new Slide("intro\\5.jpg", "performing trivial tasks for pennies.") );
    nexts.add( new Slide("intro\\6.jpg", "But his wage of 900 yen wouldn't even pay his interest.") );
    nexts.add( new Slide("intro\\7.jpg", "Kaiji is in trouble. The cause of this?") );
    nexts.add( new Slide("intro\\8.jpg", "A crippling addition to gambling.") );
    nexts.add( new Slide("intro\\9.jpg", "One day at work, however, everything changed. You see...") );
    nexts.add( new Slide("intro\\10.jpg", "\"Kaiji! I have something to tell you!\"") );
    nexts.add( new Slide("intro\\10.jpg", "It was Kaiji's coworker and closest friend, Stant.") );
    nexts.add( new Slide("intro\\11.jpg", "\"Listen! I know a way we can make some money fast!\"") );
    nexts.add( new Slide("intro\\12.jpg", "\"Another MLM?! I told you, I'm not selling any tupperware!\"") );
    nexts.add( new Slide("intro\\13.jpg", "\"No, Kaiji, it's nothing like that this time.\"") );
    nexts.add( new Slide("intro\\14.jpg", "\"A guy named Endo called your cell. Naturally, I picked it up.\"") );
    nexts.add( new Slide("intro\\13.jpg", "\"He said we could make lots of money by playing games.\"") );
    nexts.add( new Slide("intro\\14.jpg", "\"However, if we lose, we could be put in grave danger.\"") );
    nexts.add( new Slide("intro\\15.jpg", "\"Like in Squid Games?\"") );
    nexts.add( new Slide("intro\\13.jpg", "\"Yeah, exactly like Squid Games.\"") );
    nexts.add( new Slide("intro\\16.jpg", "\"Sounds like gambling. I'm in.\"") );
    nexts.add( new Slide("intro\\17.jpg", "And so, the pair went off to Endo's house") );
    nexts.add( new Slide("intro\\17.jpg", "to try and build a better future for themselves.") );
    introSlide.setSlides(nexts);
    
    TwoPlayerIntro = new Slide("2p_intro\\0.jpg", "");
    nexts = new ArrayList<Slide>();
    nexts.add( new Slide("2p_intro\\1.jpg", "\"So, you've finally come.\"") );
    nexts.add( new Slide("2p_intro\\2.jpg", "\"I've been waiting for you Kaiji.\"") );
    nexts.add( new Slide("2p_intro\\3.jpg", "\"And you too, other guy.\"") );
    nexts.add( new Slide("2p_intro\\4.jpg", "\"Endo, I've just about had it with your sass.\"") );
    nexts.add( new Slide("2p_intro\\5.jpg", "\"Tell us what game we need to play so we can get money.\"") );
    nexts.add( new Slide("2p_intro\\2.jpg", "\"I'm getting there Kaiji.\"") );
    nexts.add( new Slide("2p_intro\\3.jpg", "\"The game is called footsteps.\"") );
    nexts.add( new Slide("2p_intro\\2.jpg", "\"You will each take turns betting yen.\"") );
    nexts.add( new Slide("2p_intro\\3.jpg", "\"Each round, whoever bets more yen,\"") );
    nexts.add( new Slide("2p_intro\\2.jpg", "\"will move the central token one space toward themself.\"") );
    nexts.add( new Slide("2p_intro\\6.jpg", "\"But Endo, we have no money.\"") );
    nexts.add( new Slide("2p_intro\\7.jpg", "\"How can we bet to move this token?\"") );
    nexts.add( new Slide("2p_intro\\2.jpg", "\"Good question.\"") );
    nexts.add( new Slide("2p_intro\\3.jpg", "\"In my generosity, I'll loan each of you 50,000 yen.\"") );
    nexts.add( new Slide("2p_intro\\2.jpg", "\"However, you must bet at least one thousand yen each turn.\"") );
    nexts.add( new Slide("2p_intro\\3.jpg", "\"You'll decide how much yen, in thousands, you will bet each turn.\"") );
    nexts.add( new Slide("2p_intro\\2.jpg", "\"You may only bet nothing if you run out of yen.\"") );
    nexts.add( new Slide("2p_intro\\4.jpg", "\"So how do we win the game?\"") );
    nexts.add( new Slide("2p_intro\\2.jpg", "\"Kaiji I'm getting there. Stop talking.\"") );
    nexts.add( new Slide("2p_intro\\3.jpg", "\"If you move the token all the way to your side and win a bet,\"") );
    nexts.add( new Slide("2p_intro\\2.jpg", "\"you will win the game.\"") );
    nexts.add( new Slide("2p_intro\\3.jpg", "\"If both of you run out of money and no one has won,\"") );
    nexts.add( new Slide("2p_intro\\2.jpg", "\"Whoever is closest will win.\"") );
    nexts.add( new Slide("2p_intro\\3.jpg", "\"And one more thing: Neither of you can know each other's bets.\"") );
    nexts.add( new Slide("2p_intro\\2.jpg", "\"So, you must look away while the other player is typing.\"") );
    nexts.add( new Slide("2p_intro\\1.jpg", "And so, the duo of friends began their fight for victory.") );
    TwoPlayerIntro.setSlides(nexts);
    
    
    kaijiWin = new Slide("end\\0.jpg", "Kaiji Wins!");
    
    stantWin = new Slide("end\\1.jpg", "Stant Wins!");
    
    tie = new Slide("end\\2.jpg", "Nobody wins...");
    
  }
  
}
//Extends the GameData class to complete it and allow it to be played with two players.
public class TwoPlayerGame extends GameData {
  final String bg_path = "game\\table.png";
  PImage bg;
  final int[] STAR_SPOT_Y = new int[]{38, 85, 136, 204, 280, 379, 485};
  int star_w = 120;
  int star_h = 120;
  
  final int TEXT_SPEED = 11;
  final int STAR_SPEED = 10;
  
  String bet_text = "";
  
  public TwoPlayerGame() {
    super();
    star = new Star( width/2, STAR_SPOT_Y[3], star_w, star_h );
    bg = loadImage(bg_path);
  }
  
  public void run() {
    image(bg, 0, 0, width, height);
    
    fill(0);
    textSize(36);
    textAlign(LEFT);
    text("Kaiji: " + p1.getPoints() + ",000 yen", 20, 60);
    textAlign(RIGHT);
    text("Stant: " + p2.getPoints() + ",000 yen", width-20, 60);
    
    star.run();
    
    switch (turn) {
      case 1:
        p1Turn();
        break;
        
      case 2:
        p2Turn();
        break;
      
      case 3:
        afterTurn();
        break;
      
      case 4:
        results();
        break;
      
      default:
        break;
    }
    
    turn_timer += 1;
  }
  
  public void p1Turn() {
    fill(255);
    textAlign(LEFT);
    textSize(72);
    text("Kaiji's Turn", 20, 160);
    textSize(24);
    text("Stant, look away now.", 20, 190);
    textSize(36);
    text("bet: " + bet_text, 20, 290);
  }
  
  public void p2Turn() {
    fill(255);
    textAlign(RIGHT);
    textSize(72);
    text("Stant's Turn", width-20, 160);
    textSize(24);
    text("Kaiji, look away now.", width-20, 190);
    textSize(36);
    textAlign(LEFT);
    text("bet: " + bet_text, width-220, 290);
  }
  
  public void afterTurn() {
    textSize(72);
    textAlign(CENTER);
    fill(0);
    
    text("Kaiji's bet: " + p1.getSpending() + ",000 yen", turn_timer * TEXT_SPEED, 250);
    text("Stant's bet: " + p2.getSpending() + ",000 yen", width - turn_timer * TEXT_SPEED, 350);
    
    if (turn_timer * TEXT_SPEED > width + 200) {
      nextTurn();
    }
  }
  
  public void results() {
    //first time called.
    if (star_dir == 0) {
      
      if (p1.getSpending() > p2.getSpending()) {
        star_pos += 1;
        star_dir = 1;
      }
      else if (p1.getSpending() < p2.getSpending()) {
        star_pos -= 1;
        star_dir = -1;
      }
      else {
        star_dir = 0;
      }
      p1.spendPoints();
      p2.spendPoints();
    }
    
    //If player 1 wins
    if (star_pos > 7) {
      cur_slide = slideData.kaijiWin;
      cur_scene = "gameend";
    }
    
    //If player 2 wins
    else if (star_pos < 1) {
      cur_slide = slideData.stantWin;
      cur_scene = "gameend";
    }
    
    //Otherwise
    else {
    
      if (star_dir > 0) {
        if (star.y < STAR_SPOT_Y[star_pos - 1]) {
          star.y += STAR_SPEED;
        }
        else {
          star_dir = 0;
          setTurn(1);
        }
      }
      else if (star_dir < 0) {
        if (star.y > STAR_SPOT_Y[star_pos - 1]) {
          star.y -= STAR_SPEED;
        }
        else {
          star_dir = 0;
          setTurn(1);
        }
      }
      else {
        setTurn (1);
      }
    
    }
    
    //check to see if no one has money.
    
    if (p1.getPoints() == 0 && p2.getPoints() == 0) {
      if (star_pos > 4) {
        cur_slide = slideData.kaijiWin;
        cur_scene = "gameend";
      }
      else if (star_pos < 4) {
        cur_slide = slideData.stantWin;
        cur_scene = "gameend";
      }
      else {
        cur_slide = slideData.tie;
        cur_scene = "gameend";
      }
    }
    
  }
  
  public void planSpend(Player p) {
    
    if (bet_text != "") {
      int spend = Integer.parseInt(bet_text);
      if (spend <= p.getPoints()) {
        if (spend > 0 || p.getPoints() == 0) {
          p.planSpending(spend);
          nextTurn();
          bet_text = "";
        }
      }
    }
  }
  
  public void nextTurn() {
    turn += 1;
    turn_timer = 0;
  }
  
  public void setTurn(int t) {
    turn = t;
    turn_timer = 0;
  }
  
  public void keyPress(char key) {
    if (key >= '0' && key <= '9' && bet_text.length() < 2) {
      bet_text += key;
    }
    else if (key == BACKSPACE)
    bet_text = bet_text.substring(0, max(0, bet_text.length()-1));
    if (turn == 1) {
      if (key == ENTER || key == ' ') {
        planSpend(p1);
      }
    }
    else if (turn == 2) {
      if (key == ENTER || key == ' ') {
        planSpend(p2);
      }
    }
  }
  
}


  public void settings() { size(960, 540); }

  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "KaijiGame" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
