
//Kaiji Game by Jsaur
//Version 1.0
//1 February 2024
//Credit to Nobuyuki Fukumoto and everyone involved with Kaiji ^_^

import processing.sound.*;

Slide cur_slide;
SlideData slideData;
MainMenu mainMenu;
TwoPlayerGame twoPlayerGame;

SoundFile music_menu;
final String music_menu_path = "music\\opening.mp3";

final int TEXT_MARGIN = 50;
final int TEXT_SIZE = 36;

String cur_scene = "intro";

void setup() {
  size(960, 540);
  frameRate(60);
  surface.setLocation(200, 50);
  
  slideData = new SlideData();
  cur_slide = slideData.introSlide;
  
  music_menu = new SoundFile(this, music_menu_path);
}

void draw() {
  
  switch (cur_scene) {
    case "intro":
      drawSlide();
      break;
    case "menu":
      drawMenu();
      break;
    case "2pgame":
      draw2PGame();
      break;
    case "2pintro":
      drawSlide();
      break;
    case "gameend":
      drawSlide();
      break;
  }
  
}

void setScene(String scn) {
  cur_scene = scn;
}

void setSlide(Slide sl) {
  cur_slide = sl;
}

void drawSlide() {
  image(cur_slide.getImg(), 0, 0, width, height);
  textSize(TEXT_SIZE);
  textAlign(CENTER);
  fill(255);
  text(cur_slide.getText(), width/2, height - TEXT_MARGIN); 
}

void startMenu() {
  cur_scene = "menu";
  mainMenu = new MainMenu();
}

void drawMenu() {
  mainMenu.run();
}

void start2PGame() {
  cur_scene = "2pgame";
  twoPlayerGame = new TwoPlayerGame();
}

void draw2PGame() {
  twoPlayerGame.run();
}

void keyPressed() {
  
  if (cur_scene == "2pgame") {
    twoPlayerGame.keyPress(key);
  }
  
  if (key == ' ') {
    if ( cur_slide.hasNext() ) {
      cur_slide = cur_slide.getNext();
    }
    else {
      if (cur_scene == "intro" || cur_scene == "gameend")
        startMenu();
      else if (cur_scene == "2pintro") {
        start2PGame();
      }
    }
  }
  
}
