//Extends the GameData class to complete it and allow it to be played with two players.
public class TwoPlayerGame extends GameData {
  final String bg_path = "game\\table.png";
  PImage bg;
  final int[] STAR_SPOT_Y = new int[]{38, 85, 136, 204, 280, 379, 485};
  int star_w = 120;
  int star_h = 120;
  
  final int TEXT_SPEED = 11;
  final int STAR_SPEED = 10;
  
  String bet_text = "";
  
  public TwoPlayerGame() {
    super();
    star = new Star( width/2, STAR_SPOT_Y[3], star_w, star_h );
    bg = loadImage(bg_path);
  }
  
  public void run() {
    image(bg, 0, 0, width, height);
    
    fill(0);
    textSize(36);
    textAlign(LEFT);
    text("Kaiji: " + p1.getPoints() + ",000 yen", 20, 60);
    textAlign(RIGHT);
    text("Stant: " + p2.getPoints() + ",000 yen", width-20, 60);
    
    star.run();
    
    switch (turn) {
      case 1:
        p1Turn();
        break;
        
      case 2:
        p2Turn();
        break;
      
      case 3:
        afterTurn();
        break;
      
      case 4:
        results();
        break;
      
      default:
        break;
    }
    
    turn_timer += 1;
  }
  
  void p1Turn() {
    fill(255);
    textAlign(LEFT);
    textSize(72);
    text("Kaiji's Turn", 20, 160);
    textSize(24);
    text("Stant, look away now.", 20, 190);
    textSize(36);
    text("bet: " + bet_text, 20, 290);
  }
  
  void p2Turn() {
    fill(255);
    textAlign(RIGHT);
    textSize(72);
    text("Stant's Turn", width-20, 160);
    textSize(24);
    text("Kaiji, look away now.", width-20, 190);
    textSize(36);
    textAlign(LEFT);
    text("bet: " + bet_text, width-220, 290);
  }
  
  void afterTurn() {
    textSize(72);
    textAlign(CENTER);
    fill(0);
    
    text("Kaiji's bet: " + p1.getSpending() + ",000 yen", turn_timer * TEXT_SPEED, 250);
    text("Stant's bet: " + p2.getSpending() + ",000 yen", width - turn_timer * TEXT_SPEED, 350);
    
    if (turn_timer * TEXT_SPEED > width + 200) {
      nextTurn();
    }
  }
  
  void results() {
    //first time called.
    if (star_dir == 0) {
      
      if (p1.getSpending() > p2.getSpending()) {
        star_pos += 1;
        star_dir = 1;
      }
      else if (p1.getSpending() < p2.getSpending()) {
        star_pos -= 1;
        star_dir = -1;
      }
      else {
        star_dir = 0;
      }
      p1.spendPoints();
      p2.spendPoints();
    }
    
    //If player 1 wins
    if (star_pos > 7) {
      cur_slide = slideData.kaijiWin;
      cur_scene = "gameend";
    }
    
    //If player 2 wins
    else if (star_pos < 1) {
      cur_slide = slideData.stantWin;
      cur_scene = "gameend";
    }
    
    //Otherwise
    else {
    
      if (star_dir > 0) {
        if (star.y < STAR_SPOT_Y[star_pos - 1]) {
          star.y += STAR_SPEED;
        }
        else {
          star_dir = 0;
          setTurn(1);
        }
      }
      else if (star_dir < 0) {
        if (star.y > STAR_SPOT_Y[star_pos - 1]) {
          star.y -= STAR_SPEED;
        }
        else {
          star_dir = 0;
          setTurn(1);
        }
      }
      else {
        setTurn (1);
      }
    
    }
    
    //check to see if no one has money.
    
    if (p1.getPoints() == 0 && p2.getPoints() == 0) {
      if (star_pos > 4) {
        cur_slide = slideData.kaijiWin;
        cur_scene = "gameend";
      }
      else if (star_pos < 4) {
        cur_slide = slideData.stantWin;
        cur_scene = "gameend";
      }
      else {
        cur_slide = slideData.tie;
        cur_scene = "gameend";
      }
    }
    
  }
  
  void planSpend(Player p) {
    
    if (bet_text != "") {
      int spend = Integer.parseInt(bet_text);
      if (spend <= p.getPoints()) {
        if (spend > 0 || p.getPoints() == 0) {
          p.planSpending(spend);
          nextTurn();
          bet_text = "";
        }
      }
    }
  }
  
  void nextTurn() {
    turn += 1;
    turn_timer = 0;
  }
  
  void setTurn(int t) {
    turn = t;
    turn_timer = 0;
  }
  
  void keyPress(char key) {
    if (key >= '0' && key <= '9' && bet_text.length() < 2) {
      bet_text += key;
    }
    else if (key == BACKSPACE)
    bet_text = bet_text.substring(0, max(0, bet_text.length()-1));
    if (turn == 1) {
      if (key == ENTER || key == ' ') {
        planSpend(p1);
      }
    }
    else if (turn == 2) {
      if (key == ENTER || key == ' ') {
        planSpend(p2);
      }
    }
  }
  
}
