/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PImage;
import processing.sound.SoundFile;

public class KaijiGame
extends PApplet {
    Slide cur_slide;
    SlideData slideData;
    MainMenu mainMenu;
    TwoPlayerGame twoPlayerGame;
    SoundFile music_menu;
    final String music_menu_path = "music\\opening.mp3";
    final int TEXT_MARGIN = 50;
    final int TEXT_SIZE = 36;
    String cur_scene = "intro";

    public void setup() {
        this.frameRate(60.0f);
        this.surface.setLocation(200, 50);
        this.slideData = new SlideData();
        this.cur_slide = this.slideData.introSlide;
        this.music_menu = new SoundFile((PApplet)this, "music\\opening.mp3");
    }

    public void draw() {
        switch (this.cur_scene) {
            case "intro": {
                this.drawSlide();
                break;
            }
            case "menu": {
                this.drawMenu();
                break;
            }
            case "2pgame": {
                this.draw2PGame();
                break;
            }
            case "2pintro": {
                this.drawSlide();
                break;
            }
            case "gameend": {
                this.drawSlide();
            }
        }
    }

    public void setScene(String scn) {
        this.cur_scene = scn;
    }

    public void setSlide(Slide sl) {
        this.cur_slide = sl;
    }

    public void drawSlide() {
        this.image(this.cur_slide.getImg(), 0.0f, 0.0f, this.width, this.height);
        this.textSize(36.0f);
        this.textAlign(3);
        this.fill(255);
        this.text(this.cur_slide.getText(), this.width / 2, this.height - 50);
    }

    public void startMenu() {
        this.cur_scene = "menu";
        this.mainMenu = new MainMenu();
    }

    public void drawMenu() {
        this.mainMenu.run();
    }

    public void start2PGame() {
        this.cur_scene = "2pgame";
        this.twoPlayerGame = new TwoPlayerGame();
    }

    public void draw2PGame() {
        this.twoPlayerGame.run();
    }

    public void keyPressed() {
        if (this.cur_scene == "2pgame") {
            this.twoPlayerGame.keyPress(this.key);
        }
        if (this.key == ' ') {
            if (this.cur_slide.hasNext()) {
                this.cur_slide = this.cur_slide.getNext();
            } else if (this.cur_scene == "intro" || this.cur_scene == "gameend") {
                this.startMenu();
            } else if (this.cur_scene == "2pintro") {
                this.start2PGame();
            }
        }
    }

    public void settings() {
        this.size(960, 540);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"KaijiGame"};
        if (passedArgs != null) {
            PApplet.main((String[])KaijiGame.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    public class GameData {
        final int START_POINTS = 50;
        Player p1;
        Player p2;
        Star star;
        int star_pos = 4;
        int star_dir = 0;
        int turn = 1;
        int turn_timer = 0;

        public GameData() {
            this.p1 = new Player(50);
            this.p2 = new Player(50);
        }

        public void p1Turn() {
        }

        public void p2Turn() {
        }
    }

    public class MainMenu {
        final String bg_path = "mainmenu\\bg.png";
        PImage bg;
        MenuButton[] buttons = new MenuButton[2];
        SoundFile music;

        public MainMenu() {
            this.bg = KaijiGame.this.loadImage("mainmenu\\bg.png");
            this.buttons[0] = new MenuButton("2P Game", KaijiGame.this.width / 2 - 100, 200, 200, 60);
            this.buttons[0].setAction("2pstart");
            this.buttons[1] = new MenuButton("Exit", KaijiGame.this.width / 2 - 100, 400, 200, 60);
            this.buttons[1].setAction("exit");
            KaijiGame.this.music_menu.rate(1.08f);
            KaijiGame.this.music_menu.loop();
        }

        public void run() {
            KaijiGame.this.image(this.bg, 0.0f, 0.0f, KaijiGame.this.width, KaijiGame.this.height);
            KaijiGame.this.textSize(72.0f);
            KaijiGame.this.text("Kaiji for Windows Computer", KaijiGame.this.width / 2, KaijiGame.this.height / 4);
            MenuButton[] menuButtonArray = this.buttons;
            int n = this.buttons.length;
            int n2 = 0;
            while (n2 < n) {
                MenuButton b = menuButtonArray[n2];
                b.run();
                ++n2;
            }
            if (KaijiGame.this.cur_scene != "menu") {
                KaijiGame.this.music_menu.stop();
            }
        }
    }

    public class MenuButton {
        String text;
        int x;
        int y;
        int w;
        int h;
        String action;
        int col_normal;
        int col_hover;
        int col_press;
        boolean clicked_last_frame;

        public MenuButton(String txt, int x_pos, int y_pos, int wid, int hei) {
            this.col_normal = KaijiGame.this.color(120, 0, 0);
            this.col_hover = KaijiGame.this.color(90, 0, 0);
            this.col_press = KaijiGame.this.color(60, 0, 0);
            this.clicked_last_frame = false;
            this.text = txt;
            this.x = x_pos;
            this.y = y_pos;
            this.h = hei;
            this.w = wid;
        }

        public void setAction(String act) {
            this.action = act;
        }

        public void run() {
            if (this.isHover()) {
                KaijiGame.this.fill(this.col_hover);
                if (KaijiGame.this.mousePressed) {
                    KaijiGame.this.fill(this.col_press);
                    this.clicked_last_frame = true;
                } else if (this.clicked_last_frame) {
                    this.clickButton();
                }
            } else {
                KaijiGame.this.fill(this.col_normal);
            }
            KaijiGame.this.rect(this.x, this.y, this.w, this.h);
            KaijiGame.this.fill(255);
            KaijiGame.this.textAlign(3);
            KaijiGame.this.textSize(24.0f);
            KaijiGame.this.text(this.text, this.x + this.w / 2, this.y + 2 * this.h / 3);
        }

        public void clickButton() {
            switch (this.action) {
                case "2pstart": {
                    KaijiGame.this.setSlide(KaijiGame.this.slideData.TwoPlayerIntro);
                    KaijiGame.this.setScene("2pintro");
                    break;
                }
                case "exit": {
                    KaijiGame.this.exit();
                }
            }
        }

        public boolean isHover() {
            return KaijiGame.this.mouseX >= this.x && KaijiGame.this.mouseX <= this.x + this.w && KaijiGame.this.mouseY >= this.y && KaijiGame.this.mouseY <= this.y + this.h;
        }
    }

    class Player {
        int points;
        int spending;

        public Player(int p) {
            this.points = p;
        }

        public int getPoints() {
            return this.points;
        }

        public int getSpending() {
            return this.spending;
        }

        public boolean planSpending(int plan) {
            boolean canSpend = false;
            if (plan <= this.points) {
                this.spending = plan;
                canSpend = true;
            }
            return canSpend;
        }

        public void spendPoints() {
            this.points -= this.spending;
        }

        public boolean hasPoints() {
            return this.points > 0;
        }
    }

    public class Slide {
        PImage img;
        String text;
        Slide nextSlide;

        public Slide(String img_path, String txt) {
            this.setImg(img_path);
            this.setText(txt);
            this.nextSlide = null;
        }

        public void setImg(String img_path) {
            this.img = KaijiGame.this.loadImage(img_path);
        }

        public void setText(String txt) {
            this.text = txt;
        }

        public void setNext(Slide next) {
            this.nextSlide = next;
        }

        public PImage getImg() {
            return this.img;
        }

        public String getText() {
            return this.text;
        }

        public Slide getNext() {
            return this.nextSlide;
        }

        public boolean hasNext() {
            boolean has = true;
            if (this.nextSlide == null) {
                has = false;
            }
            return has;
        }

        public void setSlides(ArrayList<Slide> slides) {
            Slide cur_slide = this;
            int i = 0;
            while (i < slides.size()) {
                cur_slide.setNext(slides.get(i));
                cur_slide = cur_slide.getNext();
                ++i;
            }
        }
    }

    public class SlideData {
        public Slide introSlide;
        public Slide TwoPlayerIntro;
        public Slide kaijiWin;
        public Slide stantWin;
        public Slide tie;

        public SlideData() {
            this.introSlide = new Slide("intro\\0.jpg", "Press the spacebar to continue.");
            ArrayList<Slide> nexts = new ArrayList<Slide>();
            nexts.add(new Slide("intro\\1.jpg", ""));
            nexts.add(new Slide("intro\\2.jpg", ""));
            nexts.add(new Slide("intro\\3.jpg", "Kaiji Ito is in a massive amount of debt."));
            nexts.add(new Slide("intro\\4.jpg", "He toils at his convinience store job,"));
            nexts.add(new Slide("intro\\5.jpg", "performing trivial tasks for pennies."));
            nexts.add(new Slide("intro\\6.jpg", "But his wage of 900 yen wouldn't even pay his interest."));
            nexts.add(new Slide("intro\\7.jpg", "Kaiji is in trouble. The cause of this?"));
            nexts.add(new Slide("intro\\8.jpg", "A crippling addition to gambling."));
            nexts.add(new Slide("intro\\9.jpg", "One day at work, however, everything changed. You see..."));
            nexts.add(new Slide("intro\\10.jpg", "\"Kaiji! I have something to tell you!\""));
            nexts.add(new Slide("intro\\10.jpg", "It was Kaiji's coworker and closest friend, Stant."));
            nexts.add(new Slide("intro\\11.jpg", "\"Listen! I know a way we can make some money fast!\""));
            nexts.add(new Slide("intro\\12.jpg", "\"Another MLM?! I told you, I'm not selling any tupperware!\""));
            nexts.add(new Slide("intro\\13.jpg", "\"No, Kaiji, it's nothing like that this time.\""));
            nexts.add(new Slide("intro\\14.jpg", "\"A guy named Endo called your cell. Naturally, I picked it up.\""));
            nexts.add(new Slide("intro\\13.jpg", "\"He said we could make lots of money by playing games.\""));
            nexts.add(new Slide("intro\\14.jpg", "\"However, if we lose, we could be put in grave danger.\""));
            nexts.add(new Slide("intro\\15.jpg", "\"Like in Squid Games?\""));
            nexts.add(new Slide("intro\\13.jpg", "\"Yeah, exactly like Squid Games.\""));
            nexts.add(new Slide("intro\\16.jpg", "\"Sounds like gambling. I'm in.\""));
            nexts.add(new Slide("intro\\17.jpg", "And so, the pair went off to Endo's house"));
            nexts.add(new Slide("intro\\17.jpg", "to try and build a better future for themselves."));
            this.introSlide.setSlides(nexts);
            this.TwoPlayerIntro = new Slide("2p_intro\\0.jpg", "");
            nexts = new ArrayList();
            nexts.add(new Slide("2p_intro\\1.jpg", "\"So, you've finally come.\""));
            nexts.add(new Slide("2p_intro\\2.jpg", "\"I've been waiting for you Kaiji.\""));
            nexts.add(new Slide("2p_intro\\3.jpg", "\"And you too, other guy.\""));
            nexts.add(new Slide("2p_intro\\4.jpg", "\"Endo, I've just about had it with your sass.\""));
            nexts.add(new Slide("2p_intro\\5.jpg", "\"Tell us what game we need to play so we can get money.\""));
            nexts.add(new Slide("2p_intro\\2.jpg", "\"I'm getting there Kaiji.\""));
            nexts.add(new Slide("2p_intro\\3.jpg", "\"The game is called footsteps.\""));
            nexts.add(new Slide("2p_intro\\2.jpg", "\"You will each take turns betting yen.\""));
            nexts.add(new Slide("2p_intro\\3.jpg", "\"Each round, whoever bets more yen,\""));
            nexts.add(new Slide("2p_intro\\2.jpg", "\"will move the central token one space toward themself.\""));
            nexts.add(new Slide("2p_intro\\6.jpg", "\"But Endo, we have no money.\""));
            nexts.add(new Slide("2p_intro\\7.jpg", "\"How can we bet to move this token?\""));
            nexts.add(new Slide("2p_intro\\2.jpg", "\"Good question.\""));
            nexts.add(new Slide("2p_intro\\3.jpg", "\"In my generosity, I'll loan each of you 50,000 yen.\""));
            nexts.add(new Slide("2p_intro\\2.jpg", "\"However, you must bet at least one thousand yen each turn.\""));
            nexts.add(new Slide("2p_intro\\3.jpg", "\"You'll decide how much yen, in thousands, you will bet each turn.\""));
            nexts.add(new Slide("2p_intro\\2.jpg", "\"You may only bet nothing if you run out of yen.\""));
            nexts.add(new Slide("2p_intro\\4.jpg", "\"So how do we win the game?\""));
            nexts.add(new Slide("2p_intro\\2.jpg", "\"Kaiji I'm getting there. Stop talking.\""));
            nexts.add(new Slide("2p_intro\\3.jpg", "\"If you move the token all the way to your side and win a bet,\""));
            nexts.add(new Slide("2p_intro\\2.jpg", "\"you will win the game.\""));
            nexts.add(new Slide("2p_intro\\3.jpg", "\"If both of you run out of money and no one has won,\""));
            nexts.add(new Slide("2p_intro\\2.jpg", "\"Whoever is closest will win.\""));
            nexts.add(new Slide("2p_intro\\3.jpg", "\"And one more thing: Neither of you can know each other's bets.\""));
            nexts.add(new Slide("2p_intro\\2.jpg", "\"So, you must look away while the other player is typing.\""));
            nexts.add(new Slide("2p_intro\\1.jpg", "And so, the duo of friends began their fight for victory."));
            this.TwoPlayerIntro.setSlides(nexts);
            this.kaijiWin = new Slide("end\\0.jpg", "Kaiji Wins!");
            this.stantWin = new Slide("end\\1.jpg", "Stant Wins!");
            this.tie = new Slide("end\\2.jpg", "Nobody wins...");
        }
    }

    class Star {
        final String imgPath = "game\\star.png";
        PImage img;
        int x;
        int y;
        int w;
        int h;
        int init_h;

        public Star(int x_pos, int y_pos, int wid, int hei) {
            this.x = x_pos;
            this.y = y_pos;
            this.w = wid;
            this.h = hei;
            this.init_h = hei;
            this.img = KaijiGame.this.loadImage("game\\star.png");
        }

        public void run() {
            KaijiGame.this.image(this.img, this.x - this.w / 2, this.y - this.h / 2, this.w, this.h);
        }

        public void setSize(int wid, int hei) {
            this.w = wid;
            this.h = hei;
        }
    }

    public class TwoPlayerGame
    extends GameData {
        final String bg_path = "game\\table.png";
        PImage bg;
        final int[] STAR_SPOT_Y = new int[]{38, 85, 136, 204, 280, 379, 485};
        int star_w = 120;
        int star_h = 120;
        final int TEXT_SPEED = 11;
        final int STAR_SPEED = 10;
        String bet_text = "";

        public TwoPlayerGame() {
            this.star = new Star(KaijiGame.this.width / 2, this.STAR_SPOT_Y[3], this.star_w, this.star_h);
            this.bg = KaijiGame.this.loadImage("game\\table.png");
        }

        public void run() {
            KaijiGame.this.image(this.bg, 0.0f, 0.0f, KaijiGame.this.width, KaijiGame.this.height);
            KaijiGame.this.fill(0);
            KaijiGame.this.textSize(36.0f);
            KaijiGame.this.textAlign(37);
            KaijiGame.this.text("Kaiji: " + this.p1.getPoints() + ",000 yen", 20.0f, 60.0f);
            KaijiGame.this.textAlign(39);
            KaijiGame.this.text("Stant: " + this.p2.getPoints() + ",000 yen", KaijiGame.this.width - 20, 60.0f);
            this.star.run();
            switch (this.turn) {
                case 1: {
                    this.p1Turn();
                    break;
                }
                case 2: {
                    this.p2Turn();
                    break;
                }
                case 3: {
                    this.afterTurn();
                    break;
                }
                case 4: {
                    this.results();
                    break;
                }
            }
            ++this.turn_timer;
        }

        @Override
        public void p1Turn() {
            KaijiGame.this.fill(255);
            KaijiGame.this.textAlign(37);
            KaijiGame.this.textSize(72.0f);
            KaijiGame.this.text("Kaiji's Turn", 20.0f, 160.0f);
            KaijiGame.this.textSize(24.0f);
            KaijiGame.this.text("Stant, look away now.", 20.0f, 190.0f);
            KaijiGame.this.textSize(36.0f);
            KaijiGame.this.text("bet: " + this.bet_text, 20.0f, 290.0f);
        }

        @Override
        public void p2Turn() {
            KaijiGame.this.fill(255);
            KaijiGame.this.textAlign(39);
            KaijiGame.this.textSize(72.0f);
            KaijiGame.this.text("Stant's Turn", KaijiGame.this.width - 20, 160.0f);
            KaijiGame.this.textSize(24.0f);
            KaijiGame.this.text("Kaiji, look away now.", KaijiGame.this.width - 20, 190.0f);
            KaijiGame.this.textSize(36.0f);
            KaijiGame.this.textAlign(37);
            KaijiGame.this.text("bet: " + this.bet_text, KaijiGame.this.width - 220, 290.0f);
        }

        public void afterTurn() {
            KaijiGame.this.textSize(72.0f);
            KaijiGame.this.textAlign(3);
            KaijiGame.this.fill(0);
            KaijiGame.this.text("Kaiji's bet: " + this.p1.getSpending() + ",000 yen", this.turn_timer * 11, 250.0f);
            KaijiGame.this.text("Stant's bet: " + this.p2.getSpending() + ",000 yen", KaijiGame.this.width - this.turn_timer * 11, 350.0f);
            if (this.turn_timer * 11 > KaijiGame.this.width + 200) {
                this.nextTurn();
            }
        }

        public void results() {
            if (this.star_dir == 0) {
                if (this.p1.getSpending() > this.p2.getSpending()) {
                    ++this.star_pos;
                    this.star_dir = 1;
                } else if (this.p1.getSpending() < this.p2.getSpending()) {
                    --this.star_pos;
                    this.star_dir = -1;
                } else {
                    this.star_dir = 0;
                }
                this.p1.spendPoints();
                this.p2.spendPoints();
            }
            if (this.star_pos > 7) {
                KaijiGame.this.cur_slide = KaijiGame.this.slideData.kaijiWin;
                KaijiGame.this.cur_scene = "gameend";
            } else if (this.star_pos < 1) {
                KaijiGame.this.cur_slide = KaijiGame.this.slideData.stantWin;
                KaijiGame.this.cur_scene = "gameend";
            } else if (this.star_dir > 0) {
                if (this.star.y < this.STAR_SPOT_Y[this.star_pos - 1]) {
                    this.star.y += 10;
                } else {
                    this.star_dir = 0;
                    this.setTurn(1);
                }
            } else if (this.star_dir < 0) {
                if (this.star.y > this.STAR_SPOT_Y[this.star_pos - 1]) {
                    this.star.y -= 10;
                } else {
                    this.star_dir = 0;
                    this.setTurn(1);
                }
            } else {
                this.setTurn(1);
            }
            if (this.p1.getPoints() == 0 && this.p2.getPoints() == 0) {
                if (this.star_pos > 4) {
                    KaijiGame.this.cur_slide = KaijiGame.this.slideData.kaijiWin;
                    KaijiGame.this.cur_scene = "gameend";
                } else if (this.star_pos < 4) {
                    KaijiGame.this.cur_slide = KaijiGame.this.slideData.stantWin;
                    KaijiGame.this.cur_scene = "gameend";
                } else {
                    KaijiGame.this.cur_slide = KaijiGame.this.slideData.tie;
                    KaijiGame.this.cur_scene = "gameend";
                }
            }
        }

        public void planSpend(Player p) {
            int spend;
            if (this.bet_text != "" && (spend = Integer.parseInt(this.bet_text)) <= p.getPoints() && (spend > 0 || p.getPoints() == 0)) {
                p.planSpending(spend);
                this.nextTurn();
                this.bet_text = "";
            }
        }

        public void nextTurn() {
            ++this.turn;
            this.turn_timer = 0;
        }

        public void setTurn(int t) {
            this.turn = t;
            this.turn_timer = 0;
        }

        public void keyPress(char key) {
            if (key >= '0' && key <= '9' && this.bet_text.length() < 2) {
                this.bet_text = String.valueOf(this.bet_text) + key;
            } else if (key == '\b') {
                this.bet_text = this.bet_text.substring(0, KaijiGame.max((int)0, (int)(this.bet_text.length() - 1)));
            }
            if (this.turn == 1) {
                if (key == '\n' || key == ' ') {
                    this.planSpend(this.p1);
                }
            } else if (this.turn == 2 && (key == '\n' || key == ' ')) {
                this.planSpend(this.p2);
            }
        }
    }
}

