//Simple button that can be coded to do many things.
public class MenuButton {
  String text; //text displayed on button
  int x; //x position of top-left corner
  int y; //y position of top-left corner
  int w; //width of button
  int h; //height of button
  
  String action; //correlates to what the button does.
  
  color col_normal = color(120, 0, 0);
  color col_hover = color(90, 0, 0);
  color col_press = color(60, 0, 0);
  
  boolean clicked_last_frame = false;
  
  public MenuButton(String txt, int x_pos, int y_pos, int wid, int hei) {
    text = txt;
    x = x_pos;
    y = y_pos;
    h = hei;
    w = wid;
  }
  
  public void setAction(String act) {
    action = act;
  }
  
  //draw function for the menu button.
  public void run() {
    if (isHover()) {
      fill(col_hover);
      if (mousePressed) {
        fill(col_press);
        clicked_last_frame = true;
      }
      else if (clicked_last_frame) {
        clickButton();
      }
    }
    else {
      fill(col_normal);
    }
    rect(x, y, w, h);
    fill(255);
    textAlign(CENTER);
    textSize(24);
    text(text, (x+w/2), (y+2*h/3));
  }
  
  void clickButton() {
    
    switch (action) {
      case "2pstart":
        setSlide(slideData.TwoPlayerIntro);
        
        setScene("2pintro");
        break;
      case "exit":
        exit();
        break;
    }
    
    //just for the now button. change later.
    
  }
  
  boolean isHover() {
    if (mouseX >= x && mouseX <= x+w && 
      mouseY >= y && mouseY <= y+h) {
      return true;
    } else {
      return false;
    }
  }
  
}
