/*
Class that contains data for a single slide, including an image and a caption.
This is how the game will convey story and instructions.
*/
public class Slide {
  PImage img;
  String text;
  Slide nextSlide;
  
  public Slide(String img_path, String txt) {
    setImg(img_path);
    setText(txt);
    nextSlide = null;
  }
  
  //Setter method for the slide's image (backdrop).
  public void setImg(String img_path) {
    img = loadImage(img_path);
  }
  
  //Setter method for the slide's text (caption).
  public void setText(String txt) {
    text = txt;
  }
  
  //Setter method for the next slide.
  public void setNext(Slide next) {
    nextSlide = next;
  }
  
  //Getter method for the slide's image (backdrop).
  public PImage getImg() {
    return img;
  }
  
  //Getter method for the slide's text (caption).
  public String getText() {
    return text;
  }
  
  //Getter method for the next slide.
  public Slide getNext() {
    return nextSlide;
  }
  
  //Returns true if there is another slide in this slideshow, false otherwise.
  public boolean hasNext() {
    boolean has = true;
    if (nextSlide == null) has = false;
    return has;
  }
  
  //Sets the next n slides for this slide, where n is the size of the array of
  //slides you give it.
  public void setSlides(ArrayList<Slide> slides) {
    Slide cur_slide = this;
    for (int i = 0; i < slides.size(); i++) {
      cur_slide.setNext(slides.get(i));
      cur_slide = cur_slide.getNext();
    }
  }
  
}
