/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioPlayer;
import ddf.minim.Minim;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import processing.core.PApplet;
import processing.core.PImage;

public class MusicGame
extends PApplet {
    final int FRAME_RATE = 60;
    final int REAL_WIDTH = 960;
    final int REAL_HEIGHT = 540;
    float NOTE_SPEED = 300.0f;
    int VISUAL_AUDIO_BUFFER = 2;
    final float GAME_SPEED = 1.0f;
    final float MEASURES_PER_PHASE = 8.0f;
    int screen_resolution_x = 960;
    int screen_resolution_y = 540;
    Minim minim;
    AudioPlayer AP_percussion;
    AudioPlayer AP_bass;
    Scene main;
    Scene settingsMenu;
    Scene gameScene;
    Scene instructions;
    Scene current;
    GlobalData globalData;

    public void setup() {
        this.frameRate(60.0f);
        this.minim = new Minim((Object)this);
        this.AP_percussion = this.minim.loadFile("song0\\percussion.mp3");
        this.AP_bass = this.minim.loadFile("song0\\bass.mp3");
        this.globalData = new GlobalData();
        this.main = new MainMenu();
        this.settingsMenu = new SettingsMenu();
        this.gameScene = new GameScene();
        this.instructions = new Instructions();
        this.current = this.main;
    }

    public void draw() {
        this.background(this.color(204));
        this.current.draw();
        this.fill(this.color(0));
        this.rect(960.0f, -100.0f, 10000.0f, 10000.0f);
        this.rect(-10.0f, 540.0f, 10000.0f, 10000.0f);
    }

    public void keyPressed() {
        switch (this.keyCode) {
            case 37: 
            case 49: 
            case 65: {
                ((GameScene)this.gameScene).rhythmPanel.keyPress(0);
                break;
            }
            case 40: 
            case 50: 
            case 83: {
                ((GameScene)this.gameScene).rhythmPanel.keyPress(1);
                break;
            }
            case 39: 
            case 51: 
            case 68: {
                ((GameScene)this.gameScene).rhythmPanel.keyPress(2);
                break;
            }
            case 38: 
            case 52: 
            case 87: {
                ((GameScene)this.gameScene).rhythmPanel.keyPress(3);
            }
        }
    }

    public void keyReleased() {
        switch (this.keyCode) {
            case 37: 
            case 49: 
            case 65: {
                ((GameScene)this.gameScene).rhythmPanel.keys[0].setPressed(false);
                break;
            }
            case 40: 
            case 50: 
            case 83: {
                ((GameScene)this.gameScene).rhythmPanel.keys[1].setPressed(false);
                break;
            }
            case 39: 
            case 51: 
            case 68: {
                ((GameScene)this.gameScene).rhythmPanel.keys[2].setPressed(false);
                break;
            }
            case 38: 
            case 52: 
            case 87: {
                ((GameScene)this.gameScene).rhythmPanel.keys[3].setPressed(false);
            }
        }
    }

    public int mouseX() {
        return (int)((float)this.mouseX * (960.0f / (float)this.screen_resolution_x));
    }

    public int mouseY() {
        return (int)((float)this.mouseY * (540.0f / (float)this.screen_resolution_y));
    }

    public void setResolution(int x) {
        this.screen_resolution_x = x;
        this.screen_resolution_y = (int)((float)x * 0.5625f);
    }

    public void settings() {
        this.size(960, 540);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"MusicGame"};
        if (passedArgs != null) {
            PApplet.main((String[])MusicGame.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    public class BassGuitar
    extends InstrumentData {
        public BassGuitar(String nam, int mod) {
            super(nam, "guitar", "rhythm", "low", mod, 3);
        }
    }

    public class Button {
        int x;
        int y;
        int w;
        int h;
        final int BUFFER = 1;
        int col;
        int hover_col;
        int press_col;
        boolean pressed = false;
        boolean last_frame_pressed = false;

        public Button(int xi, int yi, int wi, int hi) {
            this.x = xi;
            this.y = yi;
            this.w = wi;
            this.h = hi;
            this.col = MusicGame.this.color(255);
            this.hover_col = MusicGame.this.color(191);
            this.press_col = MusicGame.this.color(127);
        }

        public Button(int xi, int yi, int wi, int hi, int c, int hc, int pc) {
            this.x = xi;
            this.y = yi;
            this.w = wi;
            this.h = hi;
            this.col = c;
            this.hover_col = hc;
            this.press_col = pc;
        }

        public boolean isHovered() {
            boolean hover = MusicGame.this.mouseX() - 1 < this.x ? false : (MusicGame.this.mouseY() - 1 < this.y ? false : (MusicGame.this.mouseX() + 1 > this.x + this.w ? false : MusicGame.this.mouseY() + 1 <= this.y + this.h));
            return hover;
        }

        public boolean isPressed() {
            return MusicGame.this.mousePressed && this.isHovered();
        }

        public boolean isJustPressed() {
            return this.last_frame_pressed && !MusicGame.this.mousePressed && this.isHovered();
        }

        public void draw() {
            this.last_frame_pressed = this.pressed;
            this.pressed = this.isPressed();
            int c = this.col;
            if (this.isPressed()) {
                c = this.press_col;
            } else if (this.isHovered()) {
                c = this.hover_col;
            }
            MusicGame.this.fill(c);
            MusicGame.this.rect(this.x, this.y, this.w, this.h);
        }

        public void setColors(int c, int hc, int pc) {
            this.col = c;
            this.hover_col = hc;
            this.press_col = pc;
        }

        public void setWhite() {
            this.setColors(MusicGame.this.color(255), MusicGame.this.color(191), MusicGame.this.color(127));
        }

        public void setGray() {
            this.setColors(MusicGame.this.color(127), MusicGame.this.color(63), MusicGame.this.color(0));
        }

        public void setBlack() {
            this.setColors(MusicGame.this.color(0), MusicGame.this.color(63), MusicGame.this.color(127));
        }

        public void setBlue() {
            this.setColors(MusicGame.this.color(0, 0, 255), MusicGame.this.color(0, 0, 191), MusicGame.this.color(0, 0, 127));
        }

        public void setLightBlue() {
            this.setColors(MusicGame.this.color(127, 127, 255), MusicGame.this.color(127, 127, 191), MusicGame.this.color(127, 127, 127));
        }

        public void setRed() {
            this.setColors(MusicGame.this.color(255, 0, 0), MusicGame.this.color(191, 0, 0), MusicGame.this.color(127, 0, 0));
        }

        public void setLightRed() {
            this.setColors(MusicGame.this.color(255, 127, 127), MusicGame.this.color(191, 127, 127), MusicGame.this.color(127, 127, 127));
        }
    }

    public class DataPanel {
        int x_mod;
        int y_mod;
        boolean show = false;
        String nam;
        String typ;
        String lvl;
        String max_stam;
        String cur_stam;
        String speed;
        String melody;
        String rhythm;
        String focus;
        String tempo;
        String equipped;

        public DataPanel(int xi, int yi) {
            this.x_mod = xi;
            this.y_mod = yi;
        }

        public void updateData(UnitData data) {
            if (data != null) {
                this.show = true;
                this.nam = data.unit_name;
                this.typ = data.instrument_type;
                this.lvl = "1";
                this.max_stam = Integer.toString(data.max_stamina);
                this.cur_stam = Integer.toString(data.cur_stamina);
                this.speed = Integer.toString(data.speed);
                this.melody = Integer.toString(data.melody);
                this.rhythm = Integer.toString(data.rhythm);
                this.focus = Integer.toString(data.focus);
                this.tempo = Integer.toString(data.tempo);
                this.equipped = data.inventory[0] != null ? data.inventory[0].item_name : "";
            } else {
                this.show = false;
            }
        }

        public void draw() {
            if (this.show) {
                MusicGame.this.fill(MusicGame.this.color(255));
                MusicGame.this.rect(0 + this.x_mod, 0 + this.y_mod, 128.0f, 128.0f);
                MusicGame.this.textAlign(37);
                MusicGame.this.fill(MusicGame.this.color(0));
                MusicGame.this.textSize(32.0f);
                this.Label(this.nam, 140.0f, 30.0f);
                MusicGame.this.textSize(24.0f);
                this.Label(this.typ, 140.0f, 60.0f);
                this.Label("Lv " + this.lvl, 140.0f, 90.0f);
                this.Label("STAMINA: " + this.cur_stam + "/" + this.max_stam, 0.0f, 160.0f);
                this.Label("MOVEMENT: " + this.speed, 0.0f, 190.0f);
                this.Label("MELODY: " + this.melody, 0.0f, 250.0f);
                this.Label("RHYTHM: " + this.rhythm, 0.0f, 280.0f);
                this.Label("FOCUS: " + this.focus, 140.0f, 250.0f);
                this.Label("TEMPO: " + this.tempo, 140.0f, 280.0f);
                this.Label("Equipped: " + this.equipped, 0.0f, 340.0f);
            }
        }

        public void Label(String t, float xi, float yi) {
            MusicGame.this.text(t, xi + (float)this.x_mod, yi + (float)this.y_mod);
        }
    }

    public class Drum
    extends InstrumentData {
        public Drum(String nam, String pit, int mod) {
            super(nam, "percussion", "rhythm", pit, mod, 4);
        }
    }

    public class GameScene
    extends Scene {
        MapUI mapUI;
        DataPanel dataPanel;
        RhythmPanel rhythmPanel;
        Button back;
        String turn;
        String phase;
        int turn_count;
        MapUnit hoveredTile;
        MapUnit selectedTile;
        MapUnit lastSelectedTile;
        MapUnit attackingUnit;
        int[] selectedCoords;
        int[] lastSelectedCoords;
        MapUnit tileForDataPanel;
        boolean[][] movRange;
        boolean[][] atkRange;
        MapUnit currentRhythmUnit;
        MapUnit justPressed;
        int[] justCoords;

        public GameScene() {
            this.mapUI = new MapUI(292, 20);
            this.dataPanel = new DataPanel(20, 20);
            this.rhythmPanel = new RhythmPanel(698, 120);
            this.back = new TextButton(20, 490, 100, 40, "Menu", 24);
            this.turn = "player";
            this.phase = "strategy";
            this.turn_count = 0;
            this.hoveredTile = null;
            this.selectedTile = null;
            this.lastSelectedTile = null;
            this.attackingUnit = null;
            this.selectedCoords = null;
            this.lastSelectedCoords = null;
            this.tileForDataPanel = null;
            this.movRange = null;
            this.atkRange = null;
        }

        @Override
        public void draw() {
            this.mapUI.draw();
            this.setHovered();
            if (this.attackingUnit == null) {
                this.setSelected();
            } else {
                this.setAttackSelected();
            }
            this.setDataPannel();
            this.dataPanel.draw();
            this.drawBattleTempo();
            this.rhythmPanel.draw();
            this.back.draw();
            if (this.back.isJustPressed()) {
                MusicGame.this.current = MusicGame.this.main;
                MusicGame.this.AP_percussion.pause();
                MusicGame.this.AP_bass.pause();
            }
        }

        public void drawBattleTempo() {
            MusicGame.this.fill(MusicGame.this.color(0));
            MusicGame.this.rect(698.0f, 20.0f, 242.0f, 30.0f);
            if (this.phase == "rhythm") {
                float percent = ((float)this.rhythmPanel.measure % 8.0f + this.rhythmPanel.beat) / 8.0f;
                int buffer = 1;
                if (percent > 0.0f) {
                    MusicGame.this.fill(MusicGame.this.color(0.0f, 255.0f * (1.0f - percent), 255.0f * percent));
                    MusicGame.this.rect(698 + buffer, 20 + buffer, (float)(242 - buffer) * percent, 30 - 2 * buffer);
                }
            } else {
                float percent = ((float)this.rhythmPanel.measure % 16.0f + this.rhythmPanel.beat) / 16.0f;
                int buffer = 1;
                if (percent > 0.0f) {
                    MusicGame.this.fill(MusicGame.this.color(0.0f, 255.0f * (1.0f - percent), 255.0f * percent));
                    MusicGame.this.rect(698 + buffer, 20 + buffer, (float)(242 - buffer) * percent, 30 - 2 * buffer);
                }
            }
            MusicGame.this.textAlign(37);
            MusicGame.this.textSize(20.0f);
            MusicGame.this.fill(MusicGame.this.color(0));
            if (this.phase == "strategy") {
                MusicGame.this.text(String.valueOf(this.phase) + " phase", 698.0f, 70.0f);
            } else {
                MusicGame.this.text("rhythm phase", 698.0f, 70.0f);
            }
            if (this.phase == "strategy") {
                MusicGame.this.text("Next: rhythm phase", 698.0f, 100.0f);
            }
        }

        public void setHovered() {
            this.hoveredTile = (MapUnit)this.mapUI.getHovered();
        }

        public void setSelected() {
            this.justPressed = (MapUnit)this.mapUI.getJustPressed();
            this.justCoords = this.mapUI.getJustPressedCoords();
            if (this.justPressed != null && this.justPressed.hasMoved) {
                this.justPressed = null;
                this.justCoords = null;
            }
            if (this.justPressed != null) {
                this.mapUI.updateTiles();
                this.lastSelectedTile = this.selectedTile;
                this.selectedTile = this.justPressed;
            }
            if (this.justCoords != null) {
                this.lastSelectedCoords = this.selectedCoords;
                this.selectedCoords = this.justCoords;
            }
            if (this.justPressed != null && this.selectedTile == this.lastSelectedTile) {
                this.deselect();
            }
            if (this.hoveredTile == null && MusicGame.this.mousePressed) {
                if (this.selectedTile != null) {
                    this.lastSelectedTile = this.selectedTile;
                }
                this.deselect();
            }
            if (this.justCoords != null) {
                this.checkMovement();
            }
        }

        public void setAttackSelected() {
            if ((MapUnit)this.mapUI.getJustPressed() != null) {
                this.attackingUnit.target = (MapUnit)this.mapUI.getJustPressed();
                this.attackingUnit.setTargeted(true);
                this.setRhythmPlayer(this.attackingUnit);
                if (this.attackingUnit == this.attackingUnit.target) {
                    this.attackingUnit.target = null;
                }
                this.attackingUnit = null;
                this.mapUI.updateTiles();
                if (!this.rhythmPanel.counting) {
                    this.checkEndOfTurn(1);
                }
            }
        }

        public void setDataPannel() {
            if (this.selectedTile != null) {
                this.dataPanel.updateData(this.selectedTile.data);
            } else if (this.hoveredTile != null) {
                this.dataPanel.updateData(this.hoveredTile.data);
            }
        }

        public void checkMovement() {
            if (this.selectedTile != null) {
                this.movRange = this.mapUI.showMovement(this.mapUI.mapData.getMovRange(this.selectedTile.x, this.selectedTile.y, this.selectedTile.obj_type), this.selectedTile.data.speed);
            } else if (this.lastSelectedTile != null && this.selectedCoords != null && this.movRange[this.selectedCoords[0]][this.selectedCoords[1]]) {
                this.mapUI.moveTile(this.selectedCoords[0], this.selectedCoords[1], this.lastSelectedTile);
                this.lastSelectedTile.setMoved(true);
                this.attackingUnit = this.lastSelectedTile;
                this.lastSelectedTile = null;
                this.mapUI.updateTiles();
                this.checkAttackRange();
            }
        }

        public void checkAttackRange() {
            this.atkRange = this.mapUI.showAttackRange(this.mapUI.mapData.getAtkRange(this.attackingUnit.x, this.attackingUnit.y, this.attackingUnit.obj_type), this.attackingUnit.data.getEquipped().range);
        }

        public void deselect() {
            this.selectedTile = null;
            this.selectedCoords = null;
            this.mapUI.updateTiles();
        }

        public String getTurn() {
            return this.turn;
        }

        public String getPhase() {
            return this.phase;
        }

        public void checkEndOfTurn(int index) {
            boolean end = true;
            int i = 0;
            while (i < this.mapUI.mapData.wid) {
                int j = 0;
                while (j < this.mapUI.mapData.hei) {
                    MapUnit unit = (MapUnit)this.mapUI.mapData.objects[i][j];
                    if (!(unit == null || unit.hasMoved && unit.hasTargeted || unit.obj_type != index)) {
                        end = false;
                    }
                    ++j;
                }
                ++i;
            }
            if (end) {
                this.endTurn();
            }
        }

        public void endTurn() {
            this.swapPhase();
            if (!this.rhythmPanel.counting) {
                this.rhythmPanel.initializeArrows();
            }
            ++this.turn_count;
        }

        public void swapPhase() {
            if (this.phase == "strategy") {
                this.phase = "rhythm";
            } else {
                this.phase = "strategy";
                this.startStrategy();
            }
        }

        public void startStrategy() {
            this.rhythmPanel.perc_unit.startTurn();
            this.rhythmPanel.bass_unit.startTurn();
            this.mapUI.updateTiles();
        }

        public void setInstrument(String ins) {
        }

        public void setRhythmPlayer(MapUnit unit) {
            if (unit.data.instrument_type == "Percussion") {
                this.rhythmPanel.perc_unit = unit;
            } else if (unit.data.instrument_type == "Guitar") {
                this.rhythmPanel.bass_unit = unit;
            }
        }
    }

    public class GlobalData {
        public UnitData vocalist;
        public UnitData guitarist;
        public UnitData bassist;
        public UnitData drummer;
        public UnitData keyboardist;
        public UnitData enemyDrummer;
        public UnitData trainingDummy;
        public ItemData microphone;
        public ItemData acoustic_guitar;
        public ItemData electric_guitar;
        public ItemData bass_guitar;
        public ItemData mobile_drum_kit;
        public ItemData marching_snare;
        public ItemData marching_bass;
        public ItemData synthesizer;
        public ItemData keytar;
        Dictionary<String, PImage> images;

        public GlobalData() {
            this.vocalist = new UnitData("Wyen", 42, 6, 7, 2, 4, 1, "Vocals");
            this.guitarist = new UnitData("Pandora", 48, 5, 6, 4, 3, 3, "Guitar");
            this.bassist = new UnitData("Benni", 60, 5, 3, 5, 2, 5, "Guitar");
            this.drummer = new UnitData("Casey", 54, 4, 1, 7, 1, 4, "Percussion");
            this.keyboardist = new UnitData("Alec", 45, 5, 5, 4, 2, 1, "Keyboard");
            this.enemyDrummer = new UnitData("Drummer", 50, 5, 1, 1, 1, 1, "Percussion");
            this.trainingDummy = new UnitData("Training Dummy", 100, 1, 1, 1, 1, 1, "Vocals");
            this.microphone = new Microphone("Microphone", 1);
            this.acoustic_guitar = new Guitar("Acoustic Guitar", 1);
            this.electric_guitar = new Guitar("Electric Guitar", 1);
            this.bass_guitar = new BassGuitar("Bass Guitar", 1);
            this.mobile_drum_kit = new Drum("Mobile Drum Kit", "mid", 1);
            this.marching_snare = new Drum("Marching Snare", "mid", 1);
            this.marching_bass = new Drum("Marching Bass", "low", 1);
            this.synthesizer = new Keyboard("Synthesizer", 1);
            this.keytar = new Keyboard("Keytar", 1);
            this.images = new Hashtable<String, PImage>();
            this.images.put("unit", MusicGame.this.loadImage("unit.png"));
            this.images.put("arrow_0", MusicGame.this.loadImage("arrow_left.png"));
            this.images.put("arrow_1", MusicGame.this.loadImage("arrow_down.png"));
            this.images.put("arrow_2", MusicGame.this.loadImage("arrow_right.png"));
            this.images.put("arrow_3", MusicGame.this.loadImage("arrow_up.png"));
            this.vocalist.giveItem(this.microphone);
            this.guitarist.giveItem(this.electric_guitar);
            this.bassist.giveItem(this.bass_guitar);
            this.drummer.giveItem(this.mobile_drum_kit);
            this.keyboardist.giveItem(this.synthesizer);
        }

        public MapData Map1() {
            int[][] nArrayArray = new int[20][];
            nArrayArray[0] = new int[15];
            nArrayArray[1] = new int[15];
            nArrayArray[2] = new int[15];
            nArrayArray[3] = new int[15];
            nArrayArray[4] = new int[15];
            nArrayArray[5] = new int[15];
            nArrayArray[6] = new int[15];
            int[] nArray = new int[15];
            nArray[0] = 1;
            nArray[1] = 1;
            nArray[2] = 1;
            nArray[3] = 1;
            nArray[4] = 1;
            nArray[5] = 1;
            nArray[6] = 1;
            nArray[14] = 1;
            nArrayArray[7] = nArray;
            int[] nArray2 = new int[15];
            nArray2[0] = 1;
            nArray2[1] = 1;
            nArray2[2] = 1;
            nArray2[3] = 1;
            nArray2[4] = 1;
            nArray2[5] = 1;
            nArray2[6] = 1;
            nArray2[7] = 1;
            nArray2[8] = 1;
            nArray2[9] = 1;
            nArray2[13] = 1;
            nArray2[14] = 1;
            nArrayArray[8] = nArray2;
            int[] nArray3 = new int[15];
            nArray3[0] = 1;
            nArray3[5] = 1;
            nArray3[6] = 1;
            nArray3[7] = 1;
            nArray3[8] = 1;
            nArray3[9] = 1;
            nArray3[10] = 1;
            nArray3[13] = 1;
            nArray3[14] = 1;
            nArrayArray[9] = nArray3;
            int[] nArray4 = new int[15];
            nArray4[7] = 1;
            nArray4[8] = 1;
            nArray4[9] = 1;
            nArray4[10] = 1;
            nArray4[14] = 1;
            nArrayArray[10] = nArray4;
            int[] nArray5 = new int[15];
            nArray5[8] = 1;
            nArray5[9] = 1;
            nArrayArray[11] = nArray5;
            nArrayArray[12] = new int[15];
            int[] nArray6 = new int[15];
            nArray6[4] = 1;
            nArrayArray[13] = nArray6;
            int[] nArray7 = new int[15];
            nArray7[5] = 1;
            nArrayArray[14] = nArray7;
            int[] nArray8 = new int[15];
            nArray8[2] = 1;
            nArray8[5] = 1;
            nArrayArray[15] = nArray8;
            int[] nArray9 = new int[15];
            nArray9[3] = 1;
            nArray9[4] = 1;
            nArrayArray[16] = nArray9;
            nArrayArray[17] = new int[15];
            nArrayArray[18] = new int[15];
            nArrayArray[19] = new int[15];
            int[][] terrainMap = nArrayArray;
            MapData map = new MapData(terrainMap);
            new MapUnit(1, this.vocalist);
            new MapUnit(1, this.guitarist);
            MapUnit playerC = new MapUnit(1, this.bassist);
            MapUnit playerD = new MapUnit(1, this.drummer);
            new MapUnit(1, this.keyboardist);
            new MapUnit(2, this.enemyDrummer);
            map.setTile(2, 18, playerC);
            map.setTile(3, 19, playerD);
            map.setTile(6, 16, new MapUnit(2, this.trainingDummy.copyUnit()));
            map.setTile(8, 14, new MapUnit(2, this.trainingDummy.copyUnit()));
            map.setTile(10, 15, new MapUnit(2, this.trainingDummy.copyUnit()));
            map.setTile(1, 11, new MapUnit(2, this.trainingDummy.copyUnit()));
            map.setTile(2, 12, new MapUnit(2, this.trainingDummy.copyUnit()));
            return map;
        }
    }

    public class Guitar
    extends InstrumentData {
        public Guitar(String nam, int mod) {
            super(nam, "guitar", "melody", "mid", mod, 5);
        }
    }

    public class ImgButton
    extends Button {
        String img_path;
        PImage img;

        public ImgButton(int xi, int yi, int wi, int hi, String ip) {
            super(xi, yi, wi, hi);
            this.setImage(ip);
        }

        public ImgButton(int xi, int yi, int wi, int hi, int c, int hc, int pc, String ip) {
            super(xi, yi, wi, hi, c, hc, pc);
            this.setImage(ip);
        }

        public void setImage(String ip) {
            this.img_path = ip;
            this.img = ip != null ? MusicGame.this.globalData.images.get(ip) : null;
        }

        @Override
        public void draw() {
            super.draw();
            if (this.img != null) {
                MusicGame.this.image(this.img, this.x, this.y, this.w, this.h);
            }
        }
    }

    public class Instructions
    extends Scene {
        TextButton back;
        TextButton prev;
        TextButton next;
        int page;
        final int MIN_PAGE = 0;
        final int MAX_PAGE = 5;

        public Instructions() {
            this.back = new TextButton(20, 20, 100, 40, "Menu", 24);
            this.prev = new TextButton(20, 490, 100, 40, "Prev", 24);
            this.next = new TextButton(840, 490, 100, 40, "Next", 24);
            this.page = 0;
            this.MIN_PAGE = 0;
            this.MAX_PAGE = 5;
        }

        @Override
        public void draw() {
            MusicGame.this.image(MusicGame.this.loadImage("instructions\\" + this.page + ".png"), 0.0f, 0.0f, MusicGame.this.width, MusicGame.this.height);
            this.back.draw();
            this.prev.draw();
            this.next.draw();
            if (this.back.isJustPressed()) {
                MusicGame.this.current = MusicGame.this.main;
            }
            if (this.prev.isJustPressed() && this.page > 0) {
                --this.page;
            }
            if (this.next.isJustPressed() && this.page < 5) {
                ++this.page;
            }
        }
    }

    public class InstrumentData
    extends ItemData {
        public String instrument_type;
        public String damage_type;
        public String pitch;
        public int damage_mod;
        public int range;

        public InstrumentData(String nam, String instr, String dmg, String pit, int mod, int ran) {
            super(nam);
            this.instrument_type = instr;
            this.damage_type = dmg;
            this.pitch = pit;
            this.damage_mod = mod;
            this.range = ran;
        }
    }

    public class ItemData {
        public String item_name;

        public ItemData(String nam) {
            this.item_name = nam;
        }
    }

    public class Keyboard
    extends InstrumentData {
        public Keyboard(String nam, int mod) {
            super(nam, "keyboard", "melody", "high", mod, 1);
        }
    }

    public class MainMenu
    extends Scene {
        TextButton play;
        TextButton info;
        TextButton gear;
        TextButton exit;

        public MainMenu() {
            this.play = new TextButton(50, 150, 200, 50, "Play", 32);
            this.info = new TextButton(50, 220, 200, 50, "Instructions", 32);
            this.gear = new TextButton(50, 290, 200, 50, "Settings", 32);
            this.exit = new TextButton(50, 360, 200, 50, "Exit", 32);
        }

        @Override
        public void draw() {
            this.play.draw();
            this.info.draw();
            this.gear.draw();
            this.exit.draw();
            if (this.play.isJustPressed()) {
                MusicGame.this.current = MusicGame.this.gameScene;
            }
            if (this.gear.isJustPressed()) {
                MusicGame.this.current = MusicGame.this.settingsMenu;
            }
            if (this.info.isJustPressed()) {
                MusicGame.this.current = MusicGame.this.instructions;
            }
            if (this.exit.isJustPressed()) {
                MusicGame.this.exit();
            }
        }
    }

    public class MapData {
        int wid;
        int hei;
        public MapObj[][] objects;
        int[][] terrain;

        public MapData(int[][] ter) {
            this.wid = ter[0].length;
            this.hei = ter.length;
            this.objects = new MapObj[this.wid][this.hei];
            this.terrain = ter;
        }

        public MapObj getTile(int x, int y) {
            return this.objects[x][y];
        }

        public void setTile(int x, int y, MapObj obj) {
            if (obj != null) {
                obj.setCoords(x, y);
            }
            this.objects[x][y] = obj;
        }

        public void moveTile(int x, int y, MapObj obj) {
            int[] oldCoords = obj.getCoords();
            this.setTile(x, y, obj);
            this.setTile(oldCoords[0], oldCoords[1], null);
        }

        public void initTiles() {
            int i = 0;
            while (i < this.wid) {
                int j = 0;
                while (j < this.hei) {
                    this.setTile(i, j, new MapObj(i, j, -1));
                    ++j;
                }
                ++i;
            }
        }

        public int[][] getMovRange(int x_pos, int y_pos, int typ) {
            int[][] tiles = new int[this.wid][this.hei];
            int i = 0;
            while (i < this.wid) {
                int j = 0;
                while (j < this.hei) {
                    tiles[i][j] = 999;
                    ++j;
                }
                ++i;
            }
            tiles = this.checkSpace(tiles, 0, x_pos, y_pos, typ, false);
            tiles = this.blockOffFullTiles(tiles);
            return tiles;
        }

        public int[][] getAtkRange(int x_pos, int y_pos, int typ) {
            int[][] tiles = new int[this.wid][this.hei];
            int i = 0;
            while (i < this.wid) {
                int j = 0;
                while (j < this.hei) {
                    tiles[i][j] = 999;
                    ++j;
                }
                ++i;
            }
            tiles = this.checkSpace(tiles, 0, x_pos, y_pos, typ, true);
            return tiles;
        }

        public int[][] checkSpace(int[][] tiles, int range, int x, int y, int typ, boolean noclip) {
            if (x >= 0 && x < this.wid && y >= 0 && y < this.hei) {
                if (this.canWalkThrough(x, y, typ) || noclip) {
                    if (range < tiles[x][y]) {
                        tiles[x][y] = range;
                        this.checkSpace(tiles, range + 1, x - 1, y, typ, noclip);
                        this.checkSpace(tiles, range + 1, x, y - 1, typ, noclip);
                        this.checkSpace(tiles, range + 1, x + 1, y, typ, noclip);
                        this.checkSpace(tiles, range + 1, x, y + 1, typ, noclip);
                    }
                } else {
                    tiles[x][y] = 999;
                }
            }
            return tiles;
        }

        public boolean canWalkThrough(int x, int y, int typ) {
            boolean can = true;
            if (this.terrain[y][x] == 1) {
                can = false;
            }
            switch (typ) {
                case 1: {
                    if (this.getTile(x, y) == null || this.getTile((int)x, (int)y).obj_type != 2) break;
                    can = false;
                    break;
                }
                case 2: {
                    if (this.getTile(x, y) == null || this.getTile((int)x, (int)y).obj_type != 1) break;
                    can = false;
                }
            }
            return can;
        }

        public int[][] blockOffFullTiles(int[][] tiles) {
            int i = 0;
            while (i < this.wid) {
                int j = 0;
                while (j < this.hei) {
                    if (this.objects[i][j] != null) {
                        tiles[i][j] = 999;
                    }
                    ++j;
                }
                ++i;
            }
            return tiles;
        }
    }

    public class MapNote {
        int dir;
        int measure;
        float beat;

        public MapNote(int d, int m, float b) {
            this.dir = d;
            this.measure = m;
            this.beat = b;
        }
    }

    public class MapObj {
        int x;
        int y;
        public int obj_type;

        public MapObj(int typ) {
            this.obj_type = typ;
        }

        public MapObj(int typ, int xi, int yi) {
            this.obj_type = typ;
            this.setCoords(xi, yi);
        }

        public void setCoords(int xi, int yi) {
            this.x = xi;
            this.y = yi;
        }

        public int[] getCoords() {
            return new int[]{this.x, this.y};
        }
    }

    public class MapUI {
        MapData mapData;
        ImgButton[][] tiles;
        int x_mod;
        int y_mod;
        int tile_wid = 25;
        int tile_hei = 25;

        public MapUI(int x, int y) {
            this.x_mod = x;
            this.y_mod = y;
            this.mapData = new GlobalData().Map1();
            this.tiles = new ImgButton[this.mapData.wid][this.mapData.hei];
            this.initializeMap();
            this.showTerrain();
            this.updateUnitTiles();
        }

        public void moveTile(int x, int y, MapObj unit) {
            this.mapData.moveTile(x, y, unit);
        }

        public void updateUnitTiles() {
            int i = 0;
            while (i < this.mapData.wid) {
                int j = 0;
                while (j < this.mapData.hei) {
                    MapUnit unit = (MapUnit)this.mapData.getTile(i, j);
                    ImgButton tile = this.tiles[i][j];
                    if (unit != null) {
                        if (unit.data.isDead()) {
                            unit = null;
                            this.mapData.setTile(i, j, null);
                            tile.setImage(null);
                        } else {
                            switch (unit.obj_type) {
                                case -1: {
                                    tile.setImage(null);
                                    break;
                                }
                                case 1: {
                                    if (unit.hasMoved) {
                                        tile.setGray();
                                    } else {
                                        tile.setBlue();
                                    }
                                    tile.setImage("unit");
                                    break;
                                }
                                case 2: {
                                    tile.setRed();
                                    tile.setImage("unit");
                                }
                            }
                        }
                    } else {
                        tile.setImage(null);
                    }
                    ++j;
                }
                ++i;
            }
        }

        public void updateTiles() {
            this.showTerrain();
            this.updateUnitTiles();
        }

        public void initializeMap() {
            int i = 0;
            while (i < this.mapData.wid) {
                int j = 0;
                while (j < this.mapData.hei) {
                    this.tiles[i][j] = new ImgButton(this.x_mod + this.tile_wid * i, this.y_mod + this.tile_hei * j, this.tile_wid, this.tile_hei, null);
                    ++j;
                }
                ++i;
            }
        }

        public void showTerrain() {
            int i = 0;
            while (i < this.mapData.wid) {
                int j = 0;
                while (j < this.mapData.hei) {
                    this.tiles[i][j].setWhite();
                    if (this.mapData.terrain[j][i] == 1) {
                        this.tiles[i][j].setBlack();
                    }
                    ++j;
                }
                ++i;
            }
        }

        public boolean[][] showMovement(int[][] map, int spaces) {
            boolean[][] movTiles = new boolean[this.tiles.length][this.tiles[0].length];
            int i = 0;
            while (i < this.mapData.wid) {
                int j = 0;
                while (j < this.mapData.hei) {
                    if (map[i][j] <= spaces) {
                        this.tiles[i][j].setLightBlue();
                        movTiles[i][j] = true;
                    } else {
                        movTiles[i][j] = false;
                    }
                    ++j;
                }
                ++i;
            }
            return movTiles;
        }

        public boolean[][] showAttackRange(int[][] map, int spaces) {
            boolean[][] movTiles = new boolean[this.tiles.length][this.tiles[0].length];
            int i = 0;
            while (i < this.mapData.wid) {
                int j = 0;
                while (j < this.mapData.hei) {
                    if (map[i][j] <= spaces) {
                        this.tiles[i][j].setLightRed();
                        movTiles[i][j] = true;
                    } else {
                        movTiles[i][j] = false;
                    }
                    ++j;
                }
                ++i;
            }
            return movTiles;
        }

        public void drawTiles() {
            ImgButton[][] imgButtonArray = this.tiles;
            int n = this.tiles.length;
            int n2 = 0;
            while (n2 < n) {
                ImgButton[] row;
                ImgButton[] imgButtonArray2 = row = imgButtonArray[n2];
                int n3 = row.length;
                int n4 = 0;
                while (n4 < n3) {
                    ImgButton tile = imgButtonArray2[n4];
                    tile.draw();
                    ++n4;
                }
                ++n2;
            }
        }

        public MapObj getHovered() {
            int i = 0;
            while (i < this.mapData.wid) {
                int j = 0;
                while (j < this.mapData.hei) {
                    if (this.tiles[i][j].isHovered()) {
                        return this.mapData.getTile(i, j);
                    }
                    ++j;
                }
                ++i;
            }
            return null;
        }

        public MapObj getJustPressed() {
            int i = 0;
            while (i < this.mapData.wid) {
                int j = 0;
                while (j < this.mapData.hei) {
                    if (this.tiles[i][j].isJustPressed()) {
                        return this.mapData.getTile(i, j);
                    }
                    ++j;
                }
                ++i;
            }
            return null;
        }

        public int[] getJustPressedCoords() {
            int i = 0;
            while (i < this.mapData.wid) {
                int j = 0;
                while (j < this.mapData.hei) {
                    if (this.tiles[i][j].isJustPressed()) {
                        return new int[]{i, j};
                    }
                    ++j;
                }
                ++i;
            }
            return null;
        }

        public void draw() {
            this.drawTiles();
        }
    }

    public class MapUnit
    extends MapObj {
        public UnitData data;
        public boolean hasMoved;
        public boolean hasTargeted;
        public MapUnit target;

        public MapUnit(int typ, UnitData d) {
            super(typ);
            this.hasMoved = false;
            this.hasTargeted = false;
            this.data = d;
        }

        public void setMoved(boolean mov) {
            this.hasMoved = mov;
        }

        public void setTargeted(boolean tar) {
            this.hasTargeted = tar;
        }

        public void startTurn() {
            this.hasMoved = false;
            this.hasTargeted = false;
        }
    }

    public class Microphone
    extends InstrumentData {
        public Microphone(String nam, int mod) {
            super(nam, "microphone", "melody", "high", mod, 1);
        }
    }

    public class RhythmArrow {
        int x;
        float y;
        int index;
        int key_y_value;
        boolean visible = true;
        RhythmPanel panel;
        int bpm = 134;
        int measure;
        float beat;
        final int IMG_HEIGHT = 48;
        final int POINT_CUTOFF = 20;
        final int Y_TO_MISS = 50;

        public RhythmArrow(RhythmPanel p, int xi, int ki, int ind, int m, float b) {
            this.x = xi;
            this.y = 9999.0f;
            this.key_y_value = ki;
            this.index = ind;
            this.measure = m;
            this.beat = b;
            this.panel = p;
        }

        public void setPos() {
            float panel_time = (float)this.panel.measure + this.panel.beat;
            float this_time = (float)this.measure + this.beat;
            this.y = this_time * MusicGame.this.NOTE_SPEED - MusicGame.this.NOTE_SPEED * panel_time + (float)this.key_y_value + (float)MusicGame.this.VISUAL_AUDIO_BUFFER;
        }

        public int getPoints() {
            int dist = (int)(this.y - (float)this.key_y_value);
            int points = dist < -20 ? -1 : (dist < 0 ? 2 : (dist < 20 ? 3 : (dist < 40 ? 2 : (dist < 60 ? 1 : (dist < 80 ? -1 : 0)))));
            return points;
        }

        public boolean isInBounds() {
            return this.y < (float)MusicGame.this.height || this.y > 0.0f;
        }

        public void hide() {
            this.visible = false;
        }

        public void draw() {
            this.setPos();
            if (this.y < (float)(this.key_y_value - 50)) {
                this.hide();
            }
            if (this.isInBounds() && this.visible) {
                MusicGame.this.image(MusicGame.this.globalData.images.get("arrow_" + this.index), this.x, this.y);
            }
        }
    }

    public class RhythmKey {
        int x;
        int y;
        int w;
        int h;
        int col;
        int press_col;
        boolean isPressed;

        public RhythmKey(int xi, int yi, int wi, int hi, int c, int pc) {
            this.x = xi;
            this.y = yi;
            this.w = wi;
            this.h = hi;
            this.col = c;
            this.press_col = pc;
        }

        public void setPressed(boolean p) {
            this.isPressed = p;
        }

        public void draw() {
            int c = this.col;
            if (this.isPressed) {
                c = this.press_col;
            }
            MusicGame.this.fill(c);
            MusicGame.this.rect(this.x, this.y, this.w, this.h);
        }
    }

    public class RhythmMap {
        String instrument;
        int measure;
        ArrayList<MapNote> notes;

        public RhythmMap(String i, int m) {
            this.instrument = i;
            this.measure = m;
            this.notes = new ArrayList();
        }

        public void addNote(int d, int m, float b) {
            this.notes.add(new MapNote(d, m, b));
        }
    }

    public class RhythmPanel {
        int x_mod;
        int y_mod;
        int measure = -4;
        float beat = 0.0f;
        boolean counting = false;
        final int KEY_SIZE = 50;
        final int SPACING = 10;
        RhythmKey[] keys;
        ArrayList<RhythmArrow> arrows;
        RhythmArrow[] nextArrows;
        SongMaps song;
        RhythmMap[] curMaps;
        MapUnit bass_unit;
        MapUnit perc_unit;
        boolean show;
        boolean flag0;

        public RhythmPanel(int xi, int yi) {
            this.song = new SongMaps1();
            this.show = false;
            this.flag0 = false;
            this.x_mod = xi;
            this.y_mod = yi;
            this.keys = new RhythmKey[]{new RhythmKey(0 + this.x_mod, 0 + this.y_mod, 50, 50, MusicGame.this.color(0, 255, 0), MusicGame.this.color(0, 127, 0)), new RhythmKey(60 + this.x_mod, 0 + this.y_mod, 50, 50, MusicGame.this.color(255, 0, 0), MusicGame.this.color(127, 0, 0)), new RhythmKey(120 + this.x_mod, 0 + this.y_mod, 50, 50, MusicGame.this.color(255, 255, 0), MusicGame.this.color(127, 127, 0)), new RhythmKey(180 + this.x_mod, 0 + this.y_mod, 50, 50, MusicGame.this.color(0, 0, 255), MusicGame.this.color(0, 0, 127))};
            this.nextArrows = new RhythmArrow[4];
        }

        public void draw() {
            this.soundProcess();
            if (((GameScene)MusicGame.this.gameScene).phase == "rhythm" || this.counting) {
                RhythmKey[] rhythmKeyArray = this.keys;
                int n = this.keys.length;
                int n2 = 0;
                while (n2 < n) {
                    RhythmKey k = rhythmKeyArray[n2];
                    k.draw();
                    ++n2;
                }
                for (RhythmArrow a : this.arrows) {
                    a.draw();
                }
            }
            if (this.counting) {
                this.gameTimerProcess();
            }
        }

        public void initializeArrows() {
            this.counting = true;
            this.measure = -4;
            this.beat = 0.0f;
            this.curMaps = new RhythmMap[4];
            this.curMaps[0] = this.song.b[0];
            this.curMaps[1] = this.song.p[0];
            this.curMaps[2] = this.song.p[3];
            this.curMaps[3] = this.song.b[4];
            this.arrows = new ArrayList();
            if (this.curMaps != null) {
                RhythmMap[] rhythmMapArray = this.curMaps;
                int n = this.curMaps.length;
                int n2 = 0;
                while (n2 < n) {
                    RhythmMap r = rhythmMapArray[n2];
                    for (MapNote n3 : r.notes) {
                        this.arrows.add(new RhythmArrow(this, this.keys[n3.dir].x, this.keys[n3.dir].y, n3.dir, r.measure + n3.measure, n3.beat));
                    }
                    ++n2;
                }
                this.updateAllArrows();
            }
        }

        public void updateAllArrows() {
            this.updateNextArrow(0);
            this.updateNextArrow(1);
            this.updateNextArrow(2);
            this.updateNextArrow(3);
        }

        public void updateNextArrow(int index) {
            RhythmArrow cur = null;
            for (RhythmArrow a : this.arrows) {
                if (a.index != index || cur != null && a.getPoints() <= cur.getPoints()) continue;
                cur = a;
            }
            this.nextArrows[index] = cur;
        }

        public void keyPress(int index) {
            ((GameScene)MusicGame.this.gameScene).rhythmPanel.keys[index].setPressed(true);
            if (this.nextArrows[index] != null && this.nextArrows[index].getPoints() != 0) {
                this.nextArrows[index].hide();
                this.getHit();
                this.arrows.remove(this.nextArrows[index]);
                this.updateNextArrow(index);
            }
        }

        public void soundProcess() {
            if (this.measure >= 0 && !MusicGame.this.AP_percussion.isPlaying()) {
                MusicGame.this.AP_percussion.play();
                MusicGame.this.AP_bass.play();
            }
        }

        public void gameTimerProcess() {
            this.beat += 1.0f * ((float)this.song.bpm / (3600.0f * (float)this.song.beats_in_measure));
            if (this.beat >= 1.0f) {
                this.beat = 0.0f;
                ++this.measure;
            }
            if (this.measure >= 16 && this.measure < 32 && ((GameScene)MusicGame.this.gameScene).phase == "rhythm") {
                ((GameScene)MusicGame.this.gameScene).swapPhase();
            } else if (this.measure >= 32 && this.measure < 48 && ((GameScene)MusicGame.this.gameScene).phase == "strategy") {
                ((GameScene)MusicGame.this.gameScene).swapPhase();
            } else if (this.measure >= 48 && ((GameScene)MusicGame.this.gameScene).phase == "rhythm") {
                ((GameScene)MusicGame.this.gameScene).swapPhase();
                MusicGame.this.AP_percussion.rewind();
                MusicGame.this.AP_bass.rewind();
                MusicGame.this.AP_percussion.pause();
                MusicGame.this.AP_bass.pause();
                this.counting = false;
            }
            MusicGame.println((float)((float)this.measure + this.beat));
        }

        public void getHit() {
            if (this.measure >= 0 && this.measure < 8 || 40 <= this.measure && this.measure < 48) {
                if (this.bass_unit.target != null) {
                    this.bass_unit.data.attackUnit(this.bass_unit.target.data, this.bass_unit.data.getEquipped());
                    ((GameScene)MusicGame.this.gameScene).dataPanel.updateData(this.bass_unit.target.data);
                } else {
                    this.bass_unit.data.changeStamina(1);
                    ((GameScene)MusicGame.this.gameScene).dataPanel.updateData(this.bass_unit.data);
                }
            }
            if (8 <= this.measure && this.measure < 16 || 32 <= this.measure && this.measure < 40) {
                if (this.perc_unit.target != null) {
                    this.perc_unit.data.attackUnit(this.perc_unit.target.data, this.perc_unit.data.getEquipped());
                    ((GameScene)MusicGame.this.gameScene).dataPanel.updateData(this.perc_unit.target.data);
                } else {
                    this.perc_unit.data.changeStamina(1);
                    ((GameScene)MusicGame.this.gameScene).dataPanel.updateData(this.perc_unit.data);
                }
            }
        }
    }

    public abstract class Scene {
        public void draw() {
        }
    }

    public class SettingsMenu
    extends Scene {
        TextButton[] resolutions;
        TextButton back;

        public SettingsMenu() {
            this.resolutions = new TextButton[]{new TextButton(50, 100, 200, 50, "640 x 360", 32), new TextButton(50, 170, 200, 50, "1280 x 720", 32), new TextButton(50, 240, 200, 50, "1360 x 768", 32), new TextButton(50, 310, 200, 50, "1600 x 900", 32), new TextButton(50, 380, 200, 50, "1920 x 1080", 32)};
            this.back = new TextButton(10, 490, 160, 40, "Back", 24);
        }

        @Override
        public void draw() {
            MusicGame.this.textAlign(3);
            MusicGame.this.textSize(48.0f);
            MusicGame.this.text("Resolution", 150.0f, 75.0f);
            TextButton[] textButtonArray = this.resolutions;
            int n = this.resolutions.length;
            int n2 = 0;
            while (n2 < n) {
                TextButton i = textButtonArray[n2];
                i.draw();
                ++n2;
            }
            this.back.draw();
            if (this.resolutions[0].isJustPressed()) {
                MusicGame.this.setResolution(640);
            }
            if (this.resolutions[1].isJustPressed()) {
                MusicGame.this.setResolution(1280);
            }
            if (this.resolutions[2].isJustPressed()) {
                MusicGame.this.setResolution(1360);
            }
            if (this.resolutions[3].isJustPressed()) {
                MusicGame.this.setResolution(1600);
            }
            if (this.resolutions[4].isJustPressed()) {
                MusicGame.this.setResolution(1920);
            }
            if (this.back.isJustPressed()) {
                MusicGame.this.current = MusicGame.this.main;
            }
        }
    }

    public class SongMaps {
        int bpm;
        int beats_in_measure;
        RhythmMap[] g;
        RhythmMap[] b;
        RhythmMap[] k;
        RhythmMap[] p;
        RhythmMap[] v;
    }

    public class SongMaps1
    extends SongMaps {
        public SongMaps1() {
            this.bpm = 134;
            this.beats_in_measure = 4;
            this.p = new RhythmMap[5];
            this.p[0] = new RhythmMap("percussion", 8);
            int i = 0;
            while (i < 8) {
                this.p[0].addNote(1, i, 0.0f);
                this.p[0].addNote(1, i, 0.5f);
                this.p[0].addNote(2, i, 0.5f);
                ++i;
            }
            this.p[1] = new RhythmMap("percussion", 16);
            i = 8;
            while (i < 16) {
                this.p[1].addNote(1, i, 0.0f);
                this.p[1].addNote(1, i, 0.5f);
                this.p[1].addNote(2, i, 0.5f);
                ++i;
            }
            this.p[2] = new RhythmMap("percussion", 24);
            i = 0;
            while (i < 8) {
                this.p[2].addNote(1, i, 0.0f);
                this.p[2].addNote(1, i, 0.5f);
                ++i;
            }
            this.p[2].addNote(2, 7, 0.625f);
            this.p[2].addNote(2, 7, 0.75f);
            this.p[3] = new RhythmMap("percussion", 32);
            i = 0;
            while (i < 8) {
                this.p[3].addNote(2, i, 0.25f);
                this.p[3].addNote(2, i, 0.375f);
                this.p[3].addNote(2, i, 0.75f);
                if (i % 4 == 0 && i != 0) {
                    this.p[3].addNote(0, i, 0.25f);
                } else if (i < 8 || i > 11) {
                    this.p[3].addNote(3, i, 0.0f);
                    this.p[3].addNote(3, i, 0.125f);
                    this.p[3].addNote(3, i, 0.25f);
                }
                this.p[3].addNote(3, i, 0.375f);
                this.p[3].addNote(3, i, 0.5f);
                this.p[3].addNote(3, i, 0.625f);
                this.p[3].addNote(3, i, 0.75f);
                this.p[3].addNote(3, i, 0.875f);
                ++i;
            }
            this.p[4] = new RhythmMap("percussion", 32);
            i = 8;
            while (i < 16) {
                this.p[4].addNote(2, i, 0.25f);
                this.p[4].addNote(2, i, 0.375f);
                this.p[4].addNote(2, i, 0.75f);
                if (i % 4 == 0 && i != 0) {
                    this.p[4].addNote(0, i, 0.25f);
                } else if (i < 8 || i > 11) {
                    this.p[4].addNote(3, i, 0.0f);
                    this.p[4].addNote(3, i, 0.125f);
                    this.p[4].addNote(3, i, 0.25f);
                }
                this.p[4].addNote(3, i, 0.375f);
                this.p[4].addNote(3, i, 0.5f);
                this.p[4].addNote(3, i, 0.625f);
                this.p[4].addNote(3, i, 0.75f);
                this.p[4].addNote(3, i, 0.875f);
                ++i;
            }
            this.b = new RhythmMap[5];
            this.b[0] = new RhythmMap("guitar", 0);
            this.b[0].addNote(2, 0, 0.0f);
            this.b[0].addNote(2, 1, 0.0f);
            this.b[0].addNote(2, 1, 0.375f);
            this.b[0].addNote(2, 1, 0.625f);
            this.b[0].addNote(1, 1, 0.875f);
            this.b[0].addNote(2, 4, 0.0f);
            this.b[0].addNote(2, 5, 0.0f);
            this.b[0].addNote(2, 5, 0.375f);
            this.b[0].addNote(2, 5, 0.625f);
            this.b[0].addNote(1, 5, 0.875f);
            this.b[0].addNote(0, 7, 0.625f);
            this.b[0].addNote(0, 7, 0.75f);
            this.b[1] = new RhythmMap("guitar", 8);
            this.b[1].addNote(2, 0, 0.0f);
            this.b[1].addNote(2, 1, 0.0f);
            this.b[1].addNote(2, 1, 0.375f);
            this.b[1].addNote(2, 1, 0.625f);
            this.b[1].addNote(1, 1, 0.875f);
            this.b[1].addNote(2, 4, 0.0f);
            this.b[1].addNote(2, 5, 0.0f);
            this.b[1].addNote(2, 5, 0.375f);
            this.b[1].addNote(2, 5, 0.625f);
            this.b[1].addNote(1, 5, 0.875f);
            this.b[1].addNote(0, 7, 0.625f);
            this.b[1].addNote(0, 7, 0.75f);
            this.b[1].addNote(3, 8, 0.0f);
            this.b[1].addNote(3, 9, 0.0f);
            this.b[1].addNote(2, 9, 0.25f);
            this.b[1].addNote(1, 9, 0.375f);
            this.b[1].addNote(2, 9, 0.625f);
            this.b[1].addNote(1, 9, 0.875f);
            this.b[1].addNote(0, 11, 0.0f);
            this.b[1].addNote(0, 11, 0.375f);
            this.b[1].addNote(1, 11, 0.625f);
            this.b[1].addNote(2, 11, 0.875f);
            this.b[1].addNote(2, 13, 0.0f);
            this.b[1].addNote(2, 13, 0.375f);
            this.b[1].addNote(3, 13, 0.625f);
            this.b[1].addNote(1, 13, 0.875f);
            this.b[2] = new RhythmMap("guitar", 24);
            this.b[2].addNote(3, 0, 0.0f);
            this.b[2].addNote(3, 1, 0.0f);
            this.b[2].addNote(3, 1, 0.375f);
            this.b[2].addNote(3, 1, 0.625f);
            this.b[2].addNote(1, 1, 0.875f);
            this.b[2].addNote(3, 4, 0.0f);
            this.b[2].addNote(3, 5, 0.0f);
            this.b[2].addNote(3, 5, 0.375f);
            this.b[2].addNote(3, 5, 0.625f);
            this.b[2].addNote(1, 5, 0.875f);
            this.b[2].addNote(0, 7, 0.625f);
            this.b[2].addNote(0, 7, 0.75f);
            this.b[3] = new RhythmMap("guitar", 32);
            this.b[3].addNote(2, 0, 0.0f);
            this.b[3].addNote(1, 0, 0.25f);
            this.b[3].addNote(2, 0, 0.375f);
            this.b[3].addNote(1, 0, 0.75f);
            this.b[3].addNote(2, 1, 0.0f);
            this.b[3].addNote(1, 1, 0.125f);
            this.b[3].addNote(2, 1, 0.375f);
            this.b[3].addNote(1, 1, 0.75f);
            this.b[3].addNote(2, 2, 0.0f);
            this.b[3].addNote(1, 2, 0.125f);
            this.b[3].addNote(2, 2, 0.375f);
            this.b[3].addNote(1, 2, 0.625f);
            this.b[3].addNote(2, 3, 0.0f);
            this.b[3].addNote(1, 3, 0.125f);
            this.b[3].addNote(2, 3, 0.375f);
            this.b[3].addNote(3, 3, 0.625f);
            this.b[3].addNote(1, 4, 0.25f);
            this.b[3].addNote(1, 4, 0.5f);
            this.b[3].addNote(0, 4, 0.75f);
            this.b[3].addNote(1, 5, 0.0f);
            this.b[3].addNote(0, 5, 0.125f);
            this.b[3].addNote(1, 5, 0.375f);
            this.b[3].addNote(1, 5, 0.75f);
            this.b[3].addNote(0, 5, 0.825f);
            this.b[3].addNote(1, 6, 0.0f);
            this.b[3].addNote(0, 6, 0.125f);
            this.b[3].addNote(1, 6, 0.375f);
            this.b[3].addNote(0, 6, 0.625f);
            this.b[3].addNote(1, 7, 0.0f);
            this.b[3].addNote(0, 7, 0.125f);
            this.b[3].addNote(1, 7, 0.375f);
            this.b[3].addNote(2, 7, 0.625f);
            this.b[4] = new RhythmMap("guitar", 32);
            this.b[4].addNote(2, 8, 0.0f);
            this.b[4].addNote(1, 8, 0.25f);
            this.b[4].addNote(2, 8, 0.375f);
            this.b[4].addNote(1, 8, 0.75f);
            this.b[4].addNote(2, 9, 0.0f);
            this.b[4].addNote(1, 9, 0.125f);
            this.b[4].addNote(2, 9, 0.375f);
            this.b[4].addNote(1, 9, 0.75f);
            this.b[4].addNote(2, 10, 0.0f);
            this.b[4].addNote(1, 10, 0.125f);
            this.b[4].addNote(2, 10, 0.375f);
            this.b[4].addNote(1, 10, 0.625f);
            this.b[4].addNote(2, 11, 0.0f);
            this.b[4].addNote(1, 11, 0.125f);
            this.b[4].addNote(2, 11, 0.375f);
            this.b[4].addNote(3, 11, 0.625f);
            this.b[4].addNote(1, 12, 0.25f);
            this.b[4].addNote(1, 12, 0.5f);
            this.b[4].addNote(0, 12, 0.75f);
            this.b[4].addNote(1, 13, 0.0f);
            this.b[4].addNote(0, 13, 0.125f);
            this.b[4].addNote(1, 13, 0.375f);
            this.b[4].addNote(1, 13, 0.75f);
            this.b[4].addNote(0, 13, 0.825f);
            this.b[4].addNote(1, 14, 0.0f);
            this.b[4].addNote(0, 14, 0.125f);
            this.b[4].addNote(1, 14, 0.375f);
            this.b[4].addNote(0, 14, 0.625f);
            this.b[4].addNote(1, 15, 0.0f);
            this.b[4].addNote(0, 15, 0.125f);
            this.b[4].addNote(1, 15, 0.375f);
            this.b[4].addNote(2, 15, 0.625f);
        }
    }

    public class TextButton
    extends Button {
        String text;
        int text_size;

        public TextButton(int xi, int yi, int wi, int hi, String t, int ts) {
            super(xi, yi, wi, hi);
            this.text = t;
            this.text_size = ts;
        }

        public TextButton(int xi, int yi, int wi, int hi, int c, int hc, int pc, String t, int ts) {
            super(xi, yi, wi, hi, c, hc, pc);
            this.text = t;
            this.text_size = ts;
        }

        @Override
        public void draw() {
            super.draw();
            MusicGame.this.fill(0);
            MusicGame.this.textSize(this.text_size);
            MusicGame.this.textAlign(3);
            MusicGame.this.text(this.text, this.x + this.w / 2, this.y + (this.h + this.text_size) / 2);
        }
    }

    public class UnitData {
        public String unit_name;
        public int max_stamina;
        public int cur_stamina;
        public int speed;
        public int melody;
        public int rhythm;
        public int focus;
        public int tempo;
        public ItemData[] inventory = new ItemData[5];
        public String instrument_type;

        public UnitData(String nam, int sta, int spd, int mel, int rhy, int foc, int tem, String typ) {
            this.unit_name = nam;
            this.max_stamina = sta;
            this.cur_stamina = sta / 2;
            this.speed = spd;
            this.melody = mel;
            this.rhythm = rhy;
            this.focus = foc;
            this.tempo = tem;
            this.instrument_type = typ;
        }

        public void attackUnit(UnitData other, InstrumentData weapon) {
            int damage = weapon.damage_mod;
            if (weapon.damage_type == "melody") {
                damage += this.melody;
                damage -= other.focus;
            } else if (weapon.damage_type == "rhythm") {
                damage += this.melody;
                damage -= other.focus;
            } else {
                MusicGame.println((String)"Oopsies! Problem in the attackUnit function!! Weapon damage type wasn't put as melody or rhythm, which shouldn't happen.");
            }
            if (damage < 0) {
                damage = 0;
            }
            other.changeStamina(damage * -1);
        }

        public void changeStamina(int s) {
            this.cur_stamina += s;
            if (this.cur_stamina > this.max_stamina) {
                this.cur_stamina = this.max_stamina;
            }
            if (this.cur_stamina <= 0) {
                this.cur_stamina = 0;
                this.killUnit();
            }
        }

        public void killUnit() {
        }

        public boolean isDead() {
            return this.cur_stamina <= 0;
        }

        public boolean giveItem(ItemData item) {
            int i = 0;
            while (i < this.inventory.length) {
                if (this.inventory[i] == null) {
                    this.inventory[i] = item;
                    return true;
                }
                ++i;
            }
            return false;
        }

        public InstrumentData getEquipped() {
            ItemData i;
            ItemData equipped = null;
            ItemData[] itemDataArray = this.inventory;
            if (this.inventory.length != 0 && (i = itemDataArray[0]) != null) {
                equipped = i;
            }
            return (InstrumentData)equipped;
        }

        public UnitData copyUnit() {
            UnitData unit = new UnitData(this.unit_name, this.max_stamina, this.speed, this.melody, this.rhythm, this.focus, this.tempo, this.instrument_type);
            return unit;
        }
    }
}

