public class Button {
  
  int x;
  int y;
  int w;
  int h;
  
  final int BUFFER = 1;
  
  color col;
  color hover_col;
  color press_col;
  
  boolean pressed = false;
  boolean last_frame_pressed=false;
  
  public Button(int xi, int yi, int wi, int hi) {
    x = xi;
    y = yi;
    w = wi;
    h = hi;
    
    col = color(255);
    hover_col = color(191);
    press_col = color(127);
  }
  
  public Button(int xi, int yi, int wi, int hi, color c, color hc, color pc) {
    x = xi;
    y = yi;
    w = wi;
    h = hi;
    
    col = c;
    hover_col = hc;
    press_col = pc;
  }
  
  public boolean isHovered() {
    boolean hover;
    if (mouseX() - BUFFER < x) hover = false;
    else if (mouseY() - BUFFER < y) hover = false;
    else if (mouseX() + BUFFER > x + w) hover = false;
    else if (mouseY() + BUFFER > y + h) hover = false;
    else hover = true;
    return hover;
  }
  
  public boolean isPressed() {
    return (mousePressed && isHovered());
  }
  
  public boolean isJustPressed() {
    //if (last_frame_pressed && !mousePressed && isHovered()) println(x);
    return (last_frame_pressed && !mousePressed && isHovered());
  }
  
  public void draw() {
    last_frame_pressed = pressed;
    pressed = isPressed();
    color c = col;
    if (isPressed()) c = press_col;
    else if (isHovered()) c = hover_col;
    fill(c);
    rect(x, y, w, h);
  }
  
  public void setColors(color c, color hc, color pc) {
    col = c;
    hover_col = hc;
    press_col = pc;
  }
  
  public void setWhite() {
    setColors(color(255), color(191), color(127));
  }
  
  public void setGray() {
    setColors(color(127), color(63), color(0));
  }
  
  public void setBlack() {
    setColors(color(0), color(63), color(127));
  }
  
  public void setBlue() {
    setColors(color(0, 0, 255), color(0, 0, 191), color(0, 0, 127));
  }
  
  public void setLightBlue() {
    setColors(color(127, 127, 255), color(127, 127, 191), color(127, 127, 127));
  }
  
  public void setRed() {
    setColors(color(255, 0, 0), color(191, 0, 0), color(127, 0, 0));
  }
  
  public void setLightRed() {
    setColors(color(255, 127, 127), color(191, 127, 127), color(127, 127, 127));
  }
  
}


public class TextButton extends Button {
  
  String text;
  int text_size;
  
  public TextButton(int xi, int yi, int wi, int hi, String t, int ts) {
    super (xi, yi, wi, hi);
    text = t;
    text_size = ts;
  }
  
  public TextButton(int xi, int yi, int wi, int hi, color c, color hc, color pc, String t, int ts) {
    super(xi, yi, wi, hi, c, hc, pc);
    text = t;
    text_size = ts;
  }
  
  public void draw() {
    super.draw();
    
    fill(0);
    textSize(text_size);
    textAlign(CENTER);
    text(text, (x+w/2), (y+((h+text_size)/2)));
  }
  
}


public class ImgButton extends Button {
  
  String img_path;
  PImage img;
  
  public ImgButton(int xi, int yi, int wi, int hi, String ip) {
    super (xi, yi, wi, hi);
    setImage(ip);
  }
  
  public ImgButton(int xi, int yi, int wi, int hi, color c, color hc, color pc, String ip) {
    super(xi, yi, wi, hi, c, hc, pc);
    setImage(ip);
  }
  
  public void setImage(String ip) {
    img_path = ip;
    if (ip != null) {
      img = globalData.images.get(ip);
    }
    else img = null;
  }
  
  public void draw() {
    super.draw();
    
    if (img != null) {
      image(img, x, y, w, h);
    }
  }
  
}
