//left portion of the game scene that shows some data for units, etc.
public class DataPanel {
  
  int x_mod;
  int y_mod;
  
  boolean show = false;
  
  String nam;
  String typ;
  String lvl;
  String max_stam; //max hp
  String cur_stam; //min hp
  String speed; //spaces can move per turn
  String melody; //melody damage
  String rhythm; //rhythm damage
  String focus; //melody defense
  String tempo; //rhythm defense
  String equipped;
  
  public DataPanel(int xi, int yi) {
    x_mod = xi;
    y_mod = yi;
  }
  
  public void updateData(UnitData data) {
    if (data != null) {
      show = true;
      nam = data.unit_name;
      typ = data.instrument_type;
      lvl = "1";
      max_stam = Integer.toString( data.max_stamina );
      cur_stam = Integer.toString( data.cur_stamina );
      speed = Integer.toString( data.speed );
      melody = Integer.toString( data.melody );
      rhythm = Integer.toString( data.rhythm );
      focus = Integer.toString( data.focus );
      tempo = Integer.toString( data.tempo );
      if (data.inventory[0] != null) equipped = data.inventory[0].item_name;
      else equipped = "";
    }
    else show = false;
  }
  
  public void draw() {
    
    if (show) {
    
      fill(color(255));
      rect(0 + x_mod, 0 + y_mod, 128, 128); //image placeholder
      
      textAlign(LEFT);
      fill(color(0));
      textSize(32);
      Label(nam, 140, 30);
      textSize(24);
      Label(typ, 140, 60);
      Label("Lv " + lvl, 140, 90);
      Label("STAMINA: " + cur_stam + "/" + max_stam, 0, 160);
      Label("MOVEMENT: " + speed, 0, 190);
      
      Label("MELODY: " + melody, 0, 250);
      Label("RHYTHM: " + rhythm, 0, 280);
      Label("FOCUS: " + focus, 140, 250);
      Label("TEMPO: " + tempo, 140, 280);
      
      Label("Equipped: " + equipped, 0, 340);
      
    }
    
  }
  
  void Label(String t, float xi, float yi) {
    text(t, xi + x_mod, yi + y_mod);
  }
  
}
