public class GameScene extends Scene {
  
  //UI objects
  MapUI mapUI = new MapUI(292, 20);
  DataPanel dataPanel = new DataPanel(20, 20);
  RhythmPanel rhythmPanel = new RhythmPanel(698, 120);
  Button back = new TextButton(20, 490, 100, 40, "Menu", 24);
  
  //game data
  String turn = "player";
  String phase = "strategy";
  int turn_count = 0;
  MapUnit hoveredTile = null;
  MapUnit selectedTile = null; //The most recently selected tile
  MapUnit lastSelectedTile = null; //The previosuly selected tile
  MapUnit attackingUnit = null;
  int[] selectedCoords = null; //The coordinates of the most recently selected tile
  int[] lastSelectedCoords = null; //The coordinates of the previosuly selected tile
  MapUnit tileForDataPanel = null;
  boolean[][] movRange = null;  //range of movement when a unit is selected.
  boolean[][] atkRange = null;  //range of attack when a unit is selected for attacking.
  MapUnit currentRhythmUnit;
  
  MapUnit justPressed;
  int[] justCoords;
  
  public GameScene() {

  }
  
  public void draw() {
    mapUI.draw();
    
    setHovered();
    
    if (attackingUnit == null) {
      setSelected();
    }
    else {
      setAttackSelected();
    }
    
    setDataPannel();
    
    dataPanel.draw();
    
    drawBattleTempo();
    
    rhythmPanel.draw();
    
    back.draw();
    if (back.isJustPressed()) {
      current = main;
      AP_percussion.pause();
      AP_bass.pause();
    }
    
  }
  
  void drawBattleTempo() {
    fill(color(0));
    rect(698, 20, 242, 30);
    
    if (phase == "rhythm") {
      float percent = ((rhythmPanel.measure%MEASURES_PER_PHASE) + rhythmPanel.beat) / MEASURES_PER_PHASE;
      int buffer = 1;
      if (percent > 0) {
        fill(color(0, 255*(1-percent), 255*percent));
        rect(698 + buffer, 20 + buffer, (242 - buffer)*percent, 30 - 2*buffer);
      }
    }
    else {
      float percent = ((rhythmPanel.measure%(MEASURES_PER_PHASE*2)) + rhythmPanel.beat) / (MEASURES_PER_PHASE*2);
      int buffer = 1;
      if (percent > 0) {
        fill(color(0, 255*(1-percent), 255*percent));
        rect(698 + buffer, 20 + buffer, (242 - buffer)*percent, 30 - 2*buffer);
      }
    }
    
    textAlign(LEFT);
    textSize(20);
    fill(color(0));
    
    if (phase == "strategy") text(phase + " phase", 698, 70);
    else text("rhythm phase", 698, 70);
    
    if (phase == "strategy") text("Next: rhythm phase", 698, 100);
    
    
  }
  
  void setHovered() {
    hoveredTile = (MapUnit) mapUI.getHovered();
  }
  
  void setSelected() {
    justPressed = (MapUnit) mapUI.getJustPressed();
    justCoords = mapUI.getJustPressedCoords();
    
    if (justPressed != null && justPressed.hasMoved == true) {
      justPressed = null;
      justCoords = null;
    }
    
    if (justPressed != null) {
      mapUI.updateTiles();
      lastSelectedTile = selectedTile;
      selectedTile = justPressed;
    }
    
    if (justCoords != null) {
      lastSelectedCoords = selectedCoords;
      selectedCoords = justCoords;
    }
    
    if (justPressed != null && selectedTile == lastSelectedTile) {
        //lastSelectedTile = selectedTile;
        deselect();
      }
    
    if (hoveredTile == null && mousePressed) {
      if (selectedTile != null) lastSelectedTile = selectedTile;
      deselect();
    }
    
    if (justCoords != null) {
      checkMovement();
    }
  }
  
  void setAttackSelected() {
    if ((MapUnit) mapUI.getJustPressed() != null) {
      attackingUnit.target = (MapUnit) mapUI.getJustPressed();
      attackingUnit.setTargeted(true);
      setRhythmPlayer(attackingUnit);
      if (attackingUnit == attackingUnit.target) attackingUnit.target = null;
      attackingUnit = null;
      mapUI.updateTiles();
      if (rhythmPanel.counting == false)  checkEndOfTurn(1);
    }
  }
  
  void setDataPannel() {
    
    if (selectedTile != null) dataPanel.updateData(((MapUnit)selectedTile).data);
    else if (hoveredTile != null) dataPanel.updateData(((MapUnit)hoveredTile).data);
    
  }
  
  void checkMovement() {
    
    if (selectedTile != null) {
      movRange = mapUI.showMovement(mapUI.mapData.getMovRange(selectedTile.x, selectedTile.y, selectedTile.obj_type), ((MapUnit)selectedTile).data.speed);
    }
    else {
      if (lastSelectedTile != null && selectedCoords != null) {
        if (movRange[selectedCoords[0]][selectedCoords[1]]) {
          mapUI.moveTile(selectedCoords[0], selectedCoords[1], lastSelectedTile);
          lastSelectedTile.setMoved(true);
          attackingUnit = lastSelectedTile;
          lastSelectedTile = null;
          mapUI.updateTiles();
          checkAttackRange();
        }
      }
    }
  }
  
  void checkAttackRange() {
    atkRange = mapUI.showAttackRange(mapUI.mapData.getAtkRange(attackingUnit.x, attackingUnit.y, attackingUnit.obj_type), attackingUnit.data.getEquipped().range);
  }
  
  void deselect() {
    selectedTile = null;
    selectedCoords = null;
    mapUI.updateTiles();
  }
  
  public String getTurn() {
    return turn;
  }
  
  public String getPhase() {
    return phase;
  }
  
  //index is 1 for playerturn, 2 for enemyturn
  void checkEndOfTurn(int index) {
    boolean end = true;
    for (int i = 0; i < mapUI.mapData.wid; i++) {
      for (int j = 0; j < mapUI.mapData.hei; j++) {
        MapUnit unit = (MapUnit)mapUI.mapData.objects[i][j];
        if (unit != null) {
          if ((!unit.hasMoved || !unit.hasTargeted) && unit.obj_type == index) {
            end = false;
          }
        }
      }
    }
    if (end) endTurn();
  }
  
  public void endTurn() {
    swapPhase();
    if (rhythmPanel.counting == false) {
      rhythmPanel.initializeArrows();
      
    }
    turn_count++;
  }
  
  public void swapPhase() {
    if (phase == "strategy") {
      phase = "rhythm";
    }
    else {
      phase = "strategy";
      startStrategy();
    }
  }
  
  //garcoded when it should not be but whatever
  public void startStrategy() {
    rhythmPanel.perc_unit.startTurn();
    rhythmPanel.bass_unit.startTurn();
    mapUI.updateTiles();
  }
  
  public void setInstrument(String ins) {
    if (ins == "percussion") {
      //dataPanel.updateData();
    }
    
  }
  
  //hardcoded when it should not be but whatever
  void setRhythmPlayer(MapUnit unit) {
    if (unit.data.instrument_type == "Percussion") {
      rhythmPanel.perc_unit = unit;
    }
    else if (unit.data.instrument_type == "Guitar") {
      rhythmPanel.bass_unit = unit;
    }
  }
  
}
