public class GlobalData {
  
  public UnitData vocalist = new UnitData("Wyen", 42, 6, 7, 2, 4, 1, "Vocals");
  public UnitData guitarist = new UnitData("Pandora", 48, 5, 6, 4, 3, 3, "Guitar");
  public UnitData bassist = new UnitData("Benni", 60, 5, 3, 5, 2, 5, "Guitar");
  public UnitData drummer = new UnitData("Casey", 54, 4, 1, 7, 1, 4, "Percussion");
  public UnitData keyboardist = new UnitData("Alec", 45, 5, 5, 4, 2, 1, "Keyboard");
  
  public UnitData enemyDrummer = new UnitData("Drummer", 50, 5, 1, 1, 1, 1, "Percussion");
  public UnitData trainingDummy = new UnitData("Training Dummy", 100, 1, 1, 1, 1, 1, "Vocals");
  
  public ItemData microphone = new Microphone("Microphone", 1);
  public ItemData acoustic_guitar = new Guitar("Acoustic Guitar", 1);
  public ItemData electric_guitar = new Guitar("Electric Guitar", 1);
  public ItemData bass_guitar = new BassGuitar("Bass Guitar", 1);
  public ItemData mobile_drum_kit = new Drum("Mobile Drum Kit", "mid", 1);
  public ItemData marching_snare = new Drum("Marching Snare", "mid", 1);
  public ItemData marching_bass = new Drum("Marching Bass", "low", 1);
  public ItemData synthesizer = new Keyboard("Synthesizer", 1);
  public ItemData keytar = new Keyboard("Keytar", 1);
  
  Dictionary<String, PImage> images= new Hashtable<>();
  
  public GlobalData() {
    
    images.put("unit", loadImage("unit.png"));
    images.put("arrow_0", loadImage("arrow_left.png"));
    images.put("arrow_1", loadImage("arrow_down.png"));
    images.put("arrow_2", loadImage("arrow_right.png"));
    images.put("arrow_3", loadImage("arrow_up.png"));
    
    vocalist.giveItem(microphone);
    guitarist.giveItem(electric_guitar);
    bassist.giveItem(bass_guitar);
    drummer.giveItem(mobile_drum_kit);
    keyboardist.giveItem(synthesizer);
    
  }
  
  public MapData Map1() {
    
    int[][] terrainMap = new int[][] {
      {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
      {1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1},
      {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1},
      {1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1},
      {0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1},
      {0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
      {0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0},
      {0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0},
      {0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
      {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    };
    
    MapData map = new MapData(terrainMap);
    
    //map.initTiles();
    
    MapObj playerA = new MapUnit(1, vocalist);
    MapObj playerB = new MapUnit(1, guitarist);
    MapObj playerC = new MapUnit(1, bassist);
    MapObj playerD = new MapUnit(1, drummer);
    MapObj playerE = new MapUnit(1, keyboardist);
    
    MapObj enemyA = new MapUnit(2, enemyDrummer);
    
    //map.setTile(5, 19, playerA);
    //map.setTile(4, 18, playerB);
    map.setTile(2, 18, playerC);
    map.setTile(3, 19, playerD);
    //map.setTile(1, 19, playerE);
    
    //map.setTile(10, 15, enemyA);
    map.setTile(6, 16, new MapUnit(2, trainingDummy.copyUnit()));
    map.setTile(8, 14, new MapUnit(2, trainingDummy.copyUnit()));
    map.setTile(10, 15, new MapUnit(2, trainingDummy.copyUnit()));
    map.setTile(1, 11, new MapUnit(2, trainingDummy.copyUnit()));
    map.setTile(2, 12, new MapUnit(2, trainingDummy.copyUnit()));
    
    return map;
  }
  
}

public class ItemData {
  
  public String item_name;
  
  public ItemData(String nam) {
    item_name = nam;
  }
  
}

public class InstrumentData extends ItemData {
  
  public String instrument_type;
  public String damage_type;
  public String pitch;
  public int damage_mod;
  public int range;
  
  public InstrumentData(String nam, String instr, String dmg, String pit, int mod, int ran) {
    super(nam);
    instrument_type = instr;
    damage_type = dmg;
    pitch = pit;
    damage_mod = mod;
    range = ran;
  }
  
}

public class Microphone extends InstrumentData {
  public Microphone(String nam, int mod) {
    super(nam, "microphone", "melody", "high", mod, 1);
  }
}

public class Guitar extends InstrumentData {
  public Guitar(String nam, int mod) {
    super(nam, "guitar", "melody", "mid", mod, 5);
  }
}

public class BassGuitar extends InstrumentData {
  public BassGuitar(String nam, int mod) {
    super(nam, "guitar", "rhythm", "low", mod, 3);
  }
}

public class Drum extends InstrumentData {
  public Drum(String nam, String pit, int mod) {
    super(nam, "percussion", "rhythm", pit, mod, 4);
  }
}

public class Keyboard extends InstrumentData {
  public Keyboard(String nam, int mod) {
    super(nam, "keyboard", "melody", "high", mod, 1);
  }
}
