public class MapData {
  
  int wid;
  int hei;
  
  public MapObj[][] objects;
  
  //0-> plains
  //1-> walls
  int[][] terrain;
  
  public MapData(int[][] ter) {
    wid = ter[0].length;
    hei = ter.length;
    
    objects = new MapObj[wid][hei];
    terrain = ter;
  }
  
  public MapObj getTile(int x, int y) {
    return objects[x][y];
  }
  
  public void setTile(int x, int y, MapObj obj) {
    if (obj != null) obj.setCoords(x, y);
    objects[x][y] = obj;
  }
  
  public void moveTile(int x, int y, MapObj obj) {
    int[] oldCoords = obj.getCoords();
    setTile(x, y, obj);
    setTile(oldCoords[0], oldCoords[1], null);
  }
  
  public void initTiles() {
    for (int i = 0; i < wid; i++) {
      for (int j = 0; j < hei; j++) {
        setTile(i, j, new MapObj(i, j, -1) );
      }
    }
  }
  
  public int[][] getMovRange(int x_pos, int y_pos, int typ) {
    int[][] tiles = new int[wid][hei];
    
    for (int i = 0; i < wid; i++) {
      for (int j = 0; j < hei; j++) {
        tiles[i][j] = 999;
      }
    }
    
    tiles = checkSpace(tiles, 0, x_pos, y_pos, typ, false);
    
    tiles = blockOffFullTiles(tiles);
    
    return tiles;
  }
  
  public int[][] getAtkRange(int x_pos, int y_pos, int typ) {
    int[][] tiles = new int[wid][hei];
    
    for (int i = 0; i < wid; i++) {
      for (int j = 0; j < hei; j++) {
        tiles[i][j] = 999;
      }
    }
    
    tiles = checkSpace(tiles, 0, x_pos, y_pos, typ, true);
    
    return tiles;
  }
  
  public int[][] checkSpace(int[][] tiles, int range, int x, int y, int typ, boolean noclip) {
    if (x >= 0 && x < wid && y >= 0 && y < hei) {
      
      if (canWalkThrough(x, y, typ) || noclip) {
        if (range < tiles[x][y]) {
          tiles[x][y] = range;
          checkSpace(tiles, range+1, x-1, y, typ, noclip);
          checkSpace(tiles, range+1, x, y-1, typ, noclip);
          checkSpace(tiles, range+1, x+1, y, typ, noclip);
          checkSpace(tiles, range+1, x, y+1, typ, noclip);
        }
      }
      else {
        tiles[x][y] = 999;
      }
      
    }
    
    return tiles;
  }
  
  public boolean canWalkThrough(int x, int y, int typ) {
    boolean can = true;
    
    if (terrain[y][x] == 1) can = false;
    
    switch (typ) {
      case 1:
        if (getTile(x, y) != null && getTile(x, y).obj_type == 2) can = false;
        break;
      case 2:
        if (getTile(x, y) != null && getTile(x, y).obj_type == 1) can = false;
        break;
    }
    
    
    
    return can;
  }
  
  public int[][] blockOffFullTiles(int[][] tiles) {
    for (int i = 0; i < wid; i++) {
      for (int j = 0; j < hei; j++) {
        if (objects[i][j] != null) {
          tiles[i][j] = 999;
        }
      }
    }
    
    return tiles;
  }
  
  
  
}
