public class MapObj {
  
  int x;
  int y;
  
  //-1-> empty, 0->terrain, 1-> player, 2-> enemy
  public int obj_type;
  
  public MapObj(int typ) {
    obj_type = typ;
  }
  
  public MapObj(int typ, int xi, int yi) {
    obj_type = typ;
    setCoords(xi, yi);
  }
  
  public void setCoords(int xi, int yi) {
    x = xi;
    y = yi;
  }
  
  public int[] getCoords() {
    return new int[] {x, y};
  }
  
}

public class MapUnit extends MapObj {
  
  public UnitData data;
  
  public boolean hasMoved = false;
  public boolean hasTargeted = false;
  public MapUnit target;
  
  public MapUnit(int typ, UnitData d) {
    super(typ);
    data = d;
  }
  
  public void setMoved(boolean mov) {
    hasMoved = mov;
  }
  
  public void setTargeted(boolean tar) {
    hasTargeted = tar;
  }
  
  public void startTurn() {
    hasMoved = false;
    hasTargeted = false;
  }
  
}
