public class MapUI {
  
  MapData mapData;
  
  ImgButton[][] tiles;
  
  int x_mod;
  int y_mod;
  
  int tile_wid = 25;
  int tile_hei = 25;
  
  public MapUI(int x, int y) {
    x_mod = x;
    y_mod = y;
    mapData = new GlobalData().Map1();
    
    tiles = new ImgButton[mapData.wid][mapData.hei];
    
    //initializes tiles and sets the terrain.
    initializeMap();
    showTerrain();
    updateUnitTiles();
  }
  
  public void moveTile(int x, int y, MapObj unit) {
    mapData.moveTile(x, y, unit);
  }
  
  public void updateUnitTiles() {
    
    for (int i = 0; i < mapData.wid; i++) {
      for (int j = 0; j < mapData.hei; j++) {
        
        MapUnit unit = (MapUnit) mapData.getTile(i, j);
        ImgButton tile = tiles[i][j];
        
        if (unit != null ) {
          
          //removes dead units
          if (unit.data.isDead()) {
            unit = null;
            mapData.setTile(i, j, null);
            tile.setImage(null);
          }
          else {
          
            switch (unit.obj_type) {
              case -1:
                tile.setImage(null);
                break;
              case 1:
                if (unit.hasMoved) {
                  tile.setGray();
                }
                else {
                  tile.setBlue();
                }
                tile.setImage("unit");
                break;
              case 2:
                tile.setRed();
                tile.setImage("unit");
                break;
            }
          }
          
        }
        
        else {
          tile.setImage(null);
        }
        
      }
    }
  }
  
  public void updateTiles() {
    showTerrain();
    updateUnitTiles();
  }
  
  public void initializeMap() {
    for (int i = 0; i < mapData.wid; i++) {
      for (int j = 0; j < mapData.hei; j++) {
        tiles[i][j] = new ImgButton(x_mod + tile_wid*i, y_mod + tile_hei*j, tile_wid, tile_hei, null);
      }
    }
  }
  
  //reset the colors of the map based on the terrain map.
  public void showTerrain() {
    for (int i = 0; i < mapData.wid; i++) {
      for (int j = 0; j < mapData.hei; j++) {
        tiles[i][j].setWhite();
        if (mapData.terrain[j][i] == 1) tiles[i][j].setBlack();
      }
    }
  }
  
  //modify the colors of the map to show movement based on a movement map.
  public boolean[][] showMovement(int[][] map, int spaces) {
    boolean[][] movTiles = new boolean[tiles.length][tiles[0].length];
    for (int i = 0; i < mapData.wid; i++) {
      for (int j = 0; j < mapData.hei; j++) {
        if (map[i][j] <= spaces) {
          tiles[i][j].setLightBlue();
          movTiles[i][j] = true;
        }
        else {
          movTiles[i][j] = false;
        }
      }
    }
    return movTiles;
  }
  
  //modify the colors of the map to show movement based on a movement map.
  public boolean[][] showAttackRange(int[][] map, int spaces) {
    boolean[][] movTiles = new boolean[tiles.length][tiles[0].length];
    for (int i = 0; i < mapData.wid; i++) {
      for (int j = 0; j < mapData.hei; j++) {
        if (map[i][j] <= spaces) {
          tiles[i][j].setLightRed();
          movTiles[i][j] = true;
        }
        else {
          movTiles[i][j] = false;
        }
      }
    }
    return movTiles;
  }
  
  public void drawTiles() {
    for (ImgButton[] row : tiles) {
      for (ImgButton tile : row) {
        tile.draw();
      }
    }
  }
  
  public MapObj getHovered() {
    for (int i = 0; i < mapData.wid; i++) {
      for (int j = 0; j < mapData.hei; j++) {
        if (tiles[i][j].isHovered()) {
          return mapData.getTile(i, j);
        }
      }
    }
    return null;
  }
  
  public MapObj getJustPressed() {
    for (int i = 0; i < mapData.wid; i++) {
      for (int j = 0; j < mapData.hei; j++) {
        if (tiles[i][j].isJustPressed()) {
          return mapData.getTile(i, j);
        }
      }
    }
    return null;
  }
  
  public int[] getJustPressedCoords() {
    for (int i = 0; i < mapData.wid; i++) {
      for (int j = 0; j < mapData.hei; j++) {
        if (tiles[i][j].isJustPressed()) {
          return new int[]{i, j};
        }
      }
    }
    return null;
  }
  
  void draw() {
    drawTiles();
    
  }
  
}
