import ddf.minim.*;
import ddf.minim.analysis.*;
import ddf.minim.effects.*;
import ddf.minim.signals.*;
import ddf.minim.spi.*;
import ddf.minim.ugens.*;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;

final int FRAME_RATE = 60;
final int REAL_WIDTH = 960;
final int REAL_HEIGHT = 540;
float NOTE_SPEED = 300;
int VISUAL_AUDIO_BUFFER = 2;
final float GAME_SPEED = 1; //does NOT affect music playback speed, only everything else in the game. used for dev reasons only.
final float MEASURES_PER_PHASE = 8;

int screen_resolution_x = 960;
int screen_resolution_y = 540;

//Music player
Minim minim;
AudioPlayer AP_percussion;
AudioPlayer AP_bass;

Scene main; 
Scene settingsMenu;
Scene gameScene;
Scene instructions;

Scene current;

GlobalData globalData; 

void setup() {
  //resolution of in-game space
  size(960, 540);
  
  //fullScreen();
  frameRate(FRAME_RATE);
  
  minim = new Minim(this);
  AP_percussion = minim.loadFile("song0\\percussion.mp3");
  AP_bass = minim.loadFile("song0\\bass.mp3");
  
  
  globalData = new GlobalData(); 
  
  main = new MainMenu();
  settingsMenu = new SettingsMenu();
  gameScene = new GameScene();
  instructions = new Instructions();
  current = main;
}

void draw() {
  //scales the drawings of everything after this
  //scale(((float) screen_resolution_x)/((float)REAL_WIDTH));
  
  background(color(204));
  
  current.draw();
  
  //black border to cut off extra space
  fill(color(0));
  rect(960, -100, 10000, 10000);
  rect(-10, 540, 10000, 10000);
}

void keyPressed() {
  
  switch (keyCode) {
    case LEFT:
    case 65:
    case 49:
      ((GameScene) gameScene).rhythmPanel.keyPress(0);
      break;
    case DOWN:
    case 83:
    case 50:
      ((GameScene) gameScene).rhythmPanel.keyPress(1);
      break;
    case RIGHT:
    case 68:
    case 51:
      ((GameScene) gameScene).rhythmPanel.keyPress(2);
      break;
    case UP:
    case 87:
    case 52:
      ((GameScene) gameScene).rhythmPanel.keyPress(3);
      break;
  }
  
}

void keyReleased() {
  
  switch (keyCode) {
    case LEFT:
    case 65:
    case 49:
      ((GameScene) gameScene).rhythmPanel.keys[0].setPressed(false);
      break;
    case DOWN:
    case 83:
    case 50:
      ((GameScene) gameScene).rhythmPanel.keys[1].setPressed(false);
      break;
    case RIGHT:
    case 68:
    case 51:
      ((GameScene) gameScene).rhythmPanel.keys[2].setPressed(false);
      break;
    case UP:
    case 87:
    case 52:
      ((GameScene) gameScene).rhythmPanel.keys[3].setPressed(false);
      break;
  }
  
}


public int mouseX() {
  return (int) (mouseX * (((float)REAL_WIDTH/(float) screen_resolution_x)));
}

public int mouseY() {
  return (int) (mouseY * (((float)REAL_HEIGHT/(float) screen_resolution_y)));
}

public void setResolution(int x) {
  screen_resolution_x = x;
  screen_resolution_y = (int)(x * (9./16.));
}
