public class RhythmKey {
  
  int x;
  int y;
  int w;
  int h;
  
  color col;
  color press_col;
  
  boolean isPressed;
  
  public RhythmKey(int xi, int yi, int wi, int hi, color c, color pc) {
    x = xi;
    y = yi;
    w = wi;
    h = hi;
    
    col = c;
    press_col = pc;
  }
  
  public void setPressed(boolean p) {
    isPressed = p;
  }
  
  public void draw() {
    color c = col;
    if (isPressed) c = press_col;
    fill(c);
    rect(x, y, w, h);
  }
  
}

public class RhythmArrow {
  
  int x;
  float y;
  int index;
  int key_y_value; //the y-value at which the arrow lines perfectly with its button
  boolean visible = true;
  
  RhythmPanel panel;
  int bpm = 134;
  int measure;
  float beat;
  
  final int IMG_HEIGHT = 48;
  final int POINT_CUTOFF = 20;
  final int Y_TO_MISS = 50;
  
  public RhythmArrow(RhythmPanel p, int xi, int ki, int ind, int m, float b) {
    x = xi;
    y = 9999;
    key_y_value = ki;
    index = ind;
    measure = m;
    beat = b;
    panel = p;
  }
  
  public void setPos() {
    //When the panel's measure and beat line up with this arrow's measure and beat, the y-value should be at key_y_value.
    //If the panel's measure and beat are less than this arrow's measure and beat, the y-value should be greater than key_y_value.
    float panel_time = panel.measure + panel.beat;
    float this_time = measure + beat;
    
    y = (this_time * NOTE_SPEED) - (NOTE_SPEED * panel_time) + key_y_value + VISUAL_AUDIO_BUFFER;
    
    //y = key_y_value + note_speed*(panel_time + this_time);
    
  }
  
  public int getPoints() {
    
    int dist = (int) (y - key_y_value);    
    int points;
    if (dist < 0 - POINT_CUTOFF) {
      points = -1;
    }
    else if (dist < 0) {
      points = 2;
    }
    else if (dist < POINT_CUTOFF) {
      points = 3;
    }
    else if (dist < POINT_CUTOFF*2) {
      points = 2;
    }
    else if (dist < POINT_CUTOFF*3) {
      points = 1;
    }
    else if (dist < POINT_CUTOFF*4) {
      points = -1;
    }
    else {
      points = 0;
    }
    
    return points;
  }
  
  public boolean isInBounds() {
    return (y < height || y > 0);
  }
  
  public void hide() {
    visible = false;
  }
  
  void draw() {
    setPos();
    
    if (y < key_y_value - Y_TO_MISS) {
      hide();
    }
    
    if (isInBounds() && visible) image(globalData.images.get("arrow_" + index), x, y);
  }
  
}
