public class SongMaps1 extends SongMaps {
  
  public SongMaps1() {
    bpm = 134;
    beats_in_measure = 4;
    
    p = new RhythmMap[5];
    p[0] = new RhythmMap("percussion", 8);
    for (int i = 0; i < 8; i++) {
      p[0].addNote(1, i, 0);
      p[0].addNote(1, i, 0.5);
      p[0].addNote(2, i, 0.5);
    }
    
    p[1] = new RhythmMap("percussion", 16);
    for (int i = 8; i < 16; i++) {
      p[1].addNote(1, i, 0);
      p[1].addNote(1, i, 0.5);
      p[1].addNote(2, i, 0.5);
    }
    
    p[2] = new RhythmMap("percussion", 24);
    for (int i = 0; i < 8; i++) {
      p[2].addNote(1, i, 0);
      p[2].addNote(1, i, 0.5);
    }
    p[2].addNote(2, 7, 0.625);
    p[2].addNote(2, 7, 0.75);
    
    p[3] = new RhythmMap("percussion", 32);
    
    for (int i = 0; i < 8; i++) {
      p[3].addNote(2, i, 0.25);
      p[3].addNote(2, i, 0.375);
      p[3].addNote(2, i, 0.75);
      if (i % 4 == 0 && i != 0) p[3].addNote(0, i, 0.25);
      else if (i < 8 || i > 11) {
      p[3].addNote(3, i, 0); 
      p[3].addNote(3, i, 0.125);
      p[3].addNote(3, i, 0.25); }
      p[3].addNote(3, i, 0.375);
      p[3].addNote(3, i, 0.5);
      p[3].addNote(3, i, 0.625);
      p[3].addNote(3, i, 0.75);
      p[3].addNote(3, i, 0.875);
    }
    
    p[4] = new RhythmMap("percussion", 32);
    for (int i = 8; i < 16; i++) {
      p[4].addNote(2, i, 0.25);
      p[4].addNote(2, i, 0.375);
      p[4].addNote(2, i, 0.75);
      if (i % 4 == 0 && i != 0) p[4].addNote(0, i, 0.25);
      else if (i < 8 || i > 11) {
      p[4].addNote(3, i, 0); 
      p[4].addNote(3, i, 0.125);
      p[4].addNote(3, i, 0.25); }
      p[4].addNote(3, i, 0.375);
      p[4].addNote(3, i, 0.5);
      p[4].addNote(3, i, 0.625);
      p[4].addNote(3, i, 0.75);
      p[4].addNote(3, i, 0.875);
    }
    
    b = new RhythmMap[5];
    b[0] = new RhythmMap("guitar", 0);
    b[0].addNote(2, 0, 0);
    b[0].addNote(2, 1, 0);
    b[0].addNote(2, 1, 0.375);
    b[0].addNote(2, 1, 0.625);
    b[0].addNote(1, 1, 0.875);
    b[0].addNote(2, 4, 0);
    b[0].addNote(2, 5, 0);
    b[0].addNote(2, 5, 0.375);
    b[0].addNote(2, 5, 0.625);
    b[0].addNote(1, 5, 0.875);
    b[0].addNote(0, 7, 0.625);
    b[0].addNote(0, 7, 0.75);
    
    
    b[1] = new RhythmMap("guitar", 8);
    b[1].addNote(2, 0, 0);
    b[1].addNote(2, 1, 0);
    b[1].addNote(2, 1, 0.375);
    b[1].addNote(2, 1, 0.625);
    b[1].addNote(1, 1, 0.875);
    b[1].addNote(2, 4, 0);
    b[1].addNote(2, 5, 0);
    b[1].addNote(2, 5, 0.375);
    b[1].addNote(2, 5, 0.625);
    b[1].addNote(1, 5, 0.875);
    b[1].addNote(0, 7, 0.625);
    b[1].addNote(0, 7, 0.75);
    b[1].addNote(3, 8, 0);
    b[1].addNote(3, 9, 0);
    b[1].addNote(2, 9, 0.25);
    b[1].addNote(1, 9, 0.375);
    b[1].addNote(2, 9, 0.625);
    b[1].addNote(1, 9, 0.875);
    b[1].addNote(0,11, 0);
    b[1].addNote(0,11, 0.375);
    b[1].addNote(1,11, 0.625);
    b[1].addNote(2,11, 0.875);
    b[1].addNote(2,13, 0);
    b[1].addNote(2,13, 0.375);
    b[1].addNote(3,13, 0.625);
    b[1].addNote(1,13, 0.875);
    
    b[2] = new RhythmMap("guitar", 24);
    b[2].addNote(3, 0, 0);
    b[2].addNote(3, 1, 0);
    b[2].addNote(3, 1, 0.375);
    b[2].addNote(3, 1, 0.625);
    b[2].addNote(1, 1, 0.875);
    b[2].addNote(3, 4, 0);
    b[2].addNote(3, 5, 0);
    b[2].addNote(3, 5, 0.375);
    b[2].addNote(3, 5, 0.625);
    b[2].addNote(1, 5, 0.875);
    b[2].addNote(0, 7, 0.625);
    b[2].addNote(0, 7, 0.75);
    
    b[3] = new RhythmMap("guitar", 32);
    b[3].addNote(2, 0, 0);
    b[3].addNote(1, 0, 0.25);
    b[3].addNote(2, 0, 0.375);
    b[3].addNote(1, 0, 0.75);
    b[3].addNote(2, 1, 0);
    b[3].addNote(1, 1, 0.125);
    b[3].addNote(2, 1, 0.375);
    b[3].addNote(1, 1, 0.75);
    b[3].addNote(2, 2, 0);
    b[3].addNote(1, 2, 0.125);
    b[3].addNote(2, 2, 0.375);
    b[3].addNote(1, 2, 0.625);
    b[3].addNote(2, 3, 0);
    b[3].addNote(1, 3, 0.125);
    b[3].addNote(2, 3, 0.375);
    b[3].addNote(3, 3, 0.625);
    
    b[3].addNote(1, 4, 0.25);
    b[3].addNote(1, 4, 0.5);
    b[3].addNote(0, 4, 0.75);
    b[3].addNote(1, 5, 0);
    b[3].addNote(0, 5, 0.125);
    b[3].addNote(1, 5, 0.375);
    b[3].addNote(1, 5, 0.75);
    b[3].addNote(0, 5, 0.825);
    b[3].addNote(1, 6, 0);
    b[3].addNote(0, 6, 0.125);
    b[3].addNote(1, 6, 0.375);
    b[3].addNote(0, 6, 0.625);
    b[3].addNote(1, 7, 0);
    b[3].addNote(0, 7, 0.125);
    b[3].addNote(1, 7, 0.375);
    b[3].addNote(2, 7, 0.625);
    
    b[4] = new RhythmMap("guitar", 32);
    b[4].addNote(2, 8, 0);
    b[4].addNote(1, 8, 0.25);
    b[4].addNote(2, 8, 0.375);
    b[4].addNote(1, 8, 0.75);
    b[4].addNote(2, 9, 0);
    b[4].addNote(1, 9, 0.125);
    b[4].addNote(2, 9, 0.375);
    b[4].addNote(1, 9, 0.75);
    b[4].addNote(2,10, 0);
    b[4].addNote(1,10, 0.125);
    b[4].addNote(2,10, 0.375);
    b[4].addNote(1,10, 0.625);
    b[4].addNote(2,11, 0);
    b[4].addNote(1,11, 0.125);
    b[4].addNote(2,11, 0.375);
    b[4].addNote(3,11, 0.625);
    
    b[4].addNote(1,12, 0.25);
    b[4].addNote(1,12, 0.5);
    b[4].addNote(0,12, 0.75);
    b[4].addNote(1,13, 0);
    b[4].addNote(0,13, 0.125);
    b[4].addNote(1,13, 0.375);
    b[4].addNote(1,13, 0.75);
    b[4].addNote(0,13, 0.825);
    b[4].addNote(1,14, 0);
    b[4].addNote(0,14, 0.125);
    b[4].addNote(1,14, 0.375);
    b[4].addNote(0,14, 0.625);
    b[4].addNote(1,15, 0);
    b[4].addNote(0,15, 0.125);
    b[4].addNote(1,15, 0.375);
    b[4].addNote(2,15, 0.625);
  }
  
}

public class SongMaps {
  //for this song: 134
  int bpm; //beats per MINUTE
  int beats_in_measure;
  RhythmMap[] g; //guitar
  RhythmMap[] b; //bass
  RhythmMap[] k; //keyboard
  RhythmMap[] p; //percussion
  RhythmMap[] v; //vocals
}


public class RhythmMap {
  
  String instrument;
  int measure;
  ArrayList<MapNote> notes;
  
  public RhythmMap(String i, int m) {
    instrument = i;
    measure = m;
    notes = new ArrayList<MapNote>();
  }
  
  public void addNote(int d, int m, float b) {
    notes.add(new MapNote(d, m, b));
  }
  
}

public class MapNote {
  int dir; //0-left, 1-down, 2-right, 3-up
  int measure; //starting from the beginning of the "part", not the song.
  float beat; // when the note is within the measure, values are on the range [0,1).
  
  public MapNote(int d, int m, float b) {
    dir = d;
    measure = m;
    beat = b;
  }
}
