public class RhythmPanel {
  
  int x_mod;
  int y_mod;
  
  int measure = -4;
  float beat = 0;
  boolean counting = false;
  
  final int KEY_SIZE = 50;
  final int SPACING = 10;
  
  RhythmKey[] keys;
  ArrayList<RhythmArrow> arrows;
  RhythmArrow[] nextArrows; //the most recent arrow in each category. 
  
  SongMaps song = new SongMaps1();
  RhythmMap[] curMaps;
  
  MapUnit bass_unit;
  MapUnit perc_unit;
  
  boolean show = false;
  boolean flag0 = false;
  
  public RhythmPanel(int xi, int yi) {
    x_mod = xi;
    y_mod = yi;
    
    keys = new RhythmKey[]{
      new RhythmKey(0 + x_mod, 0 + y_mod, KEY_SIZE, KEY_SIZE, color(0, 255, 0), color(0, 127, 0)),
      new RhythmKey(KEY_SIZE + SPACING + x_mod, 0 + y_mod, KEY_SIZE, KEY_SIZE, color(255, 0, 0), color(127, 0, 0)),
      new RhythmKey(2*(KEY_SIZE + SPACING) + x_mod, 0 + y_mod, KEY_SIZE, KEY_SIZE, color(255, 255, 0), color(127, 127, 0)),
      new RhythmKey(3*(KEY_SIZE + SPACING) + x_mod, 0 + y_mod, KEY_SIZE, KEY_SIZE, color(0, 0, 255), color(0, 0, 127)),
    };
    nextArrows = new RhythmArrow[4];
    
  }
  
  void draw() {
    
    soundProcess();
    
    if (((GameScene)gameScene).phase == "rhythm" || counting) {
    
      for (RhythmKey k : keys) {
          k.draw();
        }
        
      for (RhythmArrow a : arrows) {
        a.draw();
      }
    
    }
    
    if (counting) gameTimerProcess();
    
    
  }
  /*
  void initializeArrows_old(RhythmMap[] c) {
    curMaps = c;
    arrows = new ArrayList<RhythmArrow>();
    if (curMaps != null) {
      for (RhythmMap r : curMaps) {
        for (MapNote n : r.notes) {
          arrows.add( new RhythmArrow( this, keys[n.dir].x, keys[n.dir].y, n.dir, r.measure + n.measure, n.beat ) );
        }
      }
      updateAllArrows();
    }
  }*/
  
  void initializeArrows() {
    counting = true;
    measure = -4;
    beat = 0;
    curMaps = new RhythmMap[4];
    curMaps[0] = song.b[0];
    curMaps[1] = song.p[0];
    curMaps[2] = song.p[3];
    curMaps[3] = song.b[4];
    arrows = new ArrayList<RhythmArrow>();
    if (curMaps != null) {
      for (RhythmMap r : curMaps) {
        for (MapNote n : r.notes) {
          arrows.add( new RhythmArrow( this, keys[n.dir].x, keys[n.dir].y, n.dir, r.measure + n.measure, n.beat ) );
        }
      }
      updateAllArrows();
    }
  }
  
  public void updateAllArrows() {
    updateNextArrow(0);
    updateNextArrow(1);
    updateNextArrow(2);
    updateNextArrow(3);
  }
  
  public void updateNextArrow(int index) {
    RhythmArrow cur = null;
    
    for (RhythmArrow a : arrows) {
      if (a.index == index) {
        if (cur == null || a.getPoints() > cur.getPoints()) {
          cur = a;
        }
      }
    }
    nextArrows[index] = cur;
  }
  
  public void keyPress(int index) {
    ((GameScene) gameScene).rhythmPanel.keys[index].setPressed(true);
    
    if (nextArrows[index] != null) {
      if (nextArrows[index].getPoints() != 0) {
        //(nextArrows[index].getPoints());
        nextArrows[index].hide();
        getHit();
        arrows.remove(nextArrows[index]);
        updateNextArrow(index);
      }
    }
    
  }
  
  void soundProcess() {
    if (measure >= 0 && !AP_percussion.isPlaying()) {
      AP_percussion.play();
      AP_bass.play();
    }
  }
  
  void gameTimerProcess() {
    beat += GAME_SPEED * ( (float)song.bpm / (60. * FRAME_RATE * (float)song.beats_in_measure));
    
    if (beat >= 1) {
      beat = 0;
      measure++;
    }
    if (measure >= 16 && measure < 32 && ((GameScene)gameScene).phase == "rhythm") {
      ((GameScene)gameScene).swapPhase();
    }
    else if (measure >= 32 && measure < 48 && ((GameScene)gameScene).phase == "strategy") {
      ((GameScene)gameScene).swapPhase();
    }
    else if (measure >= 48 && ((GameScene)gameScene).phase == "rhythm") {
      ((GameScene)gameScene).swapPhase();
      AP_percussion.rewind();
      AP_bass.rewind();
      AP_percussion.pause();
      AP_bass.pause();
      counting = false;
      
    }
    println(measure + beat);
    
  }
  
  //hardcoded when it shouldn't be
  //this should check a variable that says who the current notes belong to instead of just check what time it is.
  public void getHit() {
    if ((0 <= measure && measure < 8) || (40 <= measure && measure < 48)) {
      if (bass_unit.target != null) {
        bass_unit.data.attackUnit(bass_unit.target.data, bass_unit.data.getEquipped());
        ((GameScene)gameScene).dataPanel.updateData(bass_unit.target.data);
      }
      else {
        bass_unit.data.changeStamina(1);
        ((GameScene)gameScene).dataPanel.updateData(bass_unit.data);
      }
    }
    if ((8 <= measure && measure < 16) || (32 <= measure && measure < 40)) {
      if (perc_unit.target != null) {
        perc_unit.data.attackUnit(perc_unit.target.data, perc_unit.data.getEquipped());
        ((GameScene)gameScene).dataPanel.updateData(perc_unit.target.data);
      }
      else {
        perc_unit.data.changeStamina(1);
        ((GameScene)gameScene).dataPanel.updateData(perc_unit.data);
      }
    }
  }
  
  
}
