public abstract class Scene {
  
  public void draw() {}
  
}

public class MainMenu extends Scene {
  
  TextButton play = new TextButton(50, 150, 200, 50, "Play", 32);
  TextButton info = new TextButton(50, 220, 200, 50, "Instructions", 32);
  TextButton gear = new TextButton(50, 290, 200, 50, "Settings", 32);
  TextButton exit = new TextButton(50, 360, 200, 50, "Exit", 32);
  
  public MainMenu() {
  }
  
  public void draw() {
    play.draw();
    info.draw();
    gear.draw();
    exit.draw();
    
    if (play.isJustPressed()) {
      current = gameScene;
    }
    if (gear.isJustPressed()) current = settingsMenu;
    if (info.isJustPressed()) current = instructions;
    if (exit.isJustPressed()) exit();
  }
}

public class SettingsMenu extends Scene {
  
  TextButton[] resolutions = new TextButton[] {
    new TextButton(50, 100, 200, 50, "640 x 360", 32),
    new TextButton(50, 170, 200, 50, "1280 x 720", 32),
    new TextButton(50, 240, 200, 50, "1360 x 768", 32),
    new TextButton(50, 310, 200, 50, "1600 x 900", 32),
    new TextButton(50, 380, 200, 50, "1920 x 1080", 32)
  };
  
  TextButton back = new TextButton(10, 490, 160, 40, "Back", 24);
  
  public void draw() {
    textAlign(CENTER);
    textSize(48);
    text("Resolution", 150, 75);
    for (TextButton i : resolutions) i.draw();
    back.draw();
    
    if (resolutions[0].isJustPressed()) setResolution(640);
    if (resolutions[1].isJustPressed()) setResolution(1280);
    if (resolutions[2].isJustPressed()) setResolution(1360);
    if (resolutions[3].isJustPressed()) setResolution(1600);
    if (resolutions[4].isJustPressed()) setResolution(1920);
    
    if (back.isJustPressed()) current = main;
  }
  
}

public class Instructions extends Scene {
  
  TextButton back = new TextButton(20, 20, 100, 40, "Menu", 24);
  TextButton prev = new TextButton(20, 490, 100, 40, "Prev", 24);
  TextButton next = new TextButton(840, 490, 100, 40, "Next", 24);
  
  int page = 0;
  
  final int MIN_PAGE = 0;
  final int MAX_PAGE = 5;
  
  public Instructions() {
  }
  
  void draw() {
    image(loadImage("instructions\\" + page + ".png"), 0, 0, width, height);
    
    back.draw();
    prev.draw();
    next.draw();
    
    if (back.isJustPressed()) current = main;
    if (prev.isJustPressed() && page > MIN_PAGE) page--;
    if (next.isJustPressed() && page < MAX_PAGE) page++;
    
  }
  
}
