public class UnitData {
  
  public String unit_name;
  
  public int max_stamina; //max hp
  public int cur_stamina; //min hp
  public int speed; //spaces can move per turn
  public int melody; //melody damage
  public int rhythm; //rhythm damage
  public int focus; //melody defense
  public int tempo; //rhythm defense
  
  public ItemData[] inventory = new ItemData[5];
  
  public String instrument_type;
  
  public UnitData(String nam, int sta, int spd, int mel, int rhy, int foc, int tem, String typ) {
    unit_name = nam;
    max_stamina = sta;
    cur_stamina = sta/2;
    speed = spd;
    melody = mel;
    rhythm = rhy;
    focus = foc;
    tempo = tem;
    instrument_type = typ;
  }
  
  public void attackUnit(UnitData other, InstrumentData weapon) {
    int damage = weapon.damage_mod;
    if (weapon.damage_type == "melody") {
      damage += this.melody;
      damage -= other.focus;
    }
    else if (weapon.damage_type == "rhythm") {
      damage += this.melody;
      damage -= other.focus;
    }
    else println("Oopsies! Problem in the attackUnit function!! Weapon damage type wasn't put as melody or rhythm, which shouldn't happen.");
    
    if (damage < 0) damage = 0;
    
    other.changeStamina(damage * -1);
    
  }
  
  public void changeStamina(int s) {
    cur_stamina += s;
    if (cur_stamina > max_stamina) cur_stamina = max_stamina;
    if (cur_stamina <= 0) {
      cur_stamina = 0;
      killUnit();
    }
  }
  
  public void killUnit() {
  }
  
  public boolean isDead() {
    return cur_stamina <= 0;
  }
  
  //true if there is enough space for the item, false otherwise
  public boolean giveItem(ItemData item) {
    for (int i = 0; i < inventory.length; i++) {
      if (inventory[i] == null) {
        inventory[i] = item;
        return true;
      }
    }
    return false;
  }
  
  public InstrumentData getEquipped() {
    ItemData equipped = null;
    for (ItemData i : inventory) {
      if (i != null) equipped = i;
      break;
    }
    return (InstrumentData)equipped;
  }
  
  public UnitData copyUnit() {
    UnitData unit = new UnitData(unit_name, max_stamina, speed, melody, rhythm, focus, tempo, instrument_type);
    return unit;
  }
  
  
}
