/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PImage;

public class TigerGame
extends PApplet {
    public GameManager gameManager;
    final String TIGER_IMG_PATH = "tiger.jpg";
    final String LAMB_IMG_PATH = "lamb.jpg";
    PImage tiger_img;
    PImage lamb_img;
    String winner = "";

    public void setup() {
        this.windowMove(200, 80);
        this.gameManager = new GameManager();
        this.tiger_img = this.loadImage("tiger.jpg");
        this.lamb_img = this.loadImage("lamb.jpg");
    }

    public void draw() {
        this.gameManager._process();
    }

    public void settings() {
        this.size(960, 540);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"TigerGame"};
        if (passedArgs != null) {
            PApplet.main((String[])TigerGame.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Button
    extends Scene {
        private String name;
        private boolean lastFramePressed;
        int x;
        int y;
        int w;
        int h;
        boolean can_press;
        int align;
        private float x_mod;
        String text;
        int text_size;
        int text_color;
        int outline_color;
        int fill_normal;
        int fill_hover;
        int fill_press;

        public Button(int x_pos, int y_pos, int wid, int hei, int a, String t, int ts) {
            this.name = "Button";
            this.lastFramePressed = false;
            this.x = 0;
            this.y = 0;
            this.w = 1;
            this.h = 1;
            this.can_press = true;
            this.align = 3;
            this.text = "";
            this.text_size = 16;
            this.text_color = TigerGame.this.color(0);
            this.outline_color = TigerGame.this.color(0);
            this.fill_normal = TigerGame.this.color(255);
            this.fill_hover = TigerGame.this.color(204);
            this.fill_press = TigerGame.this.color(127);
            this.x = x_pos;
            this.y = y_pos;
            this.w = wid;
            this.h = hei;
            this.setAlign(a);
            this.text = t;
            this.text_size = ts;
        }

        public Button(int x_pos, int y_pos, int wid, int hei, int a) {
            this.name = "Button";
            this.lastFramePressed = false;
            this.x = 0;
            this.y = 0;
            this.w = 1;
            this.h = 1;
            this.can_press = true;
            this.align = 3;
            this.text = "";
            this.text_size = 16;
            this.text_color = TigerGame.this.color(0);
            this.outline_color = TigerGame.this.color(0);
            this.fill_normal = TigerGame.this.color(255);
            this.fill_hover = TigerGame.this.color(204);
            this.fill_press = TigerGame.this.color(127);
            this.x = x_pos;
            this.y = y_pos;
            this.w = wid;
            this.h = hei;
            this.setAlign(a);
        }

        public Button() {
            this.name = "Button";
            this.lastFramePressed = false;
            this.x = 0;
            this.y = 0;
            this.w = 1;
            this.h = 1;
            this.can_press = true;
            this.align = 3;
            this.text = "";
            this.text_size = 16;
            this.text_color = TigerGame.this.color(0);
            this.outline_color = TigerGame.this.color(0);
            this.fill_normal = TigerGame.this.color(255);
            this.fill_hover = TigerGame.this.color(204);
            this.fill_press = TigerGame.this.color(127);
        }

        public void onHover() {
        }

        public void onPress() {
        }

        public void onJustPress() {
        }

        public void onRelease() {
        }

        @Override
        public void process() {
            if (this.isPressed()) {
                TigerGame.this.fill(this.fill_press);
            } else if (this.isHovered()) {
                TigerGame.this.fill(this.fill_hover);
            } else {
                TigerGame.this.fill(this.fill_normal);
            }
            TigerGame.this.stroke(this.outline_color);
            TigerGame.this.rect((float)this.x - (float)this.w * this.x_mod, this.y - this.h / 2, this.w, this.h);
            TigerGame.this.fill(this.text_color);
            TigerGame.this.textSize(this.text_size);
            TigerGame.this.textAlign(this.align);
            TigerGame.this.text(this.text, this.x, this.y + this.text_size / 2);
            if (this.isHovered()) {
                this.onHover();
            }
            if (this.isPressed()) {
                this.onPress();
            }
            if (this.isJustPressed()) {
                this.onJustPress();
            }
            if (this.isJustReleased()) {
                this.onRelease();
            }
            this.lastFramePressed = this.isPressed();
        }

        public boolean isHovered() {
            return this.can_press && (float)TigerGame.this.mouseX > (float)this.x - (float)this.w * this.x_mod && (float)TigerGame.this.mouseX < (float)(this.x + this.w) - (float)this.w * this.x_mod && TigerGame.this.mouseY > this.y - this.h / 2 && TigerGame.this.mouseY < this.y + this.h / 2;
        }

        public boolean isPressed() {
            return this.isHovered() && TigerGame.this.mousePressed;
        }

        public boolean isJustPressed() {
            return this.isPressed() && this.isHovered() && !this.lastFramePressed;
        }

        public boolean isJustReleased() {
            return !this.isPressed() && this.isHovered() && this.lastFramePressed;
        }

        public void setCanPress(boolean can) {
            this.can_press = can;
        }

        public boolean getCanPress() {
            return this.can_press;
        }

        public void setAlign(int a) {
            this.align = a;
            switch (this.align) {
                case 37: {
                    this.x_mod = 0.0f;
                    break;
                }
                case 39: {
                    this.x_mod = 1.0f;
                    break;
                }
                case 3: {
                    this.x_mod = 0.5f;
                    break;
                }
                default: {
                    TigerGame.println((String)"oopsies, setAlign() was called with a value it can't take.");
                }
            }
        }
    }

    public class GameManager
    extends Scene {
        private int currentScene;
        private Scene mainMenu;
        private Scene play;
        private Scene instructions;
        private Scene winScreen;
        final int bg_color;

        public GameManager() {
            this.currentScene = 0;
            this.bg_color = TigerGame.this.color(204);
            this.mainMenu = this.addChild(new MainMenu());
            this.play = this.addChild(new Play());
            this.instructions = this.addChild(new Instructions());
            this.winScreen = this.addChild(new WinScreen());
            this.setCurrentScene(0);
        }

        @Override
        public void process() {
            TigerGame.this.background(this.bg_color);
        }

        public void setCurrentScene(int scen) {
            if (scen >= 0) {
                this.currentScene = scen;
                for (Scene s : this.getChildren()) {
                    s.setVis(false);
                }
                this.getChild(scen).setVis(true);
            } else {
                TigerGame.this.exit();
            }
        }

        private int getCurrentScene() {
            return this.currentScene;
        }
    }

    public class Instructions
    extends Scene {
        private int page;

        public Instructions() {
            this.page = 0;
            this.addChild(new NavButton(TigerGame.this.width - 125, TigerGame.this.height - 65, 200, 50, 3, "Menu", 24).setVal(0));
            this.addChild(new PageButton(TigerGame.this.width - 150, TigerGame.this.height - 125, 50, 50, 3, "1", 24).setVal(0));
            this.addChild(new PageButton(TigerGame.this.width - 100, TigerGame.this.height - 125, 50, 50, 3, "2", 24).setVal(1));
        }

        @Override
        public void process() {
            TigerGame.this.textAlign(37);
            TigerGame.this.textSize(24.0f);
            TigerGame.this.text("TIGER GAME!", 10.0f, 30.0f);
            if (this.page == 0) {
                TigerGame.this.textSize(20.0f);
                TigerGame.this.text("One player has 3 counters (Tigers); the other has 15 counters (Lambs).", 50.0f, 100.0f);
                TigerGame.this.textSize(24.0f);
                TigerGame.this.text("Object:", 10.0f, 170.0f);
                TigerGame.this.textSize(20.0f);
                TigerGame.this.text("For Lambs, to block Tigers so that they cannot move.", 50.0f, 230.0f);
                TigerGame.this.text("For Tigers, to devour so many Lambs that those remaining are not enough to block them.", 50.0f, 290.0f);
                TigerGame.this.textSize(24.0f);
                TigerGame.this.text("To Start:", 10.0f, 380.0f);
                TigerGame.this.textSize(20.0f);
                TigerGame.this.text("Place Tigers on the 3 blue spots.", 50.0f, 440.0f);
            } else if (this.page == 1) {
                TigerGame.this.textSize(24.0f);
                TigerGame.this.text("To Play:", 10.0f, 100.0f);
                TigerGame.this.textSize(20.0f);
                TigerGame.this.text("Take turns. Lambs player begins, placing 1 Lamb each turn on any vacant spot (blue or pink).", 10.0f, 170.0f);
                TigerGame.this.text("In a turn 1 Tiger can move along any line to an adjacent vacant spot.", 10.0f, 230.0f);
                TigerGame.this.text("If an adjacent spot is occupied by a Lamb, Tiger can devour it by leaping over it to the vacant spot beyond it.", 10.0f, 290.0f);
                TigerGame.this.text("Tiger must select the lamb that it wants to devour. If the tiger cannot leap in a straight line, it won't work.", 10.0f, 350.0f);
                TigerGame.this.text("Lambs are only allowed to move when all of them have been placed.", 10.0f, 410.0f);
                TigerGame.this.text("Then they must move along a line to an adjacent vacant spot.", 10.0f, 470.0f);
            }
        }

        public int getPage() {
            return this.page;
        }

        public void setPage(int val) {
            this.page = val;
        }
    }

    public class MainMenu
    extends Scene {
        public MainMenu() {
            this.addChild(new NavButton(TigerGame.this.width / 2, TigerGame.this.height / 2, 200, 50, 3, "Play", 24).setVal(1));
            this.addChild(new NavButton(TigerGame.this.width / 2, TigerGame.this.height / 2 + 60, 200, 50, 3, "Instructions", 24).setVal(2));
            this.addChild(new NavButton(TigerGame.this.width / 2, TigerGame.this.height / 2 + 120, 200, 50, 3, "Exit", 24).setVal(-1));
        }

        @Override
        public void process() {
            TigerGame.this.textAlign(3);
            TigerGame.this.textSize(36.0f);
            TigerGame.this.text("Tiger Game", TigerGame.this.width / 2, TigerGame.this.height / 2 - 60);
        }
    }

    public class NavButton
    extends Button {
        private int scene_val;

        public NavButton(int x_pos, int y_pos, int wid, int hei, int a) {
            super(x_pos, y_pos, wid, hei, a);
        }

        public NavButton(int x_pos, int y_pos, int wid, int hei, int a, String t, int ts) {
            super(x_pos, y_pos, wid, hei, a, t, ts);
        }

        @Override
        public void onRelease() {
            TigerGame.this.gameManager.setCurrentScene(this.scene_val);
        }

        public Button setVal(int v) {
            this.scene_val = v;
            return this;
        }
    }

    class NodeButton
    extends Button {
        TigerNode node;
        Play play;

        public NodeButton(int x_pos, int y_pos, int wid, int hei) {
            super(x_pos, y_pos, wid, hei, 3);
        }

        @Override
        public void ready() {
            this.node = (TigerNode)this.getParent();
            this.play = (Play)this.node.getParent();
            if (this.node.tiger_start) {
                this.fill_normal = TigerGame.this.color(0, 0, 255);
                this.fill_hover = TigerGame.this.color(0, 0, 204);
                this.fill_press = TigerGame.this.color(0, 0, 127);
            } else {
                this.fill_normal = TigerGame.this.color(255, 0, 255);
                this.fill_hover = TigerGame.this.color(204, 0, 204);
                this.fill_press = TigerGame.this.color(127, 0, 127);
            }
        }

        @Override
        public void onRelease() {
            switch (this.play.state) {
                case PLACE_LAMB: {
                    if (this.node.getValue() != Spot.EMPTY) break;
                    this.node.setValue(Spot.LAMB);
                    this.play.placeLamb();
                    this.play.setState(State.PICK_TIGER);
                    break;
                }
                case PICK_TIGER: {
                    if (this.node.getValue() != Spot.TIGER) break;
                    this.play.selectNode(this.node);
                    this.play.setState(State.MOVE_TIGER);
                    break;
                }
                case MOVE_TIGER: {
                    if (this.play.getSelectedNode().isAdjacent(this.node)) {
                        switch (this.node.getValue()) {
                            case EMPTY: {
                                this.node.setValue(Spot.TIGER);
                                this.play.getSelectedNode().setValue(Spot.EMPTY);
                                this.play.setLambTurn();
                                break;
                            }
                            case TIGER: {
                                this.play.setState(State.PICK_TIGER);
                                break;
                            }
                            case LAMB: {
                                if (this.play.getSelectedNode().tryCapture(this.node) == null) break;
                                TigerNode land = this.play.getSelectedNode().tryCapture(this.node);
                                this.play.getSelectedNode().setValue(Spot.EMPTY);
                                this.node.setValue(Spot.EMPTY);
                                land.setValue(Spot.TIGER);
                                this.play.setLambTurn();
                            }
                        }
                        break;
                    }
                    this.play.setState(State.PICK_TIGER);
                    break;
                }
                case PICK_LAMB: {
                    if (this.node.getValue() != Spot.LAMB) break;
                    this.play.selectNode(this.node);
                    this.play.setState(State.MOVE_LAMB);
                    break;
                }
                case MOVE_LAMB: {
                    if (this.node.getValue() == Spot.EMPTY) {
                        if (!this.play.getSelectedNode().isAdjacent(this.node)) break;
                        this.node.setValue(Spot.LAMB);
                        this.play.getSelectedNode().setValue(Spot.EMPTY);
                        this.play.setState(State.PICK_TIGER);
                        break;
                    }
                    this.play.setState(State.PICK_LAMB);
                    break;
                }
            }
        }
    }

    public class NodeWeb
    extends Scene {
        ArrayList<int[]> lines;
        private String name;

        public NodeWeb() {
            this.lines = new ArrayList();
            this.name = "NodeWeb";
        }

        @Override
        public void process() {
            for (int[] l : this.lines) {
                TigerGame.this.line(l[0], l[1], l[2], l[3]);
            }
        }

        public void addLine(int x, int y, int w, int h) {
            this.lines.add(new int[]{x, y, w, h});
        }
    }

    public class PageButton
    extends Button {
        int page_val;

        public PageButton(int x_pos, int y_pos, int wid, int hei, int a, String t, int ts) {
            super(x_pos, y_pos, wid, hei, a, t, ts);
            this.page_val = 0;
        }

        @Override
        public void onRelease() {
            ((Instructions)this.getParent()).setPage(this.page_val);
        }

        public Button setVal(int val) {
            this.page_val = val;
            return this;
        }
    }

    public class Play
    extends Scene {
        State state;
        int lambs;
        TigerNode selected;
        final int STARTING_LAMBS = 15;
        TigerNode[] nodes;

        public Play() {
            this.state = State.START;
            this.STARTING_LAMBS = 15;
            this.nodes = new TigerNode[17];
            this.addChild(new NodeWeb());
            this.addChild(new TigerNode(TigerGame.this.width / 2, TigerGame.this.height / 2 - 150, true));
            this.addChild(new TigerNode(TigerGame.this.width / 2 - 200, TigerGame.this.height / 2 - 50, false));
            this.addChild(new TigerNode(TigerGame.this.width / 2 - 120, TigerGame.this.height / 2 - 50, false));
            this.addChild(new TigerNode(TigerGame.this.width / 2 - 40, TigerGame.this.height / 2 - 50, true));
            this.addChild(new TigerNode(TigerGame.this.width / 2 + 40, TigerGame.this.height / 2 - 50, true));
            this.addChild(new TigerNode(TigerGame.this.width / 2 + 120, TigerGame.this.height / 2 - 50, false));
            this.addChild(new TigerNode(TigerGame.this.width / 2 + 200, TigerGame.this.height / 2 - 50, false));
            this.addChild(new TigerNode(TigerGame.this.width / 2 - 325, TigerGame.this.height / 2 + 50, false));
            this.addChild(new TigerNode(TigerGame.this.width / 2 - 195, TigerGame.this.height / 2 + 50, false));
            this.addChild(new TigerNode(TigerGame.this.width / 2 - 65, TigerGame.this.height / 2 + 50, false));
            this.addChild(new TigerNode(TigerGame.this.width / 2 + 65, TigerGame.this.height / 2 + 50, false));
            this.addChild(new TigerNode(TigerGame.this.width / 2 + 195, TigerGame.this.height / 2 + 50, false));
            this.addChild(new TigerNode(TigerGame.this.width / 2 + 325, TigerGame.this.height / 2 + 50, false));
            this.addChild(new TigerNode(TigerGame.this.width / 2 - 255, TigerGame.this.height / 2 + 150, false));
            this.addChild(new TigerNode(TigerGame.this.width / 2 - 85, TigerGame.this.height / 2 + 150, false));
            this.addChild(new TigerNode(TigerGame.this.width / 2 + 85, TigerGame.this.height / 2 + 150, false));
            this.addChild(new TigerNode(TigerGame.this.width / 2 + 255, TigerGame.this.height / 2 + 150, false));
            int i = 1;
            while (i < 18) {
                this.nodes[i - 1] = (TigerNode)this.getChild(i);
                ++i;
            }
            this.nodes[0].setConnections(new TigerNode[]{this.nodes[2], this.nodes[3], this.nodes[4], this.nodes[5]});
            this.nodes[1].setConnections(new TigerNode[]{this.nodes[1], this.nodes[7]});
            this.nodes[2].setConnections(new TigerNode[]{this.nodes[0], this.nodes[1], this.nodes[3], this.nodes[8]});
            this.nodes[3].setConnections(new TigerNode[]{this.nodes[0], this.nodes[2], this.nodes[4], this.nodes[9]});
            this.nodes[4].setConnections(new TigerNode[]{this.nodes[0], this.nodes[3], this.nodes[5], this.nodes[10]});
            this.nodes[5].setConnections(new TigerNode[]{this.nodes[0], this.nodes[4], this.nodes[6], this.nodes[11]});
            this.nodes[6].setConnections(new TigerNode[]{this.nodes[5], this.nodes[12]});
            this.nodes[7].setConnections(new TigerNode[]{this.nodes[1], this.nodes[8]});
            this.nodes[8].setConnections(new TigerNode[]{this.nodes[2], this.nodes[7], this.nodes[9], this.nodes[13]});
            this.nodes[9].setConnections(new TigerNode[]{this.nodes[3], this.nodes[8], this.nodes[10], this.nodes[14]});
            this.nodes[10].setConnections(new TigerNode[]{this.nodes[4], this.nodes[9], this.nodes[11], this.nodes[15]});
            this.nodes[11].setConnections(new TigerNode[]{this.nodes[5], this.nodes[10], this.nodes[12], this.nodes[16]});
            this.nodes[12].setConnections(new TigerNode[]{this.nodes[6], this.nodes[11]});
            this.nodes[13].setConnections(new TigerNode[]{this.nodes[8]});
            this.nodes[14].setConnections(new TigerNode[]{this.nodes[9]});
            this.nodes[15].setConnections(new TigerNode[]{this.nodes[10]});
            this.nodes[16].setConnections(new TigerNode[]{this.nodes[11]});
        }

        @Override
        public void ready() {
            this.lambs = 15;
            TigerNode[] tigerNodeArray = this.nodes;
            int n = this.nodes.length;
            int n2 = 0;
            while (n2 < n) {
                TigerNode n3 = tigerNodeArray[n2];
                n3.setValue(Spot.EMPTY);
                ++n2;
            }
            this.nodes[0].setValue(Spot.TIGER);
            this.nodes[3].setValue(Spot.TIGER);
            this.nodes[4].setValue(Spot.TIGER);
            this.state = State.PLACE_LAMB;
        }

        @Override
        public void process() {
            String header_text;
            switch (this.state) {
                case START: {
                    header_text = "Initializing board...";
                    break;
                }
                case PLACE_LAMB: {
                    header_text = "Lamb player: Place a lamb on an empty tile.";
                    break;
                }
                case PICK_TIGER: {
                    header_text = "Tiger player: Select a tiger";
                    break;
                }
                case MOVE_TIGER: {
                    header_text = "Tiger player: Move this tiger to an adjacent tile.";
                    break;
                }
                case PICK_LAMB: {
                    header_text = "Lamb player: Select a lamb";
                    break;
                }
                case MOVE_LAMB: {
                    header_text = "Lamb player: Move this lamb to an adjacent tile.";
                    break;
                }
                default: {
                    header_text = "someone has won!";
                }
            }
            TigerGame.this.textSize(32.0f);
            TigerGame.this.text(header_text, TigerGame.this.width / 2, 50.0f);
            TigerGame.this.text("lambs unplaced: " + this.lambs, TigerGame.this.width / 2, TigerGame.this.height - 30);
        }

        public void setLambTurn() {
            if (this.lambs > 0) {
                this.setState(State.PLACE_LAMB);
            } else {
                this.setState(State.PICK_LAMB);
            }
        }

        public void checkWin() {
            TigerNode n;
            int n2;
            int n3;
            TigerNode[] tigerNodeArray;
            if (this.lambs == 0) {
                tigerNodeArray = this.nodes;
                n3 = this.nodes.length;
                n2 = 0;
                while (n2 < n3) {
                    n = tigerNodeArray[n2];
                    if (n.getValue() == Spot.LAMB) {
                        return;
                    }
                    ++n2;
                }
                TigerGame.this.winner = "Tigers";
                ((GameManager)this.getParent()).setCurrentScene(3);
            }
            tigerNodeArray = this.nodes;
            n3 = this.nodes.length;
            n2 = 0;
            while (n2 < n3) {
                n = tigerNodeArray[n2];
                if (n.getValue() == Spot.TIGER) {
                    TigerNode[] tigerNodeArray2 = n.getConnections();
                    int n4 = tigerNodeArray2.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        TigerNode t = tigerNodeArray2[n5];
                        switch (t.getValue()) {
                            case EMPTY: {
                                return;
                            }
                            case TIGER: {
                                break;
                            }
                            case LAMB: {
                                if (n.tryCapture(t) == null) break;
                                return;
                            }
                        }
                        ++n5;
                    }
                    TigerGame.this.winner = "Lambs";
                    ((GameManager)this.getParent()).setCurrentScene(3);
                }
                ++n2;
            }
        }

        public void selectNode(TigerNode node) {
            this.selected = node;
        }

        public TigerNode getSelectedNode() {
            return this.selected;
        }

        public void placeLamb() {
            --this.lambs;
        }

        public void setState(State s) {
            this.checkWin();
            this.state = s;
        }
    }

    public abstract class Scene {
        private String name = "Scene";
        private ArrayList<Scene> children = new ArrayList();
        private Scene parent;
        private boolean visible = true;

        public Scene() {
        }

        public Scene(boolean vis) {
            this.visible = vis;
        }

        public Scene(String n) {
            this.name = n;
        }

        public void ready() {
        }

        public void process() {
        }

        public final void _process() {
            if (this.visible) {
                this.process();
                for (Scene s : this.getChildren()) {
                    s._process();
                }
            }
        }

        public ArrayList<Scene> getChildren() {
            return this.children;
        }

        public Scene getChild(int index) {
            return this.children.get(index);
        }

        public Scene addChild(Scene child) {
            child.setParent(this);
            this.children.add(child);
            return child;
        }

        public Scene findChild(String nam) {
            Scene s = null;
            int i = 0;
            while (i < this.getChildren().size() && s == null) {
                if (this.getChild(i).getName() == nam) {
                    s = this.getChild(i);
                }
                ++i;
            }
            return s;
        }

        public Scene removeChild(int index) {
            this.getChild(index).setParent(null);
            return this.children.remove(index);
        }

        public Scene getParent() {
            return this.parent;
        }

        public void setParent(Scene p) {
            this.parent = p;
        }

        public boolean getVis() {
            return this.visible;
        }

        public void setVis(boolean v) {
            this.visible = v;
            if (v) {
                this.ready();
            }
            for (Scene s : this.getChildren()) {
                s.setVis(v);
            }
        }

        public String getName() {
            return this.name;
        }

        public Scene setName(String n) {
            this.name = n;
            return this;
        }
    }

    public static enum Spot {
        EMPTY,
        TIGER,
        LAMB;

    }

    public static enum State {
        START,
        PLACE_LAMB,
        PICK_TIGER,
        MOVE_TIGER,
        PICK_LAMB,
        MOVE_LAMB,
        LAMB_WIN,
        TIGER_WIN;

    }

    public class TigerNode
    extends Scene {
        TigerNode[] connections;
        boolean tiger_start;
        Spot value = Spot.EMPTY;
        NodeButton button;
        int x_pos;
        int y_pos;
        final int NODE_SIZE = 50;

        public TigerNode(int x, int y, boolean ts) {
            this.x_pos = x;
            this.y_pos = y;
            this.tiger_start = ts;
            this.button = (NodeButton)this.addChild(new NodeButton(this.x_pos, this.y_pos, 50, 50));
            if (this.tiger_start) {
                this.value = Spot.TIGER;
            }
        }

        @Override
        public void process() {
            switch (this.value) {
                case EMPTY: {
                    break;
                }
                case TIGER: {
                    TigerGame.this.image(TigerGame.this.tiger_img, this.x_pos + 10, this.y_pos - 25, 40.0f, 40.0f);
                    break;
                }
                case LAMB: {
                    TigerGame.this.image(TigerGame.this.lamb_img, this.x_pos + 10, this.y_pos - 25, 40.0f, 40.0f);
                }
            }
        }

        public void setConnections(TigerNode[] c) {
            this.connections = c;
            TigerNode[] tigerNodeArray = c;
            int n = c.length;
            int n2 = 0;
            while (n2 < n) {
                TigerNode n3 = tigerNodeArray[n2];
                ((NodeWeb)((Play)this.getParent()).getChild(0)).addLine(this.x_pos, this.y_pos, n3.x_pos, n3.y_pos);
                ++n2;
            }
        }

        public boolean isAdjacent(TigerNode other) {
            boolean adj = false;
            TigerNode[] tigerNodeArray = this.getConnections();
            int n = tigerNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TigerNode t = tigerNodeArray[n2];
                if (t == other) {
                    adj = true;
                }
                ++n2;
            }
            return adj;
        }

        public TigerNode[] getConnections() {
            return this.connections;
        }

        public TigerNode getConnection(int i) {
            return this.connections[i];
        }

        public Spot getValue() {
            return this.value;
        }

        public void setValue(Spot v) {
            this.value = v;
        }

        public int getX() {
            return this.x_pos;
        }

        public int getY() {
            return this.y_pos;
        }

        public TigerNode tryCapture(TigerNode lamb) {
            TigerNode landing = null;
            if (this.getValue() == Spot.TIGER && lamb.getValue() == Spot.LAMB) {
                TigerNode tiger = this;
                int[] first_dir = tiger.getDirs(lamb);
                TigerNode[] tigerNodeArray = lamb.getConnections();
                int n = tigerNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TigerNode n3 = tigerNodeArray[n2];
                    int[] new_dir = lamb.getDirs(n3);
                    if (first_dir[0] == new_dir[0] && first_dir[1] == new_dir[1] && n3.getValue() == Spot.EMPTY) {
                        landing = n3;
                    }
                    ++n2;
                }
            } else {
                TigerGame.println((String)"canCapture has been called where it should not have been.");
                TigerGame.println((Object)((Object)this.getValue()));
                TigerGame.println((Object)((Object)lamb.getValue()));
            }
            return landing;
        }

        public int[] getDirs(TigerNode other) {
            int x_dir = other.getX() > this.getX() ? 1 : (other.getX() < this.getX() ? -1 : 0);
            int y_dir = other.getY() > this.getY() ? 1 : (other.getY() < this.getY() ? -1 : 0);
            return new int[]{x_dir, y_dir};
        }
    }

    public class WinScreen
    extends Scene {
        public WinScreen() {
            this.addChild(new NavButton(TigerGame.this.width / 2 - 150, TigerGame.this.height / 2 + 200, 200, 50, 3, "Back to Menu", 24).setVal(0));
            this.addChild(new NavButton(TigerGame.this.width / 2 + 150, TigerGame.this.height / 2 + 200, 200, 50, 3, "Play Again", 24).setVal(1));
        }

        @Override
        public void ready() {
        }

        @Override
        public void process() {
            TigerGame.this.textAlign(3);
            TigerGame.this.textSize(36.0f);
            TigerGame.this.text(String.valueOf(TigerGame.this.winner) + " win!", TigerGame.this.width / 2, 200.0f);
            TigerGame.this.textSize(24.0f);
        }
    }
}

