//The slides for the instructions for the game.
//Imported from my JavaGame project.
public class Instructions extends Scene {
  
  private int page = 0;
  
  public Instructions() {
    addChild( new NavButton(width - 125, height - 65, 200, 50, CENTER, "Menu", 24).setVal(0) );
    addChild( new PageButton(width - 150, height - 125, 50, 50, CENTER, "1", 24).setVal(0) );
    addChild( new PageButton(width - 100, height - 125, 50, 50, CENTER, "2", 24).setVal(1) );
  }
  
  public void process() {
    textAlign(LEFT);
    textSize(24);
    text("TIGER GAME!", 10, 30);
    
    
    if (page == 0) {
      textSize(20);
      text("One player has 3 counters (Tigers); the other has 15 counters (Lambs).", 50, 100);
      
      textSize(24);
      text("Object:", 10, 170);
      
      textSize(20);
      text("For Lambs, to block Tigers so that they cannot move.", 50, 230);
      text("For Tigers, to devour so many Lambs that those remaining are not enough to block them.", 50, 290);
      
      textSize(24);
      text("To Start:", 10, 380);
      
      textSize(20);
      text("Place Tigers on the 3 blue spots.", 50, 440);
    }
    
    else if (page == 1) {
      textSize(24);
      text("To Play:", 10, 100);
      
      textSize(20);
      text("Take turns. Lambs player begins, placing 1 Lamb each turn on any vacant spot (blue or pink).", 10, 170);
      text("In a turn 1 Tiger can move along any line to an adjacent vacant spot.", 10, 230);
      text("If an adjacent spot is occupied by a Lamb, Tiger can devour it by leaping over it to the vacant spot beyond it.", 10, 290);
      text("Tiger must select the lamb that it wants to devour. If the tiger cannot leap in a straight line, it won't work.", 10, 350);
      text("Lambs are only allowed to move when all of them have been placed.", 10, 410);
      text("Then they must move along a line to an adjacent vacant spot.", 10, 470);
      
      
    }
    
  }
  
  public int getPage() {
    return page;
  }
  
  public void setPage(int val) {
    page = val;
  }
  
}

//Button that swaps between pages of the instructions tab.
public class PageButton extends Button {
  
  int page_val = 0;
  
  public PageButton(int x_pos, int y_pos, int wid, int hei, int a, String t, int ts) {
    super(x_pos, y_pos, wid, hei, a, t, ts);
  }
  
  public void onRelease() {
    ((Instructions)getParent()).setPage(page_val);
  }
  
  public Button setVal(int val) {
    page_val = val;
    return this;
  }
  
}
