/* autogenerated by Processing revision 1293 on 2025-01-16 */
import processing.core.*;
import processing.data.*;
import processing.event.*;
import processing.opengl.*;

import java.util.HashMap;
import java.util.ArrayList;
import java.io.File;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;

public class TigerGame extends PApplet {


//Scene that handles game management.
public GameManager gameManager;

//Used for determining what is on a spot.
public enum Spot{EMPTY, TIGER, LAMB};

//Used for keeping track of the current game state.
public enum State{START, PLACE_LAMB, PICK_TIGER, MOVE_TIGER, PICK_LAMB, MOVE_LAMB, LAMB_WIN, TIGER_WIN};

//paths and image objects for the animal icons.
final String TIGER_IMG_PATH = "tiger.jpg";
final String LAMB_IMG_PATH = "lamb.jpg";
PImage tiger_img;
PImage lamb_img;

//used for determining the winner text at the end of the game.
String winner = "";

public void setup() {
  /* size commented out by preprocessor */;
  windowMove(200, 80);
  gameManager = new GameManager();
  tiger_img = loadImage("tiger.jpg");
  lamb_img = loadImage("lamb.jpg");
}

public void draw() {
  gameManager._process();
}
//Generic button class for all buttons to extend from.
//Imported from my JavaGame project.
class Button extends Scene {
  private String name = "Button";
  private boolean lastFramePressed = false;
  
  int x = 0; //x-position
  int y = 0; //y-position
  int w = 1; //width
  int h = 1; //height
  
  boolean can_press = true;
  
  int align = CENTER;
  private float x_mod; //how much the shape needs to be shifted based on its align.
  
  String text = "";
  int text_size = 16;
  int text_color = color(0);
  
  int outline_color = color(0);
  int fill_normal = color(255);
  int fill_hover = color(204);
  int fill_press = color(127);
  
  public Button(int x_pos, int y_pos, int wid, int hei, int a, String t, int ts) {
    x = x_pos;
    y = y_pos;
    w = wid;
    h = hei;
    setAlign(a);
    text = t;
    text_size = ts;
  }
  
  public Button(int x_pos, int y_pos, int wid, int hei, int a) {
    x = x_pos;
    y = y_pos;
    w = wid;
    h = hei;
    setAlign(a);
  }
  
  public Button() {
  }
  
  //Methods that need to be overridden in a child class.
  public void onHover() {}
  public void onPress() {}
  public void onJustPress() {}
  public void onRelease() {}
  
  //When making a child, if you update the process, make sure to call super.process() at the top.
  //This process draws the button based on its current state.
  public void process() {
    
    if (isPressed())       fill(fill_press);
    else if (isHovered())  fill(fill_hover);
    else                   fill(fill_normal);
    stroke(outline_color);
    rect(x - w*x_mod, y - h/2, w, h);
    
    fill(text_color);
    textSize(text_size);
    textAlign(align);
    text(text, x, y + text_size/2);
    
    if (isHovered()) onHover();
    if (isPressed()) onPress();
    if (isJustPressed()) onJustPress();
    if (isJustReleased()) onRelease();
    
    lastFramePressed = isPressed();
  }
  
  
  public boolean isHovered() {
    return can_press && mouseX > x - w*x_mod && mouseX < x + w - w*x_mod && mouseY > y - h/2 && mouseY < y + h/2;
  }
  
  public boolean isPressed() {
    return (isHovered() && mousePressed);
  }
  
  public boolean isJustPressed() {
    return isPressed() && isHovered() && !lastFramePressed;
  }
  
  public boolean isJustReleased() {
    return !isPressed() && isHovered() && lastFramePressed;
  }
  
  public void setCanPress(boolean can) {
    can_press = can;
  }
  
  public boolean getCanPress() {
    return can_press;
  }
  
  //sets the align of both the button's rectangle relative to its position
  //coordinates as well as the alignment of the text.
  public void setAlign(int a) {
    align = a;
    switch (align) {
      case LEFT:
        x_mod = 0;
        break;
      case RIGHT:
        x_mod = 1;
        break;
      case CENTER:
        x_mod = 0.5f;
        break;
      default:
        println("oopsies, setAlign() was called with a value it can't take.");
    }
  }
  
}
//Contains each screen for the game and swaps between them based on
//what cur_scene says it should be.
//Imported from my JavaGame project.
public class GameManager extends Scene {
  
  private int currentScene = 0;
  private Scene mainMenu;      //0
  private Scene play;          //1
  private Scene instructions;  //2
  private Scene winScreen;     //3
  
  final int bg_color = color(204);
  
  public GameManager() {
    mainMenu = addChild( new MainMenu() );
    play = addChild( new Play() );
    instructions = addChild( new Instructions() );
    winScreen = addChild( new WinScreen() );
    setCurrentScene(0);
  }
  
  public void process() {
    background(bg_color);
  }
  
  public void setCurrentScene(int scen) {
    
    if (scen >= 0) {
      currentScene = scen;
      for (Scene s : getChildren()) {
        s.setVis(false);
      }
      getChild(scen).setVis(true);
      
    }
    
    else exit();
    
  }
  
  private int getCurrentScene() {
    return currentScene;
  }
  
}
//The slides for the instructions for the game.
//Imported from my JavaGame project.
public class Instructions extends Scene {
  
  private int page = 0;
  
  public Instructions() {
    addChild( new NavButton(width - 125, height - 65, 200, 50, CENTER, "Menu", 24).setVal(0) );
    addChild( new PageButton(width - 150, height - 125, 50, 50, CENTER, "1", 24).setVal(0) );
    addChild( new PageButton(width - 100, height - 125, 50, 50, CENTER, "2", 24).setVal(1) );
  }
  
  public void process() {
    textAlign(LEFT);
    textSize(24);
    text("TIGER GAME!", 10, 30);
    
    
    if (page == 0) {
      textSize(20);
      text("One player has 3 counters (Tigers); the other has 15 counters (Lambs).", 50, 100);
      
      textSize(24);
      text("Object:", 10, 170);
      
      textSize(20);
      text("For Lambs, to block Tigers so that they cannot move.", 50, 230);
      text("For Tigers, to devour so many Lambs that those remaining are not enough to block them.", 50, 290);
      
      textSize(24);
      text("To Start:", 10, 380);
      
      textSize(20);
      text("Place Tigers on the 3 blue spots.", 50, 440);
    }
    
    else if (page == 1) {
      textSize(24);
      text("To Play:", 10, 100);
      
      textSize(20);
      text("Take turns. Lambs player begins, placing 1 Lamb each turn on any vacant spot (blue or pink).", 10, 170);
      text("In a turn 1 Tiger can move along any line to an adjacent vacant spot.", 10, 230);
      text("If an adjacent spot is occupied by a Lamb, Tiger can devour it by leaping over it to the vacant spot beyond it.", 10, 290);
      text("Tiger must select the lamb that it wants to devour. If the tiger cannot leap in a straight line, it won't work.", 10, 350);
      text("Lambs are only allowed to move when all of them have been placed.", 10, 410);
      text("Then they must move along a line to an adjacent vacant spot.", 10, 470);
      
      
    }
    
  }
  
  public int getPage() {
    return page;
  }
  
  public void setPage(int val) {
    page = val;
  }
  
}

//Button that swaps between pages of the instructions tab.
public class PageButton extends Button {
  
  int page_val = 0;
  
  public PageButton(int x_pos, int y_pos, int wid, int hei, int a, String t, int ts) {
    super(x_pos, y_pos, wid, hei, a, t, ts);
  }
  
  public void onRelease() {
    ((Instructions)getParent()).setPage(page_val);
  }
  
  public Button setVal(int val) {
    page_val = val;
    return this;
  }
  
}
//Contains the title screen and buttons to navigate the game.
//Imported from my JavaGame project.
public class MainMenu extends Scene {
  
  public MainMenu() {
    addChild( new NavButton(width/2, height/2, 200, 50, CENTER, "Play", 24).setVal(1) );
    addChild( new NavButton(width/2, height/2 + 60, 200, 50, CENTER, "Instructions", 24).setVal(2) );
    addChild( new NavButton(width/2, height/2 + 120, 200, 50, CENTER, "Exit", 24).setVal(-1) );
  }
  
  public void process() {
    textAlign(CENTER);
    textSize(36);
    text("Tiger Game", width/2, height/2 - 60);
  }
  
}
//Button for navigating between scenes.
//Imported from my JavaGame project.
public class NavButton extends Button {
  
  private int scene_val;
  
  public NavButton(int x_pos, int y_pos, int wid, int hei, int a) {
    super(x_pos, y_pos, wid, hei, a);
  }
  
  public NavButton(int x_pos, int y_pos, int wid, int hei, int a, String t, int ts) {
    super(x_pos, y_pos, wid, hei, a, t, ts);
  }
  
  public void onRelease() {
    gameManager.setCurrentScene(scene_val);
  }
  
  public Button setVal(int v) {
    scene_val = v;
    return this;
  }
  
}
//purely visual scene that shows the lines that connect the nodes.
//made as its own scene so that it can be added to the game before the other
//nodes, so it can be drawn in the first layer.
public class NodeWeb extends Scene {
  
  //array of coordinates for lines
  ArrayList<int[]> lines = new ArrayList<int[]>();
  
  private String name = "NodeWeb";
  
  public NodeWeb() {
  }
  
  public void process() {
    for (int[] l : lines) line(l[0], l[1], l[2], l[3]);
  }
  
  //adds a line to the list based on 4 coordinates
  public void addLine(int x, int y, int w, int h) {
    lines.add(new int[]{x, y, w, h});
  }
  
}
//The game scene. Contains all the input, output, and logic for the actual game.
public class Play extends Scene {
  
  //the current state of the game based on the State enum.
  State state = State.START;
  
  //the number of lambs the lamb player has left unplaced.
  int lambs;
  
  //the currently selected node.
  TigerNode selected;
  
  //The number of lambs the lamb player starts with.
  final int STARTING_LAMBS = 15;
  
  TigerNode[] nodes = new TigerNode[17];
  
  public Play() {
    addChild( new NodeWeb() );
    addChild( new TigerNode(width/2, height/2 - 150, true) );
    
    addChild( new TigerNode(width/2 - 200, height/2 - 50, false) );
    addChild( new TigerNode(width/2 - 120, height/2 - 50, false) );
    addChild( new TigerNode(width/2 - 40, height/2 - 50, true) );
    addChild( new TigerNode(width/2 + 40, height/2 - 50, true) );
    addChild( new TigerNode(width/2 + 120, height/2 - 50, false) );
    addChild( new TigerNode(width/2 + 200, height/2 - 50, false) );
    
    addChild( new TigerNode(width/2 - 325, height/2 + 50, false) );
    addChild( new TigerNode(width/2 - 195, height/2 + 50, false) );
    addChild( new TigerNode(width/2 - 65, height/2 + 50, false) );
    addChild( new TigerNode(width/2 + 65, height/2 + 50, false) );
    addChild( new TigerNode(width/2 + 195, height/2 + 50, false) );
    addChild( new TigerNode(width/2 + 325, height/2 + 50, false) );
    
    addChild( new TigerNode(width/2 - 255, height/2 + 150, false) );
    addChild( new TigerNode(width/2 - 85, height/2 + 150, false) );
    addChild( new TigerNode(width/2 + 85, height/2 + 150, false) );
    addChild( new TigerNode(width/2 + 255, height/2 + 150, false) );
    
    for (int i = 1; i < 18; i++) {
      nodes[i-1] = (TigerNode)getChild(i);
    }
    
    nodes[0].setConnections(new TigerNode[]{ nodes[2], nodes[3], nodes[4], nodes[5] });
    nodes[1].setConnections(new TigerNode[]{ nodes[1], nodes[7] });
    nodes[2].setConnections(new TigerNode[]{ nodes[0], nodes[1], nodes[3], nodes[8] });
    nodes[3].setConnections(new TigerNode[]{ nodes[0], nodes[2], nodes[4], nodes[9] });
    nodes[4].setConnections(new TigerNode[]{ nodes[0], nodes[3], nodes[5], nodes[10] });
    nodes[5].setConnections(new TigerNode[]{ nodes[0], nodes[4], nodes[6], nodes[11] });
    nodes[6].setConnections(new TigerNode[]{ nodes[5], nodes[12] });
    nodes[7].setConnections(new TigerNode[]{ nodes[1], nodes[8] });
    nodes[8].setConnections(new TigerNode[]{ nodes[2], nodes[7], nodes[9], nodes[13] });
    nodes[9].setConnections(new TigerNode[]{ nodes[3], nodes[8], nodes[10], nodes[14] });
    nodes[10].setConnections(new TigerNode[]{ nodes[4], nodes[9], nodes[11], nodes[15] });
    nodes[11].setConnections(new TigerNode[]{ nodes[5], nodes[10], nodes[12], nodes[16] });
    nodes[12].setConnections(new TigerNode[]{ nodes[6], nodes[11] });
    nodes[13].setConnections(new TigerNode[]{ nodes[8] });
    nodes[14].setConnections(new TigerNode[]{ nodes[9] });
    nodes[15].setConnections(new TigerNode[]{ nodes[10] });
    nodes[16].setConnections(new TigerNode[]{ nodes[11] });
  }
  
  public void ready() {
    
    lambs = STARTING_LAMBS;
    
    for (TigerNode n : nodes) {
      n.setValue(Spot.EMPTY);
    }
    
    nodes[0].setValue(Spot.TIGER);
    nodes[3].setValue(Spot.TIGER);
    nodes[4].setValue(Spot.TIGER);
    
    state = State.PLACE_LAMB;
    
  }
  
  public void process() {
    String header_text;
    //START, PLACE_LAMB, MOVE_TIGER, MOVE_LAMB, LAMB_WIN, TIGER_WIN
    switch (state) {
      case START:
        header_text = "Initializing board...";
        break;
      case PLACE_LAMB:
        header_text = "Lamb player: Place a lamb on an empty tile.";
        break;
      case PICK_TIGER:
        header_text = "Tiger player: Select a tiger";
        break;
      case MOVE_TIGER:
        header_text = "Tiger player: Move this tiger to an adjacent tile.";
        break;
      case PICK_LAMB:
        header_text = "Lamb player: Select a lamb";
        break;
      case MOVE_LAMB:
        header_text = "Lamb player: Move this lamb to an adjacent tile.";
        break;
      default:
        header_text = "someone has won!";
        break;
    }
    
    textSize(32);
    text(header_text, width/2, 50);
    text("lambs unplaced: " + lambs, width/2, height-30);
  }
  
  //decides whether the lambs should be placed or moved.
  public void setLambTurn() {
    if (lambs > 0) {
      setState(State.PLACE_LAMB);
    }
    else {
      setState(State.PICK_LAMB);
    }
  }
  
  //checks to see if either player satisfies the win condition.
  //If so, ends the game and brings you to the results screen.
  public void checkWin() {
    if (lambs == 0) {
      for (TigerNode n : nodes) {
        if (n.getValue() == Spot.LAMB) {
          return;
        }
      }
      
      winner = "Tigers";
      ((GameManager) getParent() ).setCurrentScene(3);
      
    }
    
    for (TigerNode n : nodes) {
      if (n.getValue() == Spot.TIGER) {
        for (TigerNode t : n.getConnections()) {
          switch (t.getValue()) {
            case EMPTY:
              return;
            case TIGER:
              break;
            case LAMB:
              if (n.tryCapture(t) != null) {
                return;
              }
              break;
          }
        }
        
        winner = "Lambs";
        ((GameManager) getParent() ).setCurrentScene(3);
        
      }
    }
  }
  
  public void selectNode(TigerNode node) {
    selected = node;
  }
  
  public TigerNode getSelectedNode() {
    return selected;
  }
  
  public void placeLamb() {
    lambs -= 1;
  }
  
  //set the current state of the game, but checks to see if someone has won first.
  public void setState(State s) {
    checkWin();
    state = s;
  }
  
}
//Generic class that mimics the scene system in the Godot engine.
//Every object used in this project will inherit this class, which allows them
//to interact with each other in a fluid way based on Godot's node tree system.
//Imported from my JavaGame project.
abstract public class Scene {
  
  private String name = "Scene";
  private ArrayList<Scene> children = new ArrayList<Scene>();
  private Scene parent;
  private boolean visible = true;
  
  public Scene() {
  }
  
  public Scene(boolean vis) {
    visible = vis;
  }
  
  public Scene(String n) {
    name = n;
  }
  
  //Called each time a scene becomes visible.
  //Meant to be overwritten by the child class.
  public void ready() {
  }
  
  //Called every frame as long as the scene is visible.
  //Meant to be overwritten by the child class.
  public void process() {
  }
  
  //Function that allows the process function to work.
  final public void _process() {
    if (visible) {
      process();
      for (Scene s : getChildren()) {
        s._process();
      }
    }
  }
  
  //Returns the array of scenes that are children of this scene.
  public ArrayList<Scene> getChildren() {
    return children;
  }
  
  //Returns a single child scene based on its index.
  public Scene getChild(int index) {
    return children.get(index);
  }
  
  //Adds an additional child scene and returns said scene.
  public Scene addChild(Scene child) {
    child.setParent(this);
    children.add(child);
    return child;
  }
  
  //Traverses the scene tree starting with this scene
  //and returns the first instance of a scene with the 
  //desired name, or null if it doesn't exist.
  public Scene findChild(String nam) {
    Scene s = null;
    int i = 0;
    while (i < getChildren().size() && s == null) {
      if (getChild(i).getName() == nam) {
        s = getChild(i);
      }
      i++;
    }
    return s;
  }
  
  //Removes and returns a child scene based on its index.
  public Scene removeChild(int index) {
    getChild(index).setParent(null);
    return children.remove(index);
  }
  
  //Returns the parent scene of this scene.
  //To access the parent scene's functions, you must
  //convert it to its specific subclass first.
  public Scene getParent() {
    return parent;
  }
  
  //Sets this scene's parent to a new parent scene.
  public void setParent(Scene p) {
    parent = p;
  }
  
  public boolean getVis() {
    return visible;
  }
  
  public void setVis(boolean v) {
    visible = v;
    if (v) ready();
    for (Scene s : getChildren()) {
      s.setVis(v);
    }
  }
  
  public String getName() {
    return name;
  }
  
  //Returns the scene so that you can declare the name of a scene when created without a constructor and set it to a child all in one line.
  public Scene setName(String n) {
    name = n;
    return this;
  }
  
}
public class TigerNode extends Scene {

  //Every TigerNode that is connected to this one.
  TigerNode[] connections;

  //Whether or not a tiger starts on this spot.
  //button will be blue if true, pink otherwise.
  boolean tiger_start;

  //Uses the Spot enum to determine what is in this spot.
  Spot value = Spot.EMPTY;

  //The button to press to interact with this node.
  NodeButton button;

  int x_pos;
  int y_pos;

  //side of a node's square.
  final int NODE_SIZE = 50;

  public TigerNode(int x, int y, boolean ts) {
    x_pos = x;
    y_pos = y;
    tiger_start = ts;
    button = (NodeButton) addChild( new NodeButton(x_pos, y_pos, NODE_SIZE, NODE_SIZE) );
    if (tiger_start) value = Spot.TIGER;
  }

  public void process() {
    switch (value) {
      case EMPTY:
        break;
      case TIGER:
        image(tiger_img, x_pos+ 10, y_pos-NODE_SIZE/2, NODE_SIZE*0.8f, NODE_SIZE*0.8f);
        break;
      case LAMB:
        image(lamb_img, x_pos+ 10, y_pos-NODE_SIZE/2, NODE_SIZE*0.8f, NODE_SIZE*0.8f);
        break;
    }
  }

  public void setConnections(TigerNode[] c) {
    connections = c;
    for (TigerNode n : c) {
      ((NodeWeb)((Play)getParent()).getChild(0)).addLine(x_pos, y_pos, n.x_pos, n.y_pos);
    }
  }
  
  public boolean isAdjacent(TigerNode other) {
    boolean adj = false;
    for (TigerNode t : getConnections()) {
      if (t == other) adj = true;
    }
    return adj;
  }

  public TigerNode[] getConnections() {
    return connections;
  }

  public TigerNode getConnection(int i) {
    return connections[i];
  }
  
  public Spot getValue() {
    return value;
  }
  
  public void setValue(Spot v) {
    value = v;
  }

  public int getX() {
    return x_pos;
  }

  public int getY() {
    return y_pos;
  }
  
  //Assuming this node contains a tiger and the parameter contains a lamb.
  //Sees if this node can capture the lamb node and returns the node the tiger will land.
  //returns null if the tiger cannot capture the lamb.
  public TigerNode tryCapture(TigerNode lamb) {
    TigerNode landing = null;
    if (this.getValue() == Spot.TIGER && lamb.getValue() == Spot.LAMB) {
      
      TigerNode tiger = this;
      
      int[] first_dir = tiger.getDirs(lamb);
      
      for (TigerNode n : lamb.getConnections()) {
        int[] new_dir = lamb.getDirs(n);
        if (first_dir[0] == new_dir[0] && first_dir[1] == new_dir[1] && n.getValue() == Spot.EMPTY) {
          landing = n;
        }
      }
    }
    else {
      println("canCapture has been called where it should not have been.");
      println(this.getValue());
      println(lamb.getValue());
    }
    
    return landing;
  }
  
  //helper method for canCapture that checks the relative direction of two nodes.
  public int[] getDirs(TigerNode other) {
    int x_dir;
    int y_dir;
    
    if (other.getX() > this.getX())       x_dir = 1;
    else if (other.getX() < this.getX())  x_dir = -1;
    else                                  x_dir = 0;
    
    if (other.getY() > this.getY())       y_dir = 1;
    else if (other.getY() < this.getY())  y_dir = -1;
    else                                  y_dir = 0;
    
    return new int[]{x_dir, y_dir};
  }
  
}

class NodeButton extends Button {

  TigerNode node;
  Play play;

  public NodeButton(int x_pos, int y_pos, int wid, int hei) {
    super(x_pos, y_pos, wid, hei, CENTER);
  }

  public void ready() {
    node = (TigerNode) getParent();
    play = (Play) node.getParent();

    if (node.tiger_start) {
      fill_normal = color(0, 0, 255);
      fill_hover = color(0, 0, 204);
      fill_press = color(0, 0, 127);
    } else {
      fill_normal = color(255, 0, 255);
      fill_hover = color(204, 0, 204);
      fill_press = color(127, 0, 127);
    }
  }
  
  public void onRelease() {
    
    switch (play.state) {
      //START, PLACE_LAMB, MOVE_TIGER, MOVE_LAMB, LAMB_WIN, TIGER_WIN
      case PLACE_LAMB:
        if (node.getValue() == Spot.EMPTY) {
          node.setValue(Spot.LAMB);
          play.placeLamb();
          play.setState(State.PICK_TIGER);
        }
        break;
      case PICK_TIGER:
        if (node.getValue() == Spot.TIGER) {
          play.selectNode(node);
          play.setState(State.MOVE_TIGER);
        }
        break;
      case MOVE_TIGER:
        if (play.getSelectedNode().isAdjacent(node)) {
          switch (node.getValue()) {
            case EMPTY:
              node.setValue(Spot.TIGER);
              play.getSelectedNode().setValue(Spot.EMPTY);
              play.setLambTurn();
              break;
            case TIGER:
              play.setState(State.PICK_TIGER);
              break;
            case LAMB:
              if (play.getSelectedNode().tryCapture(node) != null) {
                TigerNode land = play.getSelectedNode().tryCapture(node);
                play.getSelectedNode().setValue(Spot.EMPTY);
                node.setValue(Spot.EMPTY);
                land.setValue(Spot.TIGER);
                play.setLambTurn();
              }
              break;
          }
        }
        else {
          play.setState(State.PICK_TIGER);
        }
        break;
      case PICK_LAMB:
        if (node.getValue() == Spot.LAMB) {
          play.selectNode(node);
          play.setState(State.MOVE_LAMB);
        }
        break;
      case MOVE_LAMB:
        if (node.getValue() == Spot.EMPTY) {
          if (play.getSelectedNode().isAdjacent(node)) {
            node.setValue(Spot.LAMB);
            play.getSelectedNode().setValue(Spot.EMPTY);
            play.setState(State.PICK_TIGER);
          }
        }
        else {
          play.setState(State.PICK_LAMB);
        }
        break;
      default:
        break;
    }
    
  }
  
}
//Screen for when you complete a successful order.
//Imported from my JavaGame project.
public class WinScreen extends Scene {
  
  public WinScreen() {
    addChild( new NavButton(width/2 - 150, height/2 + 200, 200, 50, CENTER, "Back to Menu", 24).setVal(0) );
    addChild( new NavButton(width/2 + 150, height/2 + 200, 200, 50, CENTER, "Play Again", 24).setVal(1) );
  }
  
  public void ready() {
    
  }
  
  public void process() {
    textAlign(CENTER);
    textSize(36);
    text(winner + " win!", width/2, 200);
    textSize(24);
  }
  
}


  public void settings() { size(960, 540); }

  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "TigerGame" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
