//The game scene. Contains all the input, output, and logic for the actual game.
public class Play extends Scene {
  
  //the current state of the game based on the State enum.
  State state = State.START;
  
  //the number of lambs the lamb player has left unplaced.
  int lambs;
  
  //the currently selected node.
  TigerNode selected;
  
  //The number of lambs the lamb player starts with.
  final int STARTING_LAMBS = 15;
  
  TigerNode[] nodes = new TigerNode[17];
  
  public Play() {
    addChild( new NodeWeb() );
    addChild( new TigerNode(width/2, height/2 - 150, true) );
    
    addChild( new TigerNode(width/2 - 200, height/2 - 50, false) );
    addChild( new TigerNode(width/2 - 120, height/2 - 50, false) );
    addChild( new TigerNode(width/2 - 40, height/2 - 50, true) );
    addChild( new TigerNode(width/2 + 40, height/2 - 50, true) );
    addChild( new TigerNode(width/2 + 120, height/2 - 50, false) );
    addChild( new TigerNode(width/2 + 200, height/2 - 50, false) );
    
    addChild( new TigerNode(width/2 - 325, height/2 + 50, false) );
    addChild( new TigerNode(width/2 - 195, height/2 + 50, false) );
    addChild( new TigerNode(width/2 - 65, height/2 + 50, false) );
    addChild( new TigerNode(width/2 + 65, height/2 + 50, false) );
    addChild( new TigerNode(width/2 + 195, height/2 + 50, false) );
    addChild( new TigerNode(width/2 + 325, height/2 + 50, false) );
    
    addChild( new TigerNode(width/2 - 255, height/2 + 150, false) );
    addChild( new TigerNode(width/2 - 85, height/2 + 150, false) );
    addChild( new TigerNode(width/2 + 85, height/2 + 150, false) );
    addChild( new TigerNode(width/2 + 255, height/2 + 150, false) );
    
    for (int i = 1; i < 18; i++) {
      nodes[i-1] = (TigerNode)getChild(i);
    }
    
    nodes[0].setConnections(new TigerNode[]{ nodes[2], nodes[3], nodes[4], nodes[5] });
    nodes[1].setConnections(new TigerNode[]{ nodes[1], nodes[7] });
    nodes[2].setConnections(new TigerNode[]{ nodes[0], nodes[1], nodes[3], nodes[8] });
    nodes[3].setConnections(new TigerNode[]{ nodes[0], nodes[2], nodes[4], nodes[9] });
    nodes[4].setConnections(new TigerNode[]{ nodes[0], nodes[3], nodes[5], nodes[10] });
    nodes[5].setConnections(new TigerNode[]{ nodes[0], nodes[4], nodes[6], nodes[11] });
    nodes[6].setConnections(new TigerNode[]{ nodes[5], nodes[12] });
    nodes[7].setConnections(new TigerNode[]{ nodes[1], nodes[8] });
    nodes[8].setConnections(new TigerNode[]{ nodes[2], nodes[7], nodes[9], nodes[13] });
    nodes[9].setConnections(new TigerNode[]{ nodes[3], nodes[8], nodes[10], nodes[14] });
    nodes[10].setConnections(new TigerNode[]{ nodes[4], nodes[9], nodes[11], nodes[15] });
    nodes[11].setConnections(new TigerNode[]{ nodes[5], nodes[10], nodes[12], nodes[16] });
    nodes[12].setConnections(new TigerNode[]{ nodes[6], nodes[11] });
    nodes[13].setConnections(new TigerNode[]{ nodes[8] });
    nodes[14].setConnections(new TigerNode[]{ nodes[9] });
    nodes[15].setConnections(new TigerNode[]{ nodes[10] });
    nodes[16].setConnections(new TigerNode[]{ nodes[11] });
  }
  
  void ready() {
    
    lambs = STARTING_LAMBS;
    
    for (TigerNode n : nodes) {
      n.setValue(Spot.EMPTY);
    }
    
    nodes[0].setValue(Spot.TIGER);
    nodes[3].setValue(Spot.TIGER);
    nodes[4].setValue(Spot.TIGER);
    
    state = State.PLACE_LAMB;
    
  }
  
  void process() {
    String header_text;
    //START, PLACE_LAMB, MOVE_TIGER, MOVE_LAMB, LAMB_WIN, TIGER_WIN
    switch (state) {
      case START:
        header_text = "Initializing board...";
        break;
      case PLACE_LAMB:
        header_text = "Lamb player: Place a lamb on an empty tile.";
        break;
      case PICK_TIGER:
        header_text = "Tiger player: Select a tiger";
        break;
      case MOVE_TIGER:
        header_text = "Tiger player: Move this tiger to an adjacent tile.";
        break;
      case PICK_LAMB:
        header_text = "Lamb player: Select a lamb";
        break;
      case MOVE_LAMB:
        header_text = "Lamb player: Move this lamb to an adjacent tile.";
        break;
      default:
        header_text = "someone has won!";
        break;
    }
    
    textSize(32);
    text(header_text, width/2, 50);
    text("lambs unplaced: " + lambs, width/2, height-30);
  }
  
  //decides whether the lambs should be placed or moved.
  public void setLambTurn() {
    if (lambs > 0) {
      setState(State.PLACE_LAMB);
    }
    else {
      setState(State.PICK_LAMB);
    }
  }
  
  //checks to see if either player satisfies the win condition.
  //If so, ends the game and brings you to the results screen.
  public void checkWin() {
    if (lambs == 0) {
      for (TigerNode n : nodes) {
        if (n.getValue() == Spot.LAMB) {
          return;
        }
      }
      
      winner = "Tigers";
      ((GameManager) getParent() ).setCurrentScene(3);
      
    }
    
    for (TigerNode n : nodes) {
      if (n.getValue() == Spot.TIGER) {
        for (TigerNode t : n.getConnections()) {
          switch (t.getValue()) {
            case EMPTY:
              return;
            case TIGER:
              break;
            case LAMB:
              if (n.tryCapture(t) != null) {
                return;
              }
              break;
          }
        }
        
        winner = "Lambs";
        ((GameManager) getParent() ).setCurrentScene(3);
        
      }
    }
  }
  
  public void selectNode(TigerNode node) {
    selected = node;
  }
  
  public TigerNode getSelectedNode() {
    return selected;
  }
  
  public void placeLamb() {
    lambs -= 1;
  }
  
  //set the current state of the game, but checks to see if someone has won first.
  public void setState(State s) {
    checkWin();
    state = s;
  }
  
}
